/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.sensors.fov.FieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.ApogyAddonsSensorsFOVUIFactory;
import org.eclipse.apogy.addons.sensors.fov.ui.ApogyAddonsSensorsFOVUIPackage;
import org.eclipse.apogy.addons.sensors.fov.ui.FieldOfViewEntry3DToolNode;
import org.eclipse.apogy.addons.sensors.fov.ui.FieldOfViewEntry3DToolTargetVisibility;
import org.eclipse.apogy.addons.sensors.fov.ui.impl.FieldOfViewEntry3DToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodePath;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.RGBA;

public class FieldOfViewEntry3DToolCustomImpl
extends FieldOfViewEntry3DToolImpl {
    @Override
    public void setDefaultVectorColor(RGBA newDefaultVectorColor) {
        super.setDefaultVectorColor(newDefaultVectorColor);
        this.updateEntryStates();
    }

    @Override
    public void setVectorColorSelectionVisible(RGBA newVectorColorSelectionVisible) {
        super.setVectorColorSelectionVisible(newVectorColorSelectionVisible);
        this.updateEntryStates();
    }

    @Override
    public void setVectorColorSelectionEntered(RGBA newVectorColorSelectionEntered) {
        super.setVectorColorSelectionEntered(newVectorColorSelectionEntered);
        this.updateEntryStates();
    }

    public void initialise() {
        super.initialise();
        if (this.getFieldOfViewEntry3DToolNode() == null) {
            FieldOfViewEntry3DToolNode toolNode = ApogyAddonsSensorsFOVUIFactory.eINSTANCE.createFieldOfViewEntry3DToolNode();
            if (this.getName() != null) {
                toolNode.setDescription("Node associated with the FieldOfViewEntry3DTool named <" + this.getName() + ">");
                toolNode.setNodeId("FieldOfViewEntry3DTool_" + this.getName().replaceAll(" ", "_"));
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__FIELD_OF_VIEW_ENTRY3_DTOOL_NODE, (Object)toolNode, true);
        }
        this.forceToAndFromReload();
        this.attachFieldOfViewEntry3DToolNode();
        this.updateVector();
    }

    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        this.attachFieldOfViewEntry3DToolNode();
        this.updateVector();
    }

    public void variablesInstantiated() {
        super.variablesInstantiated();
        this.forceToAndFromReload();
        this.updateVector();
    }

    public void variablesCleared() {
        super.variablesCleared();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, null, true);
    }

    public void setActive(boolean newActive) {
        super.setActive(newActive);
        if (newActive) {
            this.forceToAndFromReload();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fieldOfViewEntry3DToolNode != null) {
            this.detachFieldOfViewEntry3DToolNode();
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__FIELD_OF_VIEW_ENTRY3_DTOOL_NODE, null);
    }

    public void selectionChanged(NodeSelection nodeSelection) {
        if (!this.isDisposed()) {
            Node node = nodeSelection.getSelectedNode();
            Tuple3d relativePosition = null;
            if (nodeSelection.getRelativeIntersectionPoint() != null) {
                relativePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
            }
            if (!this.isFromNodeLock()) {
                this.updateFromNode(node);
            } else if (!this.isToNodeLock()) {
                this.updateToNode(node, relativePosition);
            }
        }
    }

    public void pointsRelativePoseChanged(Matrix4d newPose) {
        if (!this.isDisposed()) {
            this.updateVector();
        }
    }

    protected void updateEntryStates() {
        if (this.getFov() != null && this.getToNode() != null && this.getFromNode() != null) {
            Tuple3d point = this.getFromPositionInFOVFrame();
            boolean visible = this.getFov().isPointVisible(point);
            boolean inside = this.getFov().isPointInside(point);
            if (inside) {
                if (this.getCurrentVectorColor() != this.getVectorColorSelectionEntered()) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__CURRENT_VECTOR_COLOR, (Object)this.getVectorColorSelectionEntered(), true);
                }
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__TARGET_VISIBILITY, (Object)FieldOfViewEntry3DToolTargetVisibility.INSIDE_VOLUME, true);
            } else if (visible) {
                if (this.getCurrentVectorColor() != this.getVectorColorSelectionVisible()) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__CURRENT_VECTOR_COLOR, (Object)this.getVectorColorSelectionVisible(), true);
                }
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__TARGET_VISIBILITY, (Object)FieldOfViewEntry3DToolTargetVisibility.VISIBLE, true);
            } else {
                if (this.getCurrentVectorColor() != this.getDefaultVectorColor()) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__CURRENT_VECTOR_COLOR, (Object)this.getDefaultVectorColor(), true);
                }
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__TARGET_VISIBILITY, (Object)FieldOfViewEntry3DToolTargetVisibility.NOT_VISIBLE, true);
            }
        }
    }

    protected Tuple3d getFromPositionInFOVFrame() {
        Matrix4d transform = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(this.toNode, this.fromNode);
        Point3d position = new Point3d();
        transform.transform(new Point3d(this.getToRelativePosition().asTuple3d()), position);
        return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)position);
    }

    protected void updateVector() {
        if (this.getToAbsolutePosition() != null && this.getFromAbsolutePosition() != null) {
            Vector3d to = new Vector3d(this.getToAbsolutePosition().asTuple3d());
            Vector3d from = new Vector3d(this.getFromAbsolutePosition().asTuple3d());
            to.sub((javax.vecmath.Tuple3d)from);
            double length = to.length();
            if (length < this.getMaximumVectorLength()) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__CURRENT_VECTOR_LENGTH, (Object)length, true);
            } else {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__CURRENT_VECTOR_LENGTH, (Object)this.getMaximumVectorLength(), true);
            }
        }
        this.updateEntryStates();
    }

    protected void updateFromNode(Node node) {
        if (node instanceof FieldOfView) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)node);
            Tuple3d zero = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_RELATIVE_POSITION, (Object)zero, true);
            FieldOfView fieldOfView = (FieldOfView)node;
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVUIPackage.Literals.FIELD_OF_VIEW_ENTRY3_DTOOL__FOV, (Object)fieldOfView, true);
            NodePath nodePath = null;
            if (node != null) {
                GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
                nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, node);
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE_NODE_PATH, nodePath);
            this.attachFieldOfViewEntry3DToolNode();
        }
        this.updateVector();
    }

    protected void updateToNode(Node node, Tuple3d relativePosition) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)node, true);
        if (ApogyCoreTopologyFacade.INSTANCE.getApogyTopology() != null) {
            GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
            NodePath nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, node);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE_NODE_PATH, (Object)nodePath, true);
        }
        if (relativePosition != null) {
            Tuple3d newRelativePosition = (Tuple3d)EcoreUtil.copy((EObject)relativePosition);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_RELATIVE_POSITION, (Object)newRelativePosition, true);
        }
        this.updateVector();
    }

    protected void attachFieldOfViewEntry3DToolNode() {
        if (this.getFieldOfViewEntry3DToolNode() != null && this.getRootNode() instanceof GroupNode) {
            ((GroupNode)this.getRootNode()).getChildren().add((Object)this.getFieldOfViewEntry3DToolNode());
        }
    }

    protected void detachFieldOfViewEntry3DToolNode() {
        if (this.getRootNode() instanceof GroupNode) {
            GroupNode groupNode = (GroupNode)this.getRootNode();
            groupNode.getChildren().remove((Object)this.getFieldOfViewEntry3DToolNode());
        }
    }

    protected void forceToAndFromReload() {
        super.forceToAndFromReload();
        this.updateFromNode(this.getFromNode());
        this.updateToNode(this.getToNode(), this.getToRelativePosition());
    }
}

