/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs;

import geometry_msgs.PoseStamped;
import geometry_msgs.PoseStampedMQTT;
import java.util.ArrayList;
import java.util.List;
import nav_msgs.Path;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ros.internal.message.RawMessage;
import std_msgs.Header;
import std_msgs.HeaderMQTT;

public class PathMQTT
implements Path {
    private Header header;
    private List<PoseStamped> poses = new ArrayList<PoseStamped>();

    public PathMQTT() {
    }

    public PathMQTT(String jsonString) throws Exception {
        this.parseJSONString(jsonString);
    }

    public RawMessage toRawMessage() {
        return null;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header value) {
        this.header = value;
    }

    public List<PoseStamped> getPoses() {
        return this.poses;
    }

    public void setPoses(List<PoseStamped> value) {
        this.poses = value;
    }

    public static JSONObject toJSONObject(Path path) throws Exception {
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> poses = new ArrayList<JSONObject>();
        for (PoseStamped pose : path.getPoses()) {
            JSONObject object = PoseStampedMQTT.toJSONObject(pose);
            poses.add(object);
        }
        JSONArray array = new JSONArray(poses);
        jsonObject.put("poses", (Object)array);
        return jsonObject;
    }

    protected void parseJSONString(String jsonString) throws Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.has("header")) {
            this.setHeader(new HeaderMQTT(jsonObject.getJSONObject("header")));
        }
        ArrayList<PoseStampedMQTT> poses = new ArrayList<PoseStampedMQTT>();
        JSONArray array = jsonObject.getJSONArray("poses");
        int i = 0;
        while (i < array.length()) {
            JSONObject object = array.getJSONObject(i);
            PoseStampedMQTT pose = new PoseStampedMQTT(object);
            poses.add(pose);
            ++i;
        }
        this.getPoses().clear();
        this.getPoses().addAll(poses);
    }
}

