/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.impl;

import geometry_msgs.Point;
import geometry_msgs.PointMQTT;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTFacade;
import org.eclipse.apogy.addons.mqtt.MQTTClient;
import org.eclipse.apogy.addons.mqtt.MQTTClientConnectionOptions;
import org.eclipse.apogy.addons.mqtt.SimpleSSLMQTTClientConnectionOptions;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSFactory;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorClient;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServiceID;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceAnswer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceCall;
import org.eclipse.apogy.addons.mqtt.ros.impl.ApogyAddonsMQTTROSFacadeImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.json.JSONArray;
import org.json.JSONObject;
import sensor_msgs.PointCloud2MQTT;
import sensor_msgs.PointFieldMQTT;
import shape_msgs.MeshMQTT;
import shape_msgs.MeshTriangle;
import shape_msgs.MeshTriangleMQTT;
import std_msgs.Header;
import std_msgs.HeaderMQTT;

public class ApogyAddonsMQTTROSFacadeCustomImpl
extends ApogyAddonsMQTTROSFacadeImpl {
    public static final String ARBITRATION_REQUEST_SUFFIX = "/arbitrator/request";
    public static final String ARBITRATION_RESPONSE_SUFFIX = "/arbitrator/response";
    public static final String ROS_REQUEST_SUFFIX = "/request";
    public static final String ROS_RESPONSE_SUFFIX = "/response";

    @Override
    public Header converToHeader(JSONObject jsonObject) throws Exception {
        return new HeaderMQTT(jsonObject);
    }

    @Override
    public boolean[] convertToBooleanArray(JSONArray jsonArray) throws Exception {
        boolean[] array = new boolean[jsonArray.length()];
        int i = 0;
        while (i < jsonArray.length()) {
            array[i] = jsonArray.getBoolean(i);
            ++i;
        }
        return array;
    }

    @Override
    public int[] convertToIntegerArray(JSONArray jsonArray) throws Exception {
        int[] array = new int[jsonArray.length()];
        int i = 0;
        while (i < jsonArray.length()) {
            array[i] = jsonArray.getInt(i);
            ++i;
        }
        return array;
    }

    @Override
    public float[] convertToFloatArray(JSONArray jsonArray) throws Exception {
        float[] array = new float[jsonArray.length()];
        int i = 0;
        while (i < jsonArray.length()) {
            array[i] = (float)jsonArray.getDouble(i);
            ++i;
        }
        return array;
    }

    @Override
    public double[] convertToDoubleArray(JSONArray jsonArray) throws Exception {
        double[] array = new double[jsonArray.length()];
        int i = 0;
        while (i < jsonArray.length()) {
            array[i] = jsonArray.getDouble(i);
            ++i;
        }
        return array;
    }

    @Override
    public JSONObject convertToJSON(MQTTROSServiceCall serviceCall) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serviceName", (Object)serviceCall.getServiceName());
        jsonObject.put("rosRequest", (Object)serviceCall.getRosRequest());
        jsonObject.put("userID", (Object)serviceCall.getUserID());
        jsonObject.put("token", serviceCall.getToken());
        jsonObject.put("timeout", serviceCall.getTimeout());
        jsonObject.put("time", serviceCall.getTime().getTime());
        if (serviceCall.getResponse() != null) {
            jsonObject.put("response", (Object)this.convertToJSON(serviceCall.getResponse()));
        }
        return jsonObject;
    }

    @Override
    public MQTTROSServiceCall convertToJMQTTROSServiceCall(JSONObject jsonObject) throws Exception {
        MQTTROSServiceCall serviceCall = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceCall();
        serviceCall.setServiceName(jsonObject.getString("serviceName"));
        JSONObject rosRequest = jsonObject.getJSONObject("rosRequest");
        serviceCall.setRosRequest(rosRequest);
        serviceCall.setUserID(jsonObject.getString("userID"));
        serviceCall.setToken(jsonObject.getLong("token"));
        serviceCall.setTimeout(jsonObject.getLong("timeout"));
        serviceCall.setTime(new Date(jsonObject.getLong("time")));
        JSONObject answer = jsonObject.optJSONObject("response");
        if (answer != null) {
            serviceCall.setResponse(this.convertToMQTTROSServiceAnswer(answer));
        }
        return serviceCall;
    }

    @Override
    public JSONObject convertToJSON(MQTTROSServiceAnswer serviceAnswer) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serviceName", (Object)serviceAnswer.getServiceName());
        jsonObject.put("userID", (Object)serviceAnswer.getUserID());
        jsonObject.put("token", serviceAnswer.getToken());
        if (serviceAnswer.getResponse() != null) {
            jsonObject.put("response", serviceAnswer.getResponse());
        }
        if (serviceAnswer.getException() != null) {
            jsonObject.put("exception", (Object)serviceAnswer.getException().getMessage());
        }
        return jsonObject;
    }

    @Override
    public MQTTROSServiceAnswer convertToMQTTROSServiceAnswer(JSONObject jsonObject) throws Exception {
        String exceptionString;
        MQTTROSServiceAnswer answer = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceAnswer();
        answer.setServiceName(jsonObject.getString("serviceName"));
        answer.setUserID(jsonObject.getString("userID"));
        answer.setToken(jsonObject.getLong("token"));
        String response = jsonObject.optString("response");
        if (response != null) {
            answer.setResponse(response);
        }
        if ((exceptionString = jsonObject.optString("exception")) != null && exceptionString.length() > 0) {
            answer.setException(new Throwable(exceptionString));
        }
        return answer;
    }

    @Override
    public MQTTROSServiceCall createMQTTROSServiceCall(String serviceName, long token, long timeout, JSONObject rosRequest) {
        MQTTROSServiceCall serviceCall = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceCall();
        serviceCall.setTime(new Date());
        serviceCall.setServiceName(serviceName);
        serviceCall.setToken(token);
        serviceCall.setTimeout(timeout);
        serviceCall.setRosRequest(rosRequest);
        return serviceCall;
    }

    @Override
    public MQTTROSServiceAnswer createMQTTROSServiceAnswer(MQTTROSServiceCall serviceCall) {
        MQTTROSServiceAnswer answer = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSServiceAnswer();
        answer.setServiceName(serviceCall.getServiceName());
        answer.setUserID(serviceCall.getUserID());
        answer.setToken(serviceCall.getToken());
        return answer;
    }

    @Override
    public String getMQTTROSArbitratorServerRequestTopicName(String serviceName) {
        return String.valueOf(serviceName) + ARBITRATION_REQUEST_SUFFIX;
    }

    @Override
    public String getMQTTROSArbitratorServerResponseTopicName(String serviceName) {
        return String.valueOf(serviceName) + ARBITRATION_RESPONSE_SUFFIX;
    }

    @Override
    public String getROSRequestTopicName(String serviceName) {
        return String.valueOf(serviceName) + ROS_REQUEST_SUFFIX;
    }

    @Override
    public String getROSResponseTopicName(String serviceName) {
        return String.valueOf(serviceName) + ROS_RESPONSE_SUFFIX;
    }

    @Override
    public MQTTROSArbitratorClient createMQTTROSArbitratorClient(String name, String brokerHostName, int port, MQTTClientConnectionOptions connectionOptions) {
        MQTTClient mqttClient = ApogyAddonsMQTTFacade.INSTANCE.createMQTTClient(name, brokerHostName, port, null, connectionOptions);
        MQTTROSArbitratorClient client = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSArbitratorClient();
        client.setName(name);
        client.setMqttClient(mqttClient);
        return client;
    }

    @Override
    public MQTTROSArbitratorServer createMQTTROSArbitratorServer(String name, String clientSideBrokerHostName, int clientSidePort, MQTTClientConnectionOptions clientSideConnectionOptions, String rosSideBrokerHostName, int rosSidePort, MQTTClientConnectionOptions rosSideConnectionOptions, List<String> serviceTopicNames) {
        MQTTROSArbitratorServer server = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSArbitratorServer();
        server.setName(name);
        MQTTClient clientSide = ApogyAddonsMQTTFacade.INSTANCE.createMQTTClient(String.valueOf(name) + "_ClientSide", clientSideBrokerHostName, clientSidePort, null, clientSideConnectionOptions);
        MQTTClient rosSide = ApogyAddonsMQTTFacade.INSTANCE.createMQTTClient(String.valueOf(name) + "_ROSSide", rosSideBrokerHostName, rosSidePort, null, rosSideConnectionOptions);
        server.setClientSide(clientSide);
        server.setRosSide(rosSide);
        for (String serviceName : serviceTopicNames) {
            MQTTROSArbitratorServiceID service = ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSArbitratorServiceID();
            service.setServiceName(serviceName);
            server.getServices().add((Object)service);
        }
        return server;
    }

    @Override
    public void saveToFile(MQTTROSArbitratorServer server, String filePath) throws Exception {
        SimpleSSLMQTTClientConnectionOptions sslOptions;
        MQTTROSArbitratorServer copy = (MQTTROSArbitratorServer)EcoreUtil.copy((EObject)server);
        if (copy.getClientSide().getConnectionOptions() != null) {
            copy.getClientSide().getConnectionOptions().setPassword(null);
            if (copy.getClientSide().getConnectionOptions() instanceof SimpleSSLMQTTClientConnectionOptions) {
                sslOptions = (SimpleSSLMQTTClientConnectionOptions)copy.getClientSide().getConnectionOptions();
                sslOptions.setKeyStorePassword(null);
            }
        }
        if (copy.getRosSide().getConnectionOptions() != null) {
            copy.getRosSide().getConnectionOptions().setPassword(null);
            if (copy.getRosSide().getConnectionOptions() instanceof SimpleSSLMQTTClientConnectionOptions) {
                sslOptions = (SimpleSSLMQTTClientConnectionOptions)copy.getRosSide().getConnectionOptions();
                sslOptions.setKeyStorePassword(null);
            }
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("server", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)("file://" + filePath)));
        resource.getContents().add((Object)copy);
        resource.save(Collections.EMPTY_MAP);
    }

    @Override
    public MQTTROSArbitratorServer loadFromFile(String filePath) throws Exception {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("server", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createURI((String)filePath), true);
        MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)resource.getContents().get(0);
        return server;
    }

    @Override
    public PointCloud2MQTT convertToPointCloud2MQTT(CartesianCoordinatesSet cartesianCoordinatesSet) throws Exception {
        PointCloud2MQTT pc = new PointCloud2MQTT();
        PointFieldMQTT pfx = new PointFieldMQTT();
        pfx.setName("x");
        pfx.setDatatype((byte)7);
        pfx.setCount(1);
        PointFieldMQTT pfy = new PointFieldMQTT();
        pfy.setName("y");
        pfy.setDatatype((byte)7);
        pfy.setOffset(4);
        pfy.setCount(1);
        PointFieldMQTT pfz = new PointFieldMQTT();
        pfz.setName("z");
        pfz.setDatatype((byte)7);
        pfz.setOffset(8);
        pfz.setCount(1);
        pc.getFields().add(pfx);
        pc.getFields().add(pfy);
        pc.getFields().add(pfz);
        pc.setHeight(1);
        pc.setWidth(cartesianCoordinatesSet.getPoints().size());
        pc.setIsBigendian(false);
        pc.setIsDense(true);
        pc.setPointStep(16);
        pc.setRowStep(cartesianCoordinatesSet.getPoints().size() * 16);
        ChannelBuffer data = ChannelBuffers.buffer((ByteOrder)ByteOrder.LITTLE_ENDIAN, (int)(cartesianCoordinatesSet.getPoints().size() * 16));
        for (CartesianPositionCoordinates pt : cartesianCoordinatesSet.getPoints()) {
            data.writeFloat((float)pt.getX());
            data.writeFloat((float)pt.getY());
            data.writeFloat((float)pt.getZ());
            data.writeFloat(1.0f);
        }
        pc.setData(data);
        return pc;
    }

    @Override
    public MeshMQTT convertCartesianTriangularMeshToMeshMQTT(CartesianTriangularMesh cartesianTriangularMesh) throws Exception {
        MeshMQTT meshMQTT = new MeshMQTT();
        HashMap<CartesianPositionCoordinates, Integer> poinToIndexMap = new HashMap<CartesianPositionCoordinates, Integer>();
        int i = 0;
        while (i < cartesianTriangularMesh.getPoints().size()) {
            CartesianPositionCoordinates p = (CartesianPositionCoordinates)cartesianTriangularMesh.getPoints().get(i);
            poinToIndexMap.put(p, i);
            PointMQTT vertex = new PointMQTT(p.getX(), p.getY(), p.getZ());
            meshMQTT.getVertices().add(vertex);
            ++i;
        }
        for (CartesianTriangle t : cartesianTriangularMesh.getPolygons()) {
            int p0 = (Integer)poinToIndexMap.get(t.getVertices().get(0));
            int p1 = (Integer)poinToIndexMap.get(t.getVertices().get(1));
            int p2 = (Integer)poinToIndexMap.get(t.getVertices().get(2));
            MeshTriangleMQTT triangle = new MeshTriangleMQTT();
            int[] verticesIndex = new int[]{p0, p1, p2};
            triangle.setVertexIndices(verticesIndex);
            meshMQTT.getTriangles().add(triangle);
        }
        return meshMQTT;
    }

    @Override
    public CartesianTriangularMesh convertMeshMQTTToCartesianTriangularMesh(MeshMQTT meshMQTT) throws Exception {
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        HashMap<Integer, CartesianPositionCoordinates> indexToPointMap = new HashMap<Integer, CartesianPositionCoordinates>();
        ArrayList<CartesianPositionCoordinates> tmpPoints = new ArrayList<CartesianPositionCoordinates>();
        int i = 0;
        while (i < meshMQTT.getVertices().size()) {
            Point p = meshMQTT.getVertices().get(i);
            CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(p.getX(), p.getY(), p.getZ());
            indexToPointMap.put(i, point);
            tmpPoints.add(point);
            ++i;
        }
        mesh.getPoints().addAll(tmpPoints);
        ArrayList<CartesianTriangle> tmpTriangles = new ArrayList<CartesianTriangle>();
        int i2 = 0;
        while (i2 < meshMQTT.getTriangles().size()) {
            MeshTriangle t = meshMQTT.getTriangles().get(i2);
            if (t.getVertexIndices().length == 3) {
                CartesianPositionCoordinates v1 = (CartesianPositionCoordinates)indexToPointMap.get(t.getVertexIndices()[0]);
                CartesianPositionCoordinates v2 = (CartesianPositionCoordinates)indexToPointMap.get(t.getVertexIndices()[1]);
                CartesianPositionCoordinates v3 = (CartesianPositionCoordinates)indexToPointMap.get(t.getVertexIndices()[2]);
                CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v1, v2, v3);
                tmpTriangles.add(triangle);
            }
            ++i2;
        }
        mesh.getPolygons().addAll(tmpTriangles);
        return mesh;
    }
}

