/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ros.internal.message.RawMessage;
import sensor_msgs.PointCloud2;
import sensor_msgs.PointField;
import sensor_msgs.PointFieldMQTT;
import std_msgs.Header;
import std_msgs.HeaderMQTT;

public class PointCloud2MQTT
implements PointCloud2 {
    private Header header;
    private int height = 0;
    private int width = 0;
    private boolean bigendian = false;
    private List<PointField> fields = new ArrayList<PointField>();
    private int pointStep = 0;
    private int rowStep = 0;
    private ChannelBuffer data;
    private boolean dense = false;

    public PointCloud2MQTT() {
    }

    public PointCloud2MQTT(String jsonString) throws Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        this.parseJSONObject(jsonObject);
    }

    public PointCloud2MQTT(JSONObject jsonObject) throws Exception {
        this.parseJSONObject(jsonObject);
    }

    public RawMessage toRawMessage() {
        return null;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header value) {
        this.header = value;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public List<PointField> getFields() {
        return this.fields;
    }

    public void setFields(List<PointField> value) {
        this.fields.clear();
        this.fields.addAll(value);
    }

    public boolean getIsBigendian() {
        return this.bigendian;
    }

    public void setIsBigendian(boolean value) {
        this.bigendian = value;
    }

    public int getPointStep() {
        return this.pointStep;
    }

    public void setPointStep(int value) {
        this.pointStep = value;
    }

    public int getRowStep() {
        return this.rowStep;
    }

    public void setRowStep(int value) {
        this.rowStep = value;
    }

    public ChannelBuffer getData() {
        return this.data;
    }

    public void setData(ChannelBuffer value) {
        this.data = value;
    }

    public boolean getIsDense() {
        return this.dense;
    }

    public void setIsDense(boolean value) {
        this.dense = value;
    }

    public JSONObject toJSONObject() throws Exception {
        return PointCloud2MQTT.toJSONObject(this);
    }

    public static JSONObject toJSONObject(PointCloud2 pointCloud2) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (pointCloud2.getHeader() != null) {
            jsonObject.put("header", (Object)HeaderMQTT.toJSONObject(pointCloud2.getHeader()));
        }
        jsonObject.put("height", pointCloud2.getHeight());
        jsonObject.put("width", pointCloud2.getWidth());
        ArrayList<JSONObject> tmp = new ArrayList<JSONObject>();
        for (PointField pointField : pointCloud2.getFields()) {
            tmp.add(PointFieldMQTT.toJSONObject(pointField));
        }
        JSONArray jsonArray = new JSONArray(tmp);
        jsonObject.put("fields", (Object)jsonArray);
        jsonObject.put("is_bigendian", pointCloud2.getIsBigendian());
        jsonObject.put("point_step", pointCloud2.getPointStep());
        jsonObject.put("row_step", pointCloud2.getRowStep());
        String scanDataString = DataValue.Base64.encode((byte[])pointCloud2.getData().array());
        jsonObject.put("data", (Object)scanDataString);
        jsonObject.put("is_dense", pointCloud2.getIsDense());
        return jsonObject;
    }

    protected void parseJSONObject(JSONObject jsonObject) throws Exception {
        if (jsonObject.has("header")) {
            this.setHeader(new HeaderMQTT(jsonObject.getJSONObject("header")));
        }
        this.setHeight(jsonObject.getInt("height"));
        this.setWidth(jsonObject.getInt("width"));
        this.fields.clear();
        JSONArray array = jsonObject.getJSONArray("fields");
        int i = 0;
        while (i < array.length()) {
            JSONObject object = (JSONObject)array.get(i);
            PointFieldMQTT pf = new PointFieldMQTT(object);
            this.fields.add(pf);
            ++i;
        }
        this.setIsBigendian(jsonObject.getBoolean("is_bigendian"));
        this.setPointStep(jsonObject.getInt("point_step"));
        this.setRowStep(jsonObject.getInt("row_step"));
        String d = jsonObject.getString("data");
        byte[] scanData = DataValue.Base64.decode((String)d);
        int size = this.getWidth() * this.getHeight() * 16;
        ByteOrder byteOrder = null;
        byteOrder = this.getIsBigendian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ChannelBuffer data = ChannelBuffers.buffer((ByteOrder)byteOrder, (int)size);
        data.writeBytes(scanData);
        this.setData(data);
        this.setIsDense(jsonObject.getBoolean("is_dense"));
    }
}

