/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VoxelFilterType implements Enumerator
{
    MEDIAN(0, "MEDIAN", "Median"),
    AVERAGE(1, "AVERAGE", "Average");

    public static final int MEDIAN_VALUE = 0;
    public static final int AVERAGE_VALUE = 1;
    private static final VoxelFilterType[] VALUES_ARRAY;
    public static final List<VoxelFilterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VoxelFilterType[]{MEDIAN, AVERAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VoxelFilterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VoxelFilterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VoxelFilterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VoxelFilterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VoxelFilterType get(int value) {
        switch (value) {
            case 0: {
                return MEDIAN;
            }
            case 1: {
                return AVERAGE;
            }
        }
        return null;
    }

    private VoxelFilterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

