/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSetExtent;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.geometry.data3d.impl.CartesianCoordinatesSetImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class CartesianCoordinatesSetCustomImpl
extends CartesianCoordinatesSetImpl {
    private int currentPointId = 0;
    private Map<CartesianPositionCoordinates, Integer> pointsToPointIdMap;

    protected CartesianCoordinatesSetCustomImpl() {
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(CartesianCoordinatesSet.class) == 0 && (notification.getEventType() == 3 || notification.getEventType() == 5) && notification.getNewValue() != null) {
                    if (notification.getNewValue() instanceof List) {
                        List points = (List)notification.getNewValue();
                        for (CartesianPositionCoordinates point : points) {
                            CartesianCoordinatesSetCustomImpl.this.pointAdded(point);
                        }
                    } else {
                        CartesianPositionCoordinates point = (CartesianPositionCoordinates)notification.getNewValue();
                        CartesianCoordinatesSetCustomImpl.this.pointAdded(point);
                    }
                }
            }
        });
    }

    @Override
    public CartesianCoordinatesSetExtent getExtent() {
        return Geometry3DUtilities.getCartesianCoordinatesSetExtent(this.getPoints());
    }

    private Map<CartesianPositionCoordinates, Integer> getPointsToPointIdMap() {
        if (this.pointsToPointIdMap == null) {
            this.pointsToPointIdMap = new HashMap<CartesianPositionCoordinates, Integer>();
        }
        return this.pointsToPointIdMap;
    }

    public int getPointId(CartesianPositionCoordinates point) {
        Integer pid = this.getPointsToPointIdMap().get(point);
        int pidValue = pid == null ? -1 : pid;
        return pidValue;
    }

    protected void pointAdded(CartesianPositionCoordinates point) {
        this.getPointsToPointIdMap().put(point, this.currentPointId++);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof CartesianCoordinatesSet) {
            CartesianCoordinatesSet pointCloud = (CartesianCoordinatesSet)obj;
            equals = pointCloud.getPoints().size() == this.getPoints().size();
            int i = 0;
            while (i < pointCloud.getPoints().size() && equals) {
                CartesianPositionCoordinates pSource = (CartesianPositionCoordinates)pointCloud.getPoints().get(i);
                CartesianPositionCoordinates pTarget = (CartesianPositionCoordinates)this.getPoints().get(i);
                Point3d p = pSource.asPoint3d();
                p.sub((Tuple3d)pTarget.asPoint3d());
                p.absolute();
                equals = p.x <= 1.0E-10 && p.y <= 1.0E-10 && p.z <= 1.0E-10;
                ++i;
            }
        }
        return equals;
    }
}

