/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.moon.ApogyCoreEnvironmentMoonFacade;
import org.eclipse.apogy.core.environment.moon.ApogyCoreEnvironmentMoonPackage;
import org.eclipse.apogy.core.environment.moon.SelenographicCoordinates;
import org.eclipse.apogy.core.environment.moon.impl.SelenographicCoordinatesRectangleImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class SelenographicCoordinatesRectangleCustomImpl
extends SelenographicCoordinatesRectangleImpl {
    public static final double MOON_RADIUS_KM = 1737.4;
    protected EContentAdapter adapter;

    @Override
    public SelenographicCoordinates getCenter() {
        SelenographicCoordinates tmp = super.getCenter();
        if (tmp == null) {
            tmp = this.computeCenter();
        }
        return tmp;
    }

    @Override
    public void setNorthWestCorner(SelenographicCoordinates newNorthWestCorner) {
        SelenographicCoordinates previous = this.getNorthWestCorner();
        if (previous != null) {
            previous.eAdapters().remove((Object)this.getAdapter());
        }
        super.setNorthWestCorner(newNorthWestCorner);
        if (newNorthWestCorner != null) {
            newNorthWestCorner.eAdapters().add((Object)this.getAdapter());
        }
        this.updateDerived();
    }

    @Override
    public void setSouthEastCorner(SelenographicCoordinates newSouthEastCorner) {
        SelenographicCoordinates previous = this.getSouthEastCorner();
        if (previous != null) {
            previous.eAdapters().remove((Object)this.getAdapter());
        }
        super.setSouthEastCorner(newSouthEastCorner);
        if (newSouthEastCorner != null) {
            newSouthEastCorner.eAdapters().add((Object)this.getAdapter());
        }
        this.updateDerived();
    }

    protected void updateDerived() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentMoonPackage.Literals.SELENOGRAPHIC_COORDINATES_RECTANGLE__CENTER, (Object)this.computeCenter(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentMoonPackage.Literals.SELENOGRAPHIC_COORDINATES_RECTANGLE__NORTHERN_EDGE_WIDTH, (Object)this.computeNorthernEdgeWidth(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentMoonPackage.Literals.SELENOGRAPHIC_COORDINATES_RECTANGLE__SOUTHERN_EDGE_WIDTH, (Object)this.computeSouthernEdgeWidth(), true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentMoonPackage.Literals.SELENOGRAPHIC_COORDINATES_RECTANGLE__NORTH_SOUTH_HEIGHT, (Object)this.computeNorthSouthHeight(), true);
    }

    protected SelenographicCoordinates computeCenter() {
        SelenographicCoordinates center = null;
        if (this.getNorthWestCorner() != null && this.getSouthEastCorner() != null) {
            double centerLongitude = (this.getNorthWestCorner().getLongitude() + this.getSouthEastCorner().getLongitude()) / 2.0;
            double centerLatitude = (this.getNorthWestCorner().getLatitude() + this.getSouthEastCorner().getLatitude()) / 2.0;
            double centerElevation = (this.getNorthWestCorner().getElevation() + this.getSouthEastCorner().getElevation()) / 2.0;
            center = ApogyCoreEnvironmentMoonFacade.INSTANCE.createSelenographicCoordinates(centerLongitude, centerLatitude, centerElevation);
        }
        return center;
    }

    protected double computeNorthernEdgeWidth() {
        if (this.getNorthWestCorner() != null && this.getSouthEastCorner() != null) {
            double latitudeRadius = this.getLatitudeRadiusKM(this.getNorthWestCorner().getLatitude());
            double deltaLongitude = Math.abs(this.getNorthWestCorner().getLongitude() - this.getSouthEastCorner().getLongitude());
            return deltaLongitude * latitudeRadius;
        }
        return 0.0;
    }

    protected double computeSouthernEdgeWidth() {
        if (this.getNorthWestCorner() != null && this.getSouthEastCorner() != null) {
            double latitudeRadius = this.getLatitudeRadiusKM(this.getSouthEastCorner().getLatitude());
            double deltaLongitude = Math.abs(this.getNorthWestCorner().getLongitude() - this.getSouthEastCorner().getLongitude());
            return deltaLongitude * latitudeRadius;
        }
        return 0.0;
    }

    protected double computeNorthSouthHeight() {
        if (this.getNorthWestCorner() != null && this.getSouthEastCorner() != null) {
            double deltaLatitude = Math.abs(this.getNorthWestCorner().getLatitude() - this.getSouthEastCorner().getLatitude());
            double radius = 1737.4 + (this.getNorthWestCorner().getElevation() + this.getSouthEastCorner().getElevation()) / 2.0 * 0.001;
            return deltaLatitude * radius;
        }
        return 0.0;
    }

    protected double getLatitudeRadiusKM(double latitude) {
        double radius = 1737.4 + (this.getNorthWestCorner().getElevation() + this.getSouthEastCorner().getElevation()) / 2.0 * 0.001;
        return radius * Math.sin(1.5707963267948966 - latitude);
    }

    protected EContentAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    SelenographicCoordinatesRectangleCustomImpl.this.updateDerived();
                }
            };
        }
        return this.adapter;
    }
}

