/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.las.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.apogy.common.geometry.data3d.las.ApogyCommonGeometryData3DLASFactory;
import org.eclipse.apogy.common.geometry.data3d.las.EdgeOfFlightLine;
import org.eclipse.apogy.common.geometry.data3d.las.LASPoint;
import org.eclipse.apogy.common.geometry.data3d.las.ScanDirection;
import org.eclipse.apogy.common.geometry.data3d.las.impl.ApogyCommonGeometryData3DLASFacadeImpl;
import org.eclipse.apogy.common.lang.java.io.LittleEndianDataInputStream;

public class ApogyCommonGeometryData3DLASFacadeCustomImpl
extends ApogyCommonGeometryData3DLASFacadeImpl {
    @Override
    public LASPoint createPoint(int formatID, byte[] data) throws IOException {
        if (formatID >= 4) {
            throw new IllegalArgumentException("Invalid point format");
        }
        LASPoint point = ApogyCommonGeometryData3DLASFactory.eINSTANCE.createLASPoint();
        ByteArrayInputStream bai = new ByteArrayInputStream(data);
        LittleEndianDataInputStream input = new LittleEndianDataInputStream((InputStream)bai);
        int x = input.readInt();
        point.setX(x);
        int y = input.readInt();
        point.setY(y);
        int z = input.readInt();
        point.setZ(z);
        int intensity = input.readUnsignedShort();
        point.setIntensity(intensity);
        byte b = input.readByte();
        int returnNumberMask = -32;
        byte returnNumber = (byte)((b & returnNumberMask) >> 5);
        int nReturnsMask = 28;
        byte nReturns = (byte)((b & nReturnsMask) >> 2);
        int scanDirFlag = 2;
        int scanDir = (b & scanDirFlag) >> 1;
        byte eflMask = 1;
        int efl = b & eflMask;
        point.setReturnNumber(returnNumber);
        point.setNumberOfReturns(nReturns);
        point.setScanDirection(ScanDirection.get(scanDir));
        point.setEdgeOfFlightLine(EdgeOfFlightLine.get(efl));
        int classification = input.readUnsignedByte();
        point.setClassification((short)classification);
        byte scanAngle = input.readByte();
        point.setScanAngleRank(scanAngle);
        int userData = input.readUnsignedByte();
        point.setUserData((short)userData);
        int pointSourceId = input.readUnsignedShort();
        point.setPointSourceId(pointSourceId);
        if (formatID == 1 || formatID == 3) {
            double gpsTime = input.readDouble();
            point.setGpsTime(gpsTime);
        }
        if (formatID == 2) {
            int red = input.readUnsignedShort();
            point.setRed(red);
            int green = input.readUnsignedShort();
            point.setGreen(green);
            int blue = input.readUnsignedShort();
            point.setBlue(blue);
        }
        input.close();
        return point;
    }
}

