/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProgramRuntimeState implements Enumerator
{
    NOT_INITIALIZED(0, "NOT_INITIALIZED", "Not Initialized"),
    INITIALIZED(1, "INITIALIZED", "Initialized"),
    RUNNING(2, "RUNNING", "Running"),
    SUSPENDED(3, "SUSPENDED", "Suspended"),
    TERMINATED(4, "TERMINATED", "Terminated"),
    FAILED(5, "FAILED", "Failed"),
    RUNNING_SUSPENDED(6, "RUNNING_SUSPENDED", "Running Suspended"),
    RUNNING_TERMINATED(7, "RUNNING_TERMINATED", "Running Terminated");

    public static final int NOT_INITIALIZED_VALUE = 0;
    public static final int INITIALIZED_VALUE = 1;
    public static final int RUNNING_VALUE = 2;
    public static final int SUSPENDED_VALUE = 3;
    public static final int TERMINATED_VALUE = 4;
    public static final int FAILED_VALUE = 5;
    public static final int RUNNING_SUSPENDED_VALUE = 6;
    public static final int RUNNING_TERMINATED_VALUE = 7;
    private static final ProgramRuntimeState[] VALUES_ARRAY;
    public static final List<ProgramRuntimeState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProgramRuntimeState[]{NOT_INITIALIZED, INITIALIZED, RUNNING, SUSPENDED, TERMINATED, FAILED, RUNNING_SUSPENDED, RUNNING_TERMINATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProgramRuntimeState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProgramRuntimeState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProgramRuntimeState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProgramRuntimeState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProgramRuntimeState get(int value) {
        switch (value) {
            case 0: {
                return NOT_INITIALIZED;
            }
            case 1: {
                return INITIALIZED;
            }
            case 2: {
                return RUNNING;
            }
            case 3: {
                return SUSPENDED;
            }
            case 4: {
                return TERMINATED;
            }
            case 5: {
                return FAILED;
            }
            case 6: {
                return RUNNING_SUSPENDED;
            }
            case 7: {
                return RUNNING_TERMINATED;
            }
        }
        return null;
    }

    private ProgramRuntimeState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

