/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.delegates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.delegates.InvocatorDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocatorDelegateRegistry {
    private static final Logger Logger = LoggerFactory.getLogger(InvocatorDelegateRegistry.class);
    public static final String INVOCATOR_DELEGATE_POINT_ID = "org.eclipse.apogy.core.invocator.invocatorDelegate";
    public static final String INVOCATOR_DELEGATE_POINT_ID_INVOCATOR_DELEGATE_CLASS = "invocatorDelegateClass";
    private static InvocatorDelegateRegistry instance = null;
    private Map<Class<? extends Type>, InvocatorDelegate> invocatorDelegatesMap;

    private InvocatorDelegateRegistry() {
    }

    public static InvocatorDelegateRegistry getInstance() {
        if (instance == null) {
            instance = new InvocatorDelegateRegistry();
        }
        return instance;
    }

    public InvocatorDelegate getInvocatorDelegate(Class<? extends Type> typeClass) {
        if (typeClass != null) {
            InvocatorDelegate delegate = null;
            if (typeClass != null) {
                Class<? extends Type> closestMatch = null;
                for (Class<? extends Type> c : this.getInvocatorDelegatesMap().keySet()) {
                    if (c == null || !c.isAssignableFrom(typeClass)) continue;
                    if (closestMatch == null || closestMatch.isAssignableFrom(c)) {
                        closestMatch = c;
                        continue;
                    }
                    if (c.isAssignableFrom(closestMatch)) continue;
                    throw new IllegalArgumentException("Cannot determine appropriate adapter");
                }
                delegate = this.getInvocatorDelegatesMap().get(closestMatch);
            }
            return delegate;
        }
        return null;
    }

    protected Map<Class<? extends Type>, InvocatorDelegate> getInvocatorDelegatesMap() {
        if (this.invocatorDelegatesMap == null) {
            this.invocatorDelegatesMap = new HashMap<Class<? extends Type>, InvocatorDelegate>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(INVOCATOR_DELEGATE_POINT_ID);
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                try {
                    InvocatorDelegate delegate = (InvocatorDelegate)contributor.createExecutableExtension(INVOCATOR_DELEGATE_POINT_ID_INVOCATOR_DELEGATE_CLASS);
                    Class<? extends Type> typeClass = delegate.getHandledTypeClass();
                    this.invocatorDelegatesMap.put(typeClass, delegate);
                    Logger.info("Loaded InvocatorDelegate <" + delegate.getClass().getName() + ">.");
                }
                catch (CoreException e) {
                    Logger.error("Failed to load contributed InvocatorDelegate from <" + contributor.getContributor().getName() + ">.", (Throwable)e);
                }
                ++i;
            }
        }
        return this.invocatorDelegatesMap;
    }
}

