/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.impl;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.impl.OperationCallsListProgramRuntimeImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCallsListProgramRuntimeCustomImpl
extends OperationCallsListProgramRuntimeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(OperationCallsListProgramRuntimeCustomImpl.class);

    @Override
    public void init() {
        Diagnostic diagnosticContext;
        if (this.getProgram() instanceof OperationCallsList && (diagnosticContext = Diagnostician.INSTANCE.validate((EObject)this.getProgram())).getSeverity() == 0) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.INITIALIZED, true);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_CURRENTLY_EXECUTED, (Object)-1, true);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_LAST_EXECUTED, (Object)-1, true);
            Logger.info("Started program <" + this.getProgram().getName() + "> execution.");
            return;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.NOT_INITIALIZED, true);
        Logger.error("Cannot run program <" + this.getProgram().getName() + "> !");
    }

    @Override
    public void terminate() {
        if (this.getState() == ProgramRuntimeState.RUNNING || this.getState() == ProgramRuntimeState.RUNNING_SUSPENDED) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.RUNNING_TERMINATED, true);
        } else {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.TERMINATED, true);
        }
        Logger.info("Program <" + this.getProgram().getName() + " terminated.");
    }

    @Override
    public void resume() {
        if (this.getState() == ProgramRuntimeState.SUSPENDED) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.INITIALIZED, true);
        }
        if (this.getState() != ProgramRuntimeState.INITIALIZED) {
            this.init();
            if (this.getState() != ProgramRuntimeState.INITIALIZED) {
                this.stepOver();
            }
        } else {
            this.stepOver();
        }
        Logger.info("Program <" + this.getProgram().getName() + " resumed.");
    }

    @Override
    public void suspend() {
        if (this.getState() == ProgramRuntimeState.RUNNING) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.RUNNING_SUSPENDED, true);
        } else if (this.getState() != ProgramRuntimeState.RUNNING_TERMINATED) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.SUSPENDED, true);
        }
        Logger.info("Program <" + this.getProgram().getName() + " suspended.");
    }

    @Override
    public void stepInto() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stepOver() {
        if (this.indexLastExecuted == this.getOperationCallsList().getOperationCalls().size() - 1) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.TERMINATED, true);
        } else if (this.getState() != ProgramRuntimeState.TERMINATED) {
            if (this.getState() == ProgramRuntimeState.SUSPENDED) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.RUNNING_SUSPENDED, true);
            } else {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.RUNNING, true);
            }
            Job job = new Job("Executing OperationCallsList"){

                protected IStatus run(IProgressMonitor monitor) {
                    AbstractOperationCall next = (AbstractOperationCall)OperationCallsListProgramRuntimeCustomImpl.this.getOperationCallsList().getOperationCalls().get(OperationCallsListProgramRuntimeCustomImpl.this.indexLastExecuted + 1);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)OperationCallsListProgramRuntimeCustomImpl.this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_CURRENTLY_EXECUTED, (Object)OperationCallsListProgramRuntimeCustomImpl.this.getOperationCallsList().getOperationCalls().indexOf((Object)next), true);
                    Logger.info("Executing Ops Call <" + next.getName() + ">...");
                    ApogyCoreInvocatorFacade.INSTANCE.exec(next);
                    if (OperationCallsListProgramRuntimeCustomImpl.this.getState() != ProgramRuntimeState.TERMINATED) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)OperationCallsListProgramRuntimeCustomImpl.this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_CURRENTLY_EXECUTED, (Object)-1, true);
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)OperationCallsListProgramRuntimeCustomImpl.this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALLS_LIST_PROGRAM_RUNTIME__INDEX_LAST_EXECUTED, (Object)OperationCallsListProgramRuntimeCustomImpl.this.getOperationCallsList().getOperationCalls().indexOf((Object)next));
                    }
                    if (OperationCallsListProgramRuntimeCustomImpl.this.getState() == ProgramRuntimeState.RUNNING_TERMINATED) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)OperationCallsListProgramRuntimeCustomImpl.this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.TERMINATED, true);
                    } else if (OperationCallsListProgramRuntimeCustomImpl.this.getState() == ProgramRuntimeState.RUNNING_SUSPENDED) {
                        if (next == OperationCallsListProgramRuntimeCustomImpl.this.getOperationCallsList().getOperationCalls().get(OperationCallsListProgramRuntimeCustomImpl.this.getOperationCallsList().getOperationCalls().size() - 1)) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)OperationCallsListProgramRuntimeCustomImpl.this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.TERMINATED, true);
                            Logger.info("Program execution completed.");
                        } else {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)OperationCallsListProgramRuntimeCustomImpl.this, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_PROGRAM_RUNTIME__STATE, (Object)ProgramRuntimeState.SUSPENDED, true);
                        }
                    } else if (OperationCallsListProgramRuntimeCustomImpl.this.getState() == ProgramRuntimeState.RUNNING) {
                        OperationCallsListProgramRuntimeCustomImpl.this.stepOver();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    @Override
    public void stepReturn() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private OperationCallsList getOperationCallsList() {
        if (this.getProgram() instanceof OperationCallsList) {
            return (OperationCallsList)this.getProgram();
        }
        return null;
    }
}

