/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.Vector;
import org.eclipse.apogy.common.topology.addons.primitives.ui.VectorSceneObject;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorJME3SceneObject
extends DefaultJME3SceneObject<Vector>
implements VectorSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(VectorJME3SceneObject.class);
    private Adapter adapter = null;
    private ColorRGBA vectorColor = ColorRGBA.White;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();
    private Geometry vectorGeometry = this.createVectorGeometry();

    public VectorJME3SceneObject(Vector topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)topologyNode, jme3RenderEngineDelegate);
        this.getAttachmentNode().attachChild((Spatial)this.vectorGeometry);
        ((Vector)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.vectorGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.vectorGeometry);
        }
        this.vectorGeometry = this.createVectorGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.vectorGeometry);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.vectorGeometry);
        return geometries;
    }

    public void setColor(final RGBA rgb) {
        if (rgb != null) {
            this.vectorColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        if (VectorJME3SceneObject.this.vectorGeometry != null) {
                            Material mat = VectorJME3SceneObject.this.createVectorMaterial();
                            VectorJME3SceneObject.this.vectorGeometry.setMaterial(mat);
                        }
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to set color to <" + rgb + ">.", t);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Failed to set color to <" + rgb + ">.");
        }
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((Vector)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public int getLineWidth() {
        return 0;
    }

    public void setLineWidth(int lineWidth) {
    }

    public void initialize() {
        this.requestUpdate();
    }

    private Geometry createVectorGeometry() {
        Mesh mesh = this.createVectorMesh();
        Material material = this.createVectorMaterial();
        Geometry geometry = new Geometry("Vector Body", mesh);
        geometry.setMaterial(material);
        return geometry;
    }

    private Mesh createVectorMesh() {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f p1 = new Vector3f((float)((Vector)this.getTopologyNode()).getCoordinates().getX(), (float)((Vector)this.getTopologyNode()).getCoordinates().getY(), (float)((Vector)this.getTopologyNode()).getCoordinates().getZ());
        verticesList.add(p0);
        verticesList.add(p1);
        indexesList.add(verticesList.indexOf(p0));
        indexesList.add(verticesList.indexOf(p1));
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private Material createVectorMaterial() {
        Material material = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setColor("Color", this.vectorColor.clone());
        return material;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Vector) {
                        int featureId = msg.getFeatureID(Vector.class);
                        switch (featureId) {
                            case 4: {
                                VectorJME3SceneObject.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

