/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeLayout;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.EObjectCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractECollectionComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, ItemObject> {
    public static final String TREE_COLUMN_MIN_WIDTH = "TREE_COLUMN_MIN_WIDTH";
    private TreeViewer viewer;
    private Composite detailComposite;
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();

    public AbstractECollectionComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        this(parent, style, featurePath, eStructuralFeature, null);
    }

    public AbstractECollectionComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    private ECollectionCompositeSettings getECollectionCompositeSettings() {
        return (ECollectionCompositeSettings)this.getCompositeSettings();
    }

    @Override
    protected void internalRootEObjectChanged(RootEObject rootEObject, ResolvedEObject resolvedEObject) {
        if (this.getECollectionCompositeSettings().isCollectionSectionDisplayed()) {
            this.setInput(resolvedEObject);
        }
        this.internalSelectionChanged(this.getCurrentSelection());
        this.selectionChanged(this.getCurrentSelection());
        if (this.getECollectionCompositeSettings().isDetailSectionDisplayed()) {
            this.refreshDetails(null);
        }
    }

    public IStructuredSelection getCurrentSelection() {
        return this.viewer == null ? new StructuredSelection() : this.viewer.getStructuredSelection();
    }

    protected final void setInput(ResolvedEObject resolvedEObject) {
        if (this.getViewer() != null && !this.getViewer().getTree().isDisposed()) {
            this.getViewer().setInput(resolvedEObject);
        }
    }

    @Override
    protected Composite createContentComposite(Composite parent, int style) {
        this.addListener(12, e -> {
            this.viewer = null;
        });
        ScrolledForm wrapperForm = this.getFormToolkit().createScrolledForm(parent);
        this.getFormToolkit().paintBordersFor((Composite)wrapperForm);
        wrapperForm.getBody().setLayout((Layout)new FillLayout());
        Composite composite = this.getFormToolkit().createComposite(wrapperForm.getBody(), 0);
        this.getFormToolkit().paintBordersFor(composite);
        composite.setLayout((Layout)new FillLayout(this.getECollectionCompositeSettings().getLayout() == ECollectionCompositeLayout.HORIZONTAL ? 256 : 512));
        if (this.getECollectionCompositeSettings().isCollectionSectionDisplayed()) {
            this.createCollectionComposite(composite, style);
        }
        if (this.getECollectionCompositeSettings().isDetailSectionDisplayed()) {
            Section sctnDetail = this.getFormToolkit().createSection(composite, this.getECollectionCompositeSettings().getDetailSectionTitle() == null || this.getECollectionCompositeSettings().getDetailSectionTitle().isEmpty() ? 4096 : 256);
            this.getFormToolkit().paintBordersFor((Composite)sctnDetail);
            if (this.getECollectionCompositeSettings().getDetailSectionTitle() != null && !this.getECollectionCompositeSettings().getDetailSectionTitle().isEmpty()) {
                sctnDetail.setText(this.getECollectionCompositeSettings().getDetailSectionTitle());
            }
            Composite compositeDetailSection = this.getFormToolkit().createComposite((Composite)sctnDetail, 2048);
            this.getFormToolkit().paintBordersFor(compositeDetailSection);
            sctnDetail.setClient((Control)compositeDetailSection);
            compositeDetailSection.setLayout((Layout)new GridLayout(1, false));
            compositeDetailSection.setLayoutData((Object)new GridData(4, 4, true, true));
            ScrolledComposite compositeDetailContainer = new ScrolledComposite(compositeDetailSection, 768);
            this.getFormToolkit().paintBordersFor((Composite)compositeDetailContainer);
            compositeDetailContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            compositeDetailContainer.setLayout((Layout)new FillLayout());
            compositeDetailContainer.setAlwaysShowScrollBars(true);
            compositeDetailContainer.setExpandVertical(true);
            compositeDetailContainer.setExpandHorizontal(true);
            this.detailComposite = this.createDetailComposite((Composite)compositeDetailContainer, 2048);
            this.getFormToolkit().paintBordersFor(this.detailComposite);
            if (this.detailComposite != null) {
                compositeDetailContainer.setContent((Control)this.detailComposite);
            }
        }
        return wrapperForm;
    }

    protected Composite createCollectionComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new FillLayout());
        Section sctnCollection = this.getFormToolkit().createSection(composite, this.getECollectionCompositeSettings().getCollectionSectionTitle() == null || this.getECollectionCompositeSettings().getCollectionSectionTitle().isEmpty() ? 4096 : 256);
        this.getFormToolkit().paintBordersFor((Composite)sctnCollection);
        sctnCollection.setLayout((Layout)new FillLayout());
        if (this.getECollectionCompositeSettings().getCollectionSectionTitle() != null && !this.getECollectionCompositeSettings().getCollectionSectionTitle().isEmpty()) {
            sctnCollection.setText(this.getECollectionCompositeSettings().getCollectionSectionTitle());
        }
        Composite compositeCollectionSection = this.getFormToolkit().createComposite((Composite)sctnCollection, 2048);
        this.getFormToolkit().paintBordersFor(compositeCollectionSection);
        sctnCollection.setClient((Control)compositeCollectionSection);
        compositeCollectionSection.setLayout((Layout)new GridLayout(this.getECollectionCompositeSettings().isButtonsSectionDisplayed() ? 2 : 1, false));
        this.viewer = this.createViewer(compositeCollectionSection, 0);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getFormToolkit().paintBordersFor((Composite)tree);
        this.createColumns(this.viewer);
        this.internalConfigure(this.viewer);
        this.configure(this.viewer);
        if (this.getECollectionCompositeSettings().isButtonsSectionDisplayed()) {
            this.createButtonsComposite(style, compositeCollectionSection);
        }
        if (this.getECollectionCompositeSettings().isMultiSelection()) {
            Label lblSelectedItemsCount = new Label(compositeCollectionSection, 0);
            lblSelectedItemsCount.setLayoutData((Object)new GridData(4, 4, false, false));
            lblSelectedItemsCount.setText("");
            tree.addListener(13, e -> {
                int count = this.viewer.getStructuredSelection().toList().size();
                lblSelectedItemsCount.setText(count == 0 ? "" : String.valueOf(count) + " items selected");
            });
        }
        return composite;
    }

    protected void createButtonsComposite(int style, Composite compositeCollectionSection) {
        Composite buttonComposite = this.getFormToolkit().createComposite(compositeCollectionSection, 0);
        this.getFormToolkit().paintBordersFor(buttonComposite);
        GridData buttonCompositeGridData = new GridData(4, 128, false, false, 1, 1);
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        GridLayout buttonGridLayout = new GridLayout(1, true);
        buttonGridLayout.marginHeight = 0;
        buttonGridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonGridLayout);
        this.createButtons(buttonComposite, style);
    }

    protected TreeViewer createViewer(Composite parent, int style) {
        this.viewer = new TreeViewer(parent, 0x10010300 | (this.getECollectionCompositeSettings().isMultiSelection() ? 2 : 4));
        this.viewer.addSelectionChangedListener(e -> this.internalSelectionChanged(this.getCurrentSelection()));
        this.viewer.setUseHashlookup(true);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider((AdapterFactory)adapterFactory));
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider((AdapterFactory)adapterFactory));
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 2;
            }
        }, (int)0);
        return this.viewer;
    }

    protected void refreshDetails(IStructuredSelection currentSelection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new FillLayout());
        return composite;
    }

    private void internalSelectionChanged(IStructuredSelection selection) {
        if (!this.isDisposed() && this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                try {
                    for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                        listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.getViewer(), (ISelection)selection));
                    }
                    if (this.getECollectionCompositeSettings().isDetailSectionDisplayed()) {
                        this.refreshDetails(this.getCurrentSelection());
                    }
                    this.selectionChanged(this.getCurrentSelection());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    public final Composite getDetailComposite() {
        return this.detailComposite;
    }

    private void internalConfigure(TreeViewer viewer) {
        viewer.getTree().setLinesVisible(true);
        viewer.setAutoExpandLevel(this.getECollectionCompositeSettings().isAutoExpandableEnabled() ? -1 : 0);
        ApogyCommonEMFUIFacade.INSTANCE.addHideShowColumnMenu(viewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        if (viewer.getTree().getColumnCount() > 1) {
            viewer.getTree().setHeaderVisible(true);
            TreeColumn[] treeColumnArray = viewer.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                Integer minWidth = (Integer)column.getData(TREE_COLUMN_MIN_WIDTH);
                if (minWidth != null) {
                    column.setWidth(minWidth.intValue());
                }
                ++n2;
            }
        }
    }

    protected void configure(TreeViewer viewer) {
    }

    protected void createColumns(TreeViewer viewer) {
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected void createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Button createNewButton(Composite parent, int style) {
        Button btnNew = AbstractECollectionComposite.createButton(parent, 0, "New", new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)AbstractECollectionComposite.this.getDisplay(), () -> AbstractECollectionComposite.this.doNew());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                AbstractECollectionComposite.this.refreshViewer();
            }
        });
        this.createNewButtonBindings(btnNew);
        return btnNew;
    }

    protected void refreshViewer() {
        if (!this.getViewer().getTree().isDisposed()) {
            this.viewer.refresh(true);
        }
    }

    protected void createNewButtonBindings(Button button) {
    }

    protected void doNew() {
    }

    protected Button createOpenButton(Composite parent, int style) {
        Button btnOpen = AbstractECollectionComposite.createButton(parent, 0, "Open", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doOpen();
            this.refreshViewer();
        }));
        this.createOpenButtonBindings(btnOpen);
        return btnOpen;
    }

    protected void createOpenButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (this.viewer.getStructuredSelection().size() == 1) {
                return true;
            }
            return false;
        });
    }

    protected void doOpen() {
    }

    protected Button createCloseButton(Composite parent, int style) {
        Button btnClose = AbstractECollectionComposite.createButton(parent, 0, "Close", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doClose();
            this.refreshViewer();
        }));
        this.createCloseButtonBindings(btnClose);
        return btnClose;
    }

    protected void createCloseButtonBindings(Button button) {
    }

    protected void doClose() {
    }

    protected Button createDeleteButton(Composite parent, int style) {
        Button btnDelete = AbstractECollectionComposite.createButton(parent, 0, "Delete", e -> {
            int size = this.viewer.getStructuredSelection().toList().size();
            MessageDialog dialog = new MessageDialog(null, "Delete the selected elements", null, "Are you sure to delete " + (size > 1 ? "these " + size + " elements." : "this element?"), 3, new String[]{"Yes", "No"}, 1);
            if (dialog.open() == 0) {
                BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doDelete());
            }
            this.refreshViewer();
        });
        this.createDeleteButtonBindings(btnDelete);
        return btnDelete;
    }

    protected void createDeleteButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (this.viewer.getStructuredSelection().size() > 0) {
                return true;
            }
            return false;
        });
    }

    private void doDelete() {
        this.doDelete((ItemObject)this.getCurrentSelection().toList());
    }

    private void doDelete(List<ItemObject> items) {
        for (ItemObject item : items) {
            this.doDelete(item);
        }
    }

    protected void doDelete(ItemObject object) {
    }

    protected Button createCopyButton(Composite parent, int style) {
        Button btnCopy = AbstractECollectionComposite.createButton(parent, 0, "Duplicate", e -> {
            List elements = this.viewer.getStructuredSelection().toList();
            BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                this.doCopy(elements.get(0));
                this.refreshViewer();
            });
        });
        this.createDeleteButtonBindings(btnCopy);
        return btnCopy;
    }

    protected void createCopyButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (this.viewer.getStructuredSelection().size() == 1) {
                return true;
            }
            return false;
        });
    }

    protected void doCopy(ItemObject object) {
    }

    protected Button createUpButton(Composite parent, int style) {
        Button btnUp = AbstractECollectionComposite.createButton(parent, 0, "Up", e -> this.doUp());
        this.createUpButtonBindings(btnUp);
        return btnUp;
    }

    protected void createUpButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null && this.viewer.getTree().getItem(0).getData() != o) {
                return true;
            }
            return false;
        });
    }

    protected void doUp() {
    }

    protected Button createDownButton(Composite parent, int style) {
        Button btnDown = AbstractECollectionComposite.createButton(parent, 0, "Down", e -> this.doDown());
        this.createDownButtonBindings(btnDown);
        return btnDown;
    }

    protected void createDownButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null && this.viewer.getTree().getItem(this.viewer.getTree().getItems().length - 1).getData() != o) {
                return true;
            }
            return false;
        });
    }

    protected void doDown() {
    }

    protected Button createActivateButton(Composite parent, int style) {
        Button btnActivate = AbstractECollectionComposite.createButton(parent, 0, "Activate", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doActivate(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createActivateButtonBindings(btnActivate);
        return btnActivate;
    }

    protected void createActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doActivate(List<ItemObject> list) {
    }

    protected Button createStartButton(Composite parent, int style) {
        Button btnStart = AbstractECollectionComposite.createButton(parent, 0, "Start", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doStart(this.viewer.getStructuredSelection().toList());
            this.refreshViewer();
        }));
        this.createStartButtonBindings(btnStart);
        return btnStart;
    }

    protected void createStartButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doStart(List<ItemObject> list) {
    }

    protected Button createRunButton(Composite parent, int style) {
        Button btnRun = AbstractECollectionComposite.createButton(parent, 0, "Run", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doRun();
            this.refreshViewer();
        }));
        this.createRunButtonBindings(btnRun);
        return btnRun;
    }

    protected void createRunButtonBindings(Button button) {
    }

    protected void doRun() {
    }

    protected Button createStopButton(Composite parent, int style) {
        Button btnStop = AbstractECollectionComposite.createButton(parent, 0, "Stop", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doStop(this.viewer.getStructuredSelection().toList());
            this.refreshViewer();
        }));
        this.createStopButtonBindings(btnStop);
        return btnStop;
    }

    protected void createStopButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doStop(List<ItemObject> list) {
    }

    protected Button createImportButton(Composite parent, int style) {
        Button btnImport = AbstractECollectionComposite.createButton(parent, 0, "Import", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doImport();
            this.refreshViewer();
        }));
        this.createImportButtonBindings(btnImport);
        return btnImport;
    }

    protected void createImportButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doImport() {
    }

    protected Button createExportButton(Composite parent, int style) {
        Button btnExport = AbstractECollectionComposite.createButton(parent, 0, "Export", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doExport()));
        this.createExportButtonBindings(btnExport);
        return btnExport;
    }

    protected void createExportButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doExport() {
    }

    protected Button createUnselectButton(Composite parent, int style) {
        Button btnUnselect = AbstractECollectionComposite.createButton(parent, 0, "Unselect", e -> {
            this.unselect();
            this.refreshViewer();
        });
        this.createUnselectButtonBindings(btnUnselect);
        return btnUnselect;
    }

    protected void createUnselectButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    public void unselect() {
        if (this.getECollectionCompositeSettings().isCollectionSectionDisplayed()) {
            this.viewer.setSelection((ISelection)new StructuredSelection());
        }
        this.doUnselect();
    }

    protected void doUnselect() {
    }

    protected Button createClearSelectionButton(Composite parent, int style) {
        Button btnClear = AbstractECollectionComposite.createButton(parent, 0, "Clear", new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)AbstractECollectionComposite.this.getDisplay(), () -> AbstractECollectionComposite.this.doClearSelection());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                AbstractECollectionComposite.this.refreshViewer();
            }
        });
        this.createClearSelectionButtonBindings(btnClear);
        return btnClear;
    }

    protected void createClearSelectionButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doClearSelection() {
        this.viewer.setSelection(null);
    }

    protected Button createSaveButton(Composite parent, int style) {
        Button btnSave = AbstractECollectionComposite.createButton(parent, 0, "Save", new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)AbstractECollectionComposite.this.getDisplay(), () -> AbstractECollectionComposite.this.doSave());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                AbstractECollectionComposite.this.refreshViewer();
            }
        });
        this.createSaveSelectionButtonBindings(btnSave);
        return btnSave;
    }

    protected void createSaveSelectionButtonBindings(Button btnSave) {
    }

    protected void doSave() {
    }

    protected Button createShowButton(Composite parent, int style) {
        Button btn = AbstractECollectionComposite.createButton(parent, 0, "Show", new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)AbstractECollectionComposite.this.getDisplay(), () -> AbstractECollectionComposite.this.doShow());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                AbstractECollectionComposite.this.refreshViewer();
            }
        });
        this.createShowButtonBindings(btn);
        return btn;
    }

    protected void createShowButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doShow() {
    }

    protected Button createHideButton(Composite parent, int style) {
        Button btn = AbstractECollectionComposite.createButton(parent, 0, "Hide", new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)AbstractECollectionComposite.this.getDisplay(), () -> AbstractECollectionComposite.this.doHide());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                AbstractECollectionComposite.this.refreshViewer();
            }
        });
        this.createHideButtonBindings(btn);
        return btn;
    }

    protected void createHideButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doHide() {
    }

    protected Button createTestButton(Composite parent, int style) {
        Button btnTest = AbstractECollectionComposite.createButton(parent, 0, "Test", new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)AbstractECollectionComposite.this.getDisplay(), () -> AbstractECollectionComposite.this.doTest());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                AbstractECollectionComposite.this.refreshViewer();
            }
        });
        this.createTestSelectionButtonBindings(btnTest);
        return btnTest;
    }

    protected void createTestSelectionButtonBindings(Button button) {
    }

    protected void doTest() {
    }

    protected AdapterFactoryLabelProvider.StyledLabelProvider createLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider.StyledLabelProvider(adapterFactory, (Viewer)this.getViewer());
    }

    protected abstract ITreeContentProvider createContentProvider(AdapterFactory var1);

    protected static Button createButton(Composite parent, int style, String text, Listener listener) {
        Button button = new Button(parent, style);
        button.setText(text);
        if (parent.getLayout() instanceof GridLayout) {
            button.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if (listener != null) {
            button.addListener(13, listener);
        }
        return button;
    }

    protected List<ItemObject> getSelectedItemObjects() {
        ArrayList list = new ArrayList();
        if (this.getCurrentSelection() != null) {
            list.addAll(this.getCurrentSelection().toList());
        }
        return list;
    }

    @Override
    protected EObjectCompositeSettings createDefaultSettings() {
        return ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
    }
}

