/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EClassSelectionComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final EClass superType;
    private EClass selectedEclass;
    private final ComboViewer comboViewer;

    public EClassSelectionComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public EClassSelectionComposite(Composite parent, int style, EClass superType) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.superType = superType;
        this.comboViewer = this.createCombo(this, 8);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    EClassSelectionComposite.this.selectedEclass = null;
                    EClassSelectionComposite.this.newEClassSelected(EClassSelectionComposite.this.selectedEclass);
                    EClassSelectionComposite.this.comboViewer.getCombo().setToolTipText("");
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof EClass) {
                        EClassSelectionComposite.this.selectedEclass = (EClass)iStructuredSelection.getFirstElement();
                        EClassSelectionComposite.this.comboViewer.getCombo().setToolTipText(EClassSelectionComposite.this.selectedEclass.getInstanceClass().getName());
                        EClassSelectionComposite.this.newEClassSelected(EClassSelectionComposite.this.selectedEclass);
                    } else {
                        EClassSelectionComposite.this.selectedEclass = null;
                        EClassSelectionComposite.this.comboViewer.getCombo().setToolTipText("");
                        EClassSelectionComposite.this.newEClassSelected(EClassSelectionComposite.this.selectedEclass);
                    }
                }
            }
        });
    }

    public ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    public EClass getSelectedEclass() {
        return this.selectedEclass;
    }

    public void select(EClass eClass) {
        if (this.comboViewer != null && !this.comboViewer.getCombo().isDisposed()) {
            if (eClass != null) {
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)eClass), true);
            } else {
                this.comboViewer.setSelection((ISelection)new StructuredSelection(), true);
            }
        }
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 4);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                EClass eClass1 = (EClass)e1;
                EClass eClass2 = (EClass)e2;
                String name1 = eClass1.getName();
                String name2 = eClass2.getName();
                return name1.compareTo(name2);
            }
        });
        if (this.superType != null) {
            comboViewer.setInput((Object)ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(this.superType));
        } else {
            comboViewer.setInput((Object)ApogyCommonEMFFacade.INSTANCE.getAllAvailableEClasses());
        }
        return comboViewer;
    }

    protected void newEClassSelected(EClass newEclass) {
    }
}

