/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ApogyPreferencesManager;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIPackage;
import org.eclipse.apogy.common.emf.ui.DecimalFormatRegistry;
import org.eclipse.apogy.common.emf.ui.DisplayUnitsRegistry;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProviderParameters;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.common.emf.ui.FormatProvider;
import org.eclipse.apogy.common.emf.ui.RangesColorPreferences;
import org.eclipse.apogy.common.emf.ui.UnitsProvider;
import org.eclipse.apogy.common.emf.ui.impl.ApogyCommonEMFUIFacadeImpl;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonEMFUIFacadeCustomImpl
extends ApogyCommonEMFUIFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonEMFUIFacadeImpl.class);
    private DecimalFormatRegistry decimalFormatRegistry;
    private DisplayUnitsRegistry displayUnitsRegistry;
    private RangesColorPreferences prefs;

    @Override
    public RangesColorPreferences getRangesColorPreferences() {
        if (this.prefs == null) {
            this.prefs = (RangesColorPreferences)ApogyPreferencesManager.INSTANCE.getPreferences(ApogyCommonEMFUIPackage.Literals.RANGES_COLOR_PREFERENCES);
        }
        return this.prefs;
    }

    @Override
    public DecimalFormatRegistry getDecimalFormatRegistry() {
        if (this.decimalFormatRegistry == null) {
            this.decimalFormatRegistry = (DecimalFormatRegistry)ApogyPreferencesManager.INSTANCE.getPreferences(ApogyCommonEMFUIPackage.Literals.DECIMAL_FORMAT_REGISTRY);
        }
        return this.decimalFormatRegistry;
    }

    @Override
    public DisplayUnitsRegistry getDisplayUnitsRegistry() {
        if (this.displayUnitsRegistry == null) {
            this.displayUnitsRegistry = (DisplayUnitsRegistry)ApogyPreferencesManager.INSTANCE.getPreferences(ApogyCommonEMFUIPackage.Literals.DISPLAY_UNITS_REGISTRY);
        }
        return this.displayUnitsRegistry;
    }

    @Override
    public TreeMap<UnitConverter, String> getUnitConverterMap() {
        TreeMap<UnitConverter, String> map = super.getUnitConverterMap();
        if (map == null || map.isEmpty()) {
            map = new TreeMap(new Comparator<UnitConverter>(){

                @Override
                public int compare(UnitConverter arg0, UnitConverter arg1) {
                    return arg0.convert(1.0) - arg1.convert(1.0) < 0.0 ? 1 : -1;
                }
            });
            map.put((UnitConverter)new MultiplyConverter(1.0E24), "Y");
            map.put((UnitConverter)new MultiplyConverter(1.0E21), "Z");
            map.put((UnitConverter)new MultiplyConverter(1.0E18), "E");
            map.put((UnitConverter)new MultiplyConverter(1.0E15), "P");
            map.put((UnitConverter)new MultiplyConverter(1.0E12), "T");
            map.put((UnitConverter)new MultiplyConverter(1.0E9), "G");
            map.put((UnitConverter)new MultiplyConverter(1000000.0), "M");
            map.put((UnitConverter)new MultiplyConverter(1000.0), "k");
            map.put((UnitConverter)new MultiplyConverter(100.0), "h");
            map.put((UnitConverter)new MultiplyConverter(10.0), "da");
            map.put(UnitConverter.IDENTITY, " ");
            map.put((UnitConverter)new MultiplyConverter(0.1), "d");
            map.put((UnitConverter)new MultiplyConverter(0.01), "c");
            map.put((UnitConverter)new MultiplyConverter(0.001), "m");
            map.put((UnitConverter)new MultiplyConverter(1.0E-6), "\u03bc");
            map.put((UnitConverter)new MultiplyConverter(1.0E-9), "n");
            map.put((UnitConverter)new MultiplyConverter(1.0E-12), "p");
            map.put((UnitConverter)new MultiplyConverter(1.0E-15), "f");
            map.put((UnitConverter)new MultiplyConverter(1.0E-18), "a");
            map.put((UnitConverter)new MultiplyConverter(1.0E-21), "z");
            map.put((UnitConverter)new MultiplyConverter(1.0E-24), "y");
            this.setUnitConverterMap(map);
        }
        return super.getUnitConverterMap();
    }

    @Override
    public Color getColorForRange(Ranges range) {
        RGBA rgba = this.getRGBColorForRange(range);
        if (rgba != null && rgba.alpha != 0) {
            return new Color((Device)Display.getCurrent(), rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue);
        }
        return null;
    }

    @Override
    public RGBA getRGBColorForRange(Ranges range) {
        return this.getRangesColorPreferences().getColorForRange(range);
    }

    @Override
    public RGB convertToRGB(RGBA rgba) {
        return new RGB(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue);
    }

    @Override
    public RGBA convertToRGBA(RGB rgb) {
        return new RGBA(rgb.red, rgb.green, rgb.blue, 255);
    }

    @Override
    public Unit<?> getDisplayUnits(ETypedElement eTypedElement) {
        Unit displayUnit = null;
        UnitsProvider provider = (UnitsProvider)this.getDisplayUnitsRegistry().getEntriesMap().getEntries().get((Object)eTypedElement);
        if (provider != null) {
            displayUnit = provider.getProvidedUnit(null);
        }
        if (displayUnit == null) {
            displayUnit = Activator.getDefault().getDisplayUnit(eTypedElement);
        }
        if (displayUnit == null) {
            displayUnit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        }
        return displayUnit;
    }

    @Override
    public Unit<?> getDisplayUnits(EOperation eOperation, EOperationEParametersUnitsProviderParameters parameters) {
        Unit<?> displayUnit = null;
        UnitsProvider provider = (UnitsProvider)this.getDisplayUnitsRegistry().getEntriesMap().getEntries().get((Object)eOperation);
        if (provider != null) {
            displayUnit = provider.getProvidedUnit(parameters);
        }
        if (displayUnit == null) {
            displayUnit = this.getDisplayUnits((ETypedElement)parameters.getParam());
        }
        return displayUnit;
    }

    @Override
    public String getUnitAsString(Unit<?> units) {
        if (units != null) {
            String unitAsString = units.toString();
            String unitString = null;
            String factorString = null;
            String unitsString = null;
            double factor = 0.0;
            if (unitAsString.contains(")")) {
                factorString = unitAsString.substring(unitAsString.indexOf(")") + 1).trim();
                unitsString = unitAsString.substring(unitAsString.indexOf("(") + 1, unitAsString.indexOf(")")).trim();
            } else if (unitAsString.indexOf("*") >= 0) {
                unitsString = unitAsString.substring(0, unitAsString.indexOf("*")).trim();
                factorString = unitAsString.substring(unitAsString.indexOf("*")).trim();
            } else if (unitAsString.indexOf("/") >= 0) {
                unitsString = unitAsString.substring(0, unitAsString.indexOf("/")).trim();
                factorString = unitAsString.substring(unitAsString.indexOf("/")).trim();
            }
            try {
                String tmp;
                if (factorString.startsWith("*")) {
                    tmp = factorString.substring(factorString.indexOf("*") + 1);
                    factor = Double.parseDouble(tmp);
                } else if (factorString.startsWith("/")) {
                    tmp = factorString.substring(factorString.indexOf("/") + 1);
                    factor = 1.0 / Double.parseDouble(tmp);
                }
            }
            catch (Exception exception) {}
            String prefix = null;
            if (factor != 0.0) {
                prefix = this.getSIPrefix(factor);
                if (prefix != null) {
                    unitString = String.valueOf(prefix) + unitsString;
                }
            } else {
                unitString = units.toString();
            }
            return unitString.trim();
        }
        return null;
    }

    @Override
    public Number convertToDisplayUnits(Number number, ETypedElement eTypedElement) {
        Unit<?> displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(eTypedElement);
        Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        if (nativeUnits != null && displayUnits != null) {
            return nativeUnits.getConverterTo(displayUnits).convert(number.doubleValue());
        }
        return number;
    }

    @Override
    public void addUnitsProviderToRegistry(final ETypedElement eTypedElement, final UnitsProvider provider) {
        TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.getDecimalFormatRegistry());
        RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                ApogyCommonEMFUIFacadeCustomImpl.this.getDisplayUnitsRegistry().getEntriesMap().getEntries().put((Object)eTypedElement, (Object)provider);
            }
        };
        try {
            transactionalEditingDomain.getCommandStack().execute((Command)cmd);
        }
        catch (Throwable throwable) {}
    }

    @Override
    public Number convertToNativeUnits(Number number, Unit<?> nativeUnits, Unit<?> displayUnits, EClassifier numberType) {
        if (displayUnits != null && displayUnits != nativeUnits) {
            Double doubleValue = displayUnits.getConverterTo(nativeUnits).convert(number.doubleValue());
            if (numberType == EcorePackage.Literals.EFLOAT) {
                return Float.valueOf(doubleValue.floatValue());
            }
            if (numberType == EcorePackage.Literals.EBYTE) {
                return doubleValue.byteValue();
            }
            if (numberType == EcorePackage.Literals.ESHORT) {
                return doubleValue.shortValue();
            }
            if (numberType == EcorePackage.Literals.EINT) {
                return doubleValue.intValue();
            }
            if (numberType == EcorePackage.Literals.ELONG) {
                return doubleValue.longValue();
            }
            return doubleValue;
        }
        return number;
    }

    @Override
    public DecimalFormat getDisplayFormat(ETypedElement eTypedElement) {
        DecimalFormat format = null;
        FormatProvider provider = (FormatProvider)this.getDecimalFormatRegistry().getEntriesMap().getEntries().get((Object)eTypedElement);
        if (provider != null) {
            format = provider.getProvidedFormat(null);
        }
        if (format == null) {
            String formatStr = "";
            EClassifier type = eTypedElement.getEType();
            formatStr = type == EcorePackage.Literals.EFLOAT ? Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_FLOAT_ID") : (type == EcorePackage.Literals.EBYTE ? Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_BYTE_ID") : (type == EcorePackage.Literals.ESHORT ? Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_SHORT_ID") : (type == EcorePackage.Literals.EINT ? Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_INT_ID") : (type == EcorePackage.Literals.ELONG ? Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_LONG_ID") : Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_DOUBLE_ID")))));
            format = new DecimalFormat(formatStr);
        }
        return format;
    }

    @Override
    public DecimalFormat getDisplayFormat(EOperation eOperation, EOperationEParametersFormatProviderParameters parameters) {
        DecimalFormat format = null;
        FormatProvider provider = (FormatProvider)this.getDecimalFormatRegistry().getEntriesMap().getEntries().get((Object)eOperation);
        if (provider != null) {
            format = provider.getProvidedFormat(parameters);
        }
        if (format == null) {
            format = this.getDisplayFormat((ETypedElement)parameters.getParam());
        }
        return format;
    }

    @Override
    public String getDisplayedString(Number number, ETypedElement eTypedElement) {
        Unit<?> displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(eTypedElement);
        Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(eTypedElement);
        if (format == null) {
            format = new DecimalFormat("0.0################");
        }
        if (nativeUnits != null && displayUnits != null) {
            double value = nativeUnits.getConverterTo(displayUnits).convert(number.doubleValue());
            return format.format(value);
        }
        return format.format(number.doubleValue());
    }

    @Override
    public void addFormatProviderToRegistry(final ETypedElement eTypedElement, final FormatProvider provider) {
        TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.getDecimalFormatRegistry());
        RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                ApogyCommonEMFUIFacadeCustomImpl.this.getDecimalFormatRegistry().getEntriesMap().getEntries().put((Object)eTypedElement, (Object)provider);
            }
        };
        try {
            transactionalEditingDomain.getCommandStack().execute((Command)cmd);
        }
        catch (Throwable throwable) {}
    }

    @Override
    public void openDeleteNamedDialog(Named named) {
        ArrayList<Named> nameds = new ArrayList<Named>();
        nameds.add(named);
        this.openDeleteNamedDialog(nameds);
    }

    @Override
    public void openDeleteNamedDialog(List<? extends Named> namedList) {
        String eObjectsToDeleteMessage = "";
        eObjectsToDeleteMessage = String.valueOf(eObjectsToDeleteMessage) + ApogyCommonEMFFacade.INSTANCE.toString(namedList, ", ");
        MessageDialog dialog = new MessageDialog(null, "Delete the selected elements", null, "Are you sure to delete these elements: " + eObjectsToDeleteMessage + "?", 3, new String[]{"Yes", "No"}, 1);
        int result = dialog.open();
        if (result == 0) {
            for (EObject eObject : namedList) {
                ApogyCommonTransactionFacade.INSTANCE.basicDelete(eObject.eContainer(), eObject.eContainingFeature(), (Object)eObject);
            }
        }
    }

    @Override
    public void saveToPersistedState(MPart mPart, String persistedStateKey, final EObject eObject, ResourceSet resourceSet) {
        if (eObject != null) {
            ApogyCommonTransactionFacade.INSTANCE.removeFromEditingDomain(eObject);
            final Resource childResource = resourceSet.createResource(URI.createURI((String)mPart.getElementId()));
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((Object)resourceSet);
            RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

                protected void doExecute() {
                    childResource.getContents().add((Object)eObject);
                }
            };
            try {
                transactionalEditingDomain.getCommandStack().execute((Command)cmd);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            StringWriter stringWriter = new StringWriter();
            URIConverter.WriteableOutputStream os = new URIConverter.WriteableOutputStream((Writer)stringWriter, "ENCODING");
            try {
                childResource.save((OutputStream)os, Collections.EMPTY_MAP);
            }
            catch (Throwable t) {
                Logger.error("Failed to save EObject to Part <" + mPart.getElementId() + "> Persisted State at key <" + persistedStateKey + ">.", t);
            }
            mPart.getPersistedState().put(persistedStateKey, stringWriter.getBuffer().toString());
            String id = this.getPreferencesID(mPart, persistedStateKey);
            Activator.getDefault().getPreferenceStore().putValue(id, stringWriter.getBuffer().toString());
        }
    }

    @Override
    public EObject readFromPersistedState(MPart mPart, String persistedStateKey, ResourceSet resourceSet) {
        EObject eObject;
        block6: {
            eObject = null;
            String modelString = (String)mPart.getPersistedState().get(persistedStateKey);
            if (modelString == null) {
                String id = this.getPreferencesID(mPart, persistedStateKey);
                modelString = Activator.getDefault().getPreferenceStore().getString(id);
            }
            if (modelString != null) {
                Resource childResource = resourceSet.createResource(URI.createURI((String)mPart.getElementId()));
                StringReader reader = new StringReader(modelString);
                URIConverter.ReadableInputStream is = new URIConverter.ReadableInputStream((Reader)reader);
                try {
                    childResource.load((InputStream)is, Collections.EMPTY_MAP);
                    if (childResource.getContents().size() > 0) {
                        eObject = (EObject)childResource.getContents().get(0);
                        break block6;
                    }
                    Logger.warn("No EObject found in Part <" + mPart.getElementId() + "> Persisted State at key <" + persistedStateKey + ">.");
                }
                catch (Throwable t) {
                    Logger.error("Failed to load EObject from Part <" + mPart.getElementId() + "> Persisted State at key <" + persistedStateKey + ">.", t);
                }
            } else {
                Logger.info("No EObject content found in Part <" + mPart.getElementId() + "> Persisted State at key <" + persistedStateKey + ">.");
            }
        }
        return eObject;
    }

    @Override
    public Image getImage(EClass eClass) {
        Image image = null;
        String path = new String("platform:/plugin");
        String editDirectory = EcoreUtil.getAnnotation((EModelElement)eClass.getEPackage(), (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"editDirectory");
        if (editDirectory != null) {
            if (editDirectory.contains("/src-gen")) {
                editDirectory = editDirectory.substring(0, editDirectory.indexOf("/src-gen"));
            }
            path = String.valueOf(path) + editDirectory + "/icons/full/obj16/";
        } else {
            path = String.valueOf(path) + "/" + eClass.getEPackage().getNsURI() + ".edit/icons/full/obj16/";
        }
        path = String.valueOf(path) + eClass.getName() + ".gif";
        try {
            image = ImageDescriptor.createFromURL((URL)new URL(path)).createImage();
        }
        catch (MalformedURLException e) {
            Logger.error(" Unable to get the image corresponding to the eClass from the edit directory " + eClass.getName(), (Throwable)e);
        }
        return image;
    }

    @Override
    public void addHideShowColumnMenu(TreeViewer viewer) {
        MenuManager mgr = new MenuManager();
        int i = 0;
        while (i < viewer.getTree().getColumnCount()) {
            final TreeColumn column = viewer.getTree().getColumn(i);
            Action action = new Action(viewer.getTree().getColumn(i).getText(), 32){

                public void runWithEvent(Event event) {
                    column.getDisplay().syncExec(() -> {
                        if (!this.isChecked()) {
                            column.setData("width", (Object)column.getWidth());
                            column.setWidth(0);
                        } else {
                            column.setWidth(((Integer)column.getData("width")).intValue());
                        }
                    });
                }
            };
            action.setChecked(true);
            mgr.add((IAction)action);
            ++i;
        }
        viewer.getControl().setMenu(mgr.createContextMenu(viewer.getControl()));
    }

    @Override
    public void createViewerSelectionControlEnabledBinding(DataBindingContext dataBindingContext, StructuredViewer viewer, Control control, Function<?, ?> function) {
        assert (dataBindingContext != null) : "Specified databinding is null";
        assert (viewer != null) : "Specified viewer is null";
        assert (control != null) : "Specified control is null";
        assert (function != null) : "Specified function is null";
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)viewer);
        ISWTObservableValue observeEnabledControlWidget = WidgetProperties.enabled().observe((Widget)control);
        dataBindingContext.bindValue((IObservableValue)observeEnabledControlWidget, (IObservableValue)observeSingleSelectionViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), UpdateValueStrategy.create((IConverter)IConverter.create(Object.class, Boolean.class, function)));
    }

    private String getPreferencesID(MPart mPart, String persistedStateKey) {
        return String.valueOf(mPart.getElementId()) + "-" + persistedStateKey;
    }

    private String getSIPrefix(double factor) {
        String prefix = null;
        if (factor == 10.0) {
            prefix = "da";
        } else if (factor == 100.0) {
            prefix = "h";
        } else if (factor == 1000.0) {
            prefix = "k";
        } else if (factor == 1000000.0) {
            prefix = "M";
        } else if (factor == 1.0E9) {
            prefix = "G";
        } else if (factor == 1.0E12) {
            prefix = "T";
        } else if (factor == 1.0E15) {
            prefix = "P";
        } else if (factor == 0.1) {
            prefix = "d";
        } else if (factor == 0.01) {
            prefix = "c";
        } else if (factor == 0.001) {
            prefix = "m";
        } else if (factor == 1.0E-6) {
            prefix = "\u00b5";
        } else if (factor == 1.0E-9) {
            prefix = "n";
        } else if (factor == 1.0E-12) {
            prefix = "p";
        } else if (factor == 1.0E-15) {
            prefix = "f";
        }
        return prefix;
    }
}

