/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.WizardPagesProvider;
import org.eclipse.apogy.common.emf.ui.impl.WizardPagesProviderRegistryImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardPagesProviderRegistryCustomImpl
extends WizardPagesProviderRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(WizardPagesProviderRegistryImpl.class);

    @Override
    public Map<EClass, WizardPagesProvider> getWizardPagesMap() {
        Map<Object, WizardPagesProvider> map = super.getWizardPagesMap();
        if (this.wizardPagesMap == null) {
            map = Collections.synchronizedMap(new HashMap());
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getWIZARD_PAGES_PROVIDER_CONTRIBUTORS_POINT_ID());
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                String eClassStr = contributor.getAttribute(this.getWIZARD_PAGES_PROVIDER_CONTRIBUTORS_ECLASS_ID());
                eClassStr = eClassStr.trim();
                String providerStr = contributor.getAttribute(this.getWIZARD_PAGES_PROVIDER_CONTRIBUTORS_PROVIDER_ID());
                providerStr = providerStr.trim();
                try {
                    EClass eClass = ApogyCommonEMFFacade.INSTANCE.getEClass(eClassStr);
                    WizardPagesProvider wizardPagesProvider = (WizardPagesProvider)EcoreUtil.create((EClass)ApogyCommonEMFFacade.INSTANCE.getEClass(providerStr));
                    if (eClass != null && wizardPagesProvider != null) {
                        map.put(eClass, wizardPagesProvider);
                    } else {
                        Logger.error("WizardPagesProvider <" + providerStr + "> does not define a valid EClass <" + eClassStr + ">");
                    }
                }
                catch (Exception exception) {
                    Logger.error("Failed to load contributed WizardPagesProvider <" + providerStr + "> for type <" + eClassStr + "> from <" + contributor.getClass().getName() + ">");
                }
                ++i;
            }
            this.setWizardPagesMap(map);
        }
        return super.getWizardPagesMap();
    }

    @Override
    public WizardPagesProvider getProvider(EClass eClass) {
        ArrayList<EClass> types = new ArrayList<EClass>();
        for (EClass type : this.getWizardPagesMap().keySet()) {
            if (type == null || eClass != type && !type.isSuperTypeOf(eClass)) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            types.add(EcorePackage.Literals.EOBJECT);
        }
        EClass closestMatch = ApogyCommonEMFFacade.INSTANCE.findClosestMatch(eClass, types);
        return this.getWizardPagesMap().get(closestMatch);
    }
}

