/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FeaturePathAdapter {
    private EObject eObject;
    private Adapter adapter;
    private final List<EStructuralFeature> structuralFeatures = new ArrayList<EStructuralFeature>();
    private final List<EObject> monitoredEObjects = new ArrayList<EObject>();
    private final Map<EStructuralFeature, EObject> featureToEObject = new HashMap<EStructuralFeature, EObject>();
    private EStructuralFeature leafEStructuralFeature = null;

    public FeaturePathAdapter() {
    }

    public FeaturePathAdapter(FeaturePath featurePath) {
        this.setFeaturePath(featurePath);
    }

    public FeaturePathAdapter(List<EStructuralFeature> structuralFeatures) {
        this.setFeaturePath(structuralFeatures);
    }

    public void setFeaturePath(FeaturePath featurePath) {
        this.structuralFeatures.clear();
        EStructuralFeature[] features = featurePath.getFeaturePath();
        int i = 0;
        while (i < features.length) {
            this.structuralFeatures.add(features[i]);
            ++i;
        }
        if (!this.structuralFeatures.isEmpty()) {
            this.leafEStructuralFeature = this.structuralFeatures.get(this.structuralFeatures.size() - 1);
        }
        this.initializeAdapter();
    }

    public void setFeaturePath(List<EStructuralFeature> newStructuralFeatures) {
        this.structuralFeatures.clear();
        this.structuralFeatures.addAll(newStructuralFeatures);
        if (!this.structuralFeatures.isEmpty()) {
            this.leafEStructuralFeature = this.structuralFeatures.get(this.structuralFeatures.size() - 1);
        }
        this.initializeAdapter();
    }

    public void setSource(EObject eObject) {
        this.eObject = eObject;
        this.initializeAdapter();
    }

    public void dispose() {
        this.setSource(null);
    }

    public void valueChanged(Object newValue) {
    }

    private void initializeAdapter() {
        for (EObject eObject : this.monitoredEObjects) {
            eObject.eAdapters().remove((Object)this.getAdapter());
        }
        this.monitoredEObjects.clear();
        this.featureToEObject.clear();
        if (this.eObject != null) {
            Iterator<EStructuralFeature> it = this.structuralFeatures.iterator();
            Object currentObject = this.eObject;
            while (it.hasNext()) {
                EStructuralFeature feature = it.next();
                if (currentObject == null) continue;
                currentObject.eAdapters().add((Object)this.getAdapter());
                this.monitoredEObjects.add((EObject)currentObject);
                this.featureToEObject.put(feature, (EObject)currentObject);
                Object value = currentObject.eGet(feature);
                currentObject = value instanceof EObject ? (EObject)value : null;
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == FeaturePathAdapter.this.leafEStructuralFeature) {
                        FeaturePathAdapter.this.valueChanged(msg.getNewValue());
                    } else if (msg.getFeature() instanceof EStructuralFeature && FeaturePathAdapter.this.structuralFeatures.contains(msg.getFeature())) {
                        EStructuralFeature feature = (EStructuralFeature)msg.getFeature();
                        EObject eObject = null;
                        if (msg.getNewValue() instanceof EObject) {
                            eObject = (EObject)msg.getNewValue();
                        }
                        this.updateEObjectBeingMonitored(feature, eObject);
                    }
                }

                private void updateEObjectBeingMonitored(EStructuralFeature feature, EObject newEObject) {
                    EObject previousEObject = (EObject)FeaturePathAdapter.this.featureToEObject.get(feature);
                    if (!FeaturePathAdapter.this.structuralFeatures.isEmpty()) {
                        if (previousEObject != null) {
                            this.unregisterEObjectAndDescendants(feature);
                        }
                        if (newEObject != null) {
                            this.registerEObjectAndDescendants(feature, newEObject);
                        }
                    }
                }

                private void unregisterEObjectAndDescendants(EStructuralFeature feature) {
                    int startIndex = FeaturePathAdapter.this.structuralFeatures.indexOf(feature);
                    if (startIndex >= 0) {
                        int i = startIndex;
                        while (i < FeaturePathAdapter.this.structuralFeatures.size()) {
                            if (i != startIndex) {
                                EStructuralFeature currentFeature = (EStructuralFeature)FeaturePathAdapter.this.structuralFeatures.get(i);
                                EObject eObject = (EObject)FeaturePathAdapter.this.featureToEObject.get(currentFeature);
                                if (eObject != null) {
                                    eObject.eAdapters().remove((Object)FeaturePathAdapter.this.getAdapter());
                                    FeaturePathAdapter.this.monitoredEObjects.remove(eObject);
                                    FeaturePathAdapter.this.featureToEObject.put(currentFeature, null);
                                }
                            }
                            ++i;
                        }
                    }
                }

                private void registerEObjectAndDescendants(EStructuralFeature feature, EObject newEObject) {
                    EObject currentEObject = newEObject;
                    int featureIndex = FeaturePathAdapter.this.structuralFeatures.indexOf(feature);
                    int currentfeatureIndex = featureIndex + 1;
                    while (newEObject != null) {
                        newEObject.eAdapters().add((Object)FeaturePathAdapter.this.getAdapter());
                        FeaturePathAdapter.this.monitoredEObjects.add(newEObject);
                        if (currentfeatureIndex > 0 && currentfeatureIndex < FeaturePathAdapter.this.structuralFeatures.size()) {
                            EStructuralFeature currentFeature = (EStructuralFeature)FeaturePathAdapter.this.structuralFeatures.get(currentfeatureIndex);
                            FeaturePathAdapter.this.featureToEObject.put(currentFeature, currentEObject);
                            Object object = currentEObject.eGet(currentFeature);
                            newEObject = object instanceof EObject ? (EObject)object : null;
                        }
                        ++currentfeatureIndex;
                    }
                    EObject lastestEObject = (EObject)FeaturePathAdapter.this.featureToEObject.get(FeaturePathAdapter.this.leafEStructuralFeature);
                    if (lastestEObject != null) {
                        FeaturePathAdapter.this.valueChanged(lastestEObject.eGet(FeaturePathAdapter.this.leafEStructuralFeature));
                    }
                }
            };
        }
        return this.adapter;
    }
}

