/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.parts;

import java.util.HashMap;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.AbstractTimeSource;
import org.eclipse.apogy.common.emf.ui.SelectionBasedTimeSource;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.ui.composites.ActiveTimeSourceComposite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActiveTimeSourcePart
extends AbstractSessionPart<InvocatorSession> {
    private ApogyEnvironment environment;
    private Adapter activeTimeSourceAdapter;
    private ActiveTimeSourceComposite activeTimeSourceComposite;
    @Inject
    ESelectionService selectionService;
    @Inject
    EHandlerService handlerService;
    @Inject
    ECommandService commandService;

    protected void createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Button btnClose = new Button(composite, 0);
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/elcl16/close_view.png");
        btnClose.setImage(image.createImage());
        btnClose.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        btnClose.addSelectionListener(this.getListener());
        this.activeTimeSourceComposite = new ActiveTimeSourceComposite(composite, 0);
        this.activeTimeSourceComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        if (this.environment != null) {
            this.activeTimeSourceComposite.setTimeSource(this.environment.getActiveTimeSource());
        }
    }

    protected void doSetContent(InvocatorSession newInvocatorSession) {
        if (newInvocatorSession instanceof ApogyEnvironment) {
            ApogyEnvironment apogyEnvironment = (ApogyEnvironment)newInvocatorSession.getEnvironment();
            this.newEnvironment(apogyEnvironment);
            this.activeTimeSourceComposite.setTimeSource(apogyEnvironment.getActiveTimeSource());
        } else {
            this.newEnvironment(null);
            this.activeTimeSourceComposite.setTimeSource(null);
        }
    }

    private void newEnvironment(ApogyEnvironment environment) {
        if (this.environment != null) {
            this.environment.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        }
        this.environment = environment;
        if (this.environment != null) {
            this.environment.eAdapters().add((Object)this.getActiveTimeSourceAdapter());
        }
    }

    private Adapter getActiveTimeSourceAdapter() {
        if (this.activeTimeSourceAdapter == null) {
            this.activeTimeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE) {
                        if (notification.getNewValue() != null) {
                            ActiveTimeSourcePart.this.activeTimeSourceComposite.setTimeSource((AbstractTimeSource)notification.getNewValue());
                            if (notification.getNewValue() instanceof SelectionBasedTimeSource) {
                                ((SelectionBasedTimeSource)notification.getNewValue()).setSelectionService(ActiveTimeSourcePart.this.selectionService);
                            }
                        } else {
                            ActiveTimeSourcePart.this.activeTimeSourceComposite.setTimeSource(null);
                        }
                    }
                }
            };
        }
        return this.activeTimeSourceAdapter;
    }

    protected String getNoContentMessage() {
        return "No active environment";
    }

    private SelectionListener getListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap<String, String> parameters = new HashMap<String, String>(1);
                parameters.put("org.eclipse.apogy.core.environment.ui.commandparameter.toggleActiveTimeSource.show", "false");
                ParameterizedCommand command = ActiveTimeSourcePart.this.commandService.createCommand("org.eclipse.apogy.core.environment.ui.command.toggleActiveTimeSource", parameters);
                ActiveTimeSourcePart.this.handlerService.executeHandler(command);
            }
        };
    }

    @Inject
    @PreDestroy
    public void preDestroy() {
        if (this.environment != null) {
            this.environment.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        }
    }
}

