/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.impl;

import java.util.List;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTFactory;
import org.eclipse.apogy.addons.mqtt.MQTTClient;
import org.eclipse.apogy.addons.mqtt.MQTTClientConnectionOptions;
import org.eclipse.apogy.addons.mqtt.MQTTTopic;
import org.eclipse.apogy.addons.mqtt.QualityOfService;
import org.eclipse.apogy.addons.mqtt.SimpleSSLMQTTClientConnectionOptions;
import org.eclipse.apogy.addons.mqtt.impl.ApogyAddonsMQTTFacadeImpl;
import org.eclipse.paho.client.mqttv3.MqttCallback;

public class ApogyAddonsMQTTFacadeCustomImpl
extends ApogyAddonsMQTTFacadeImpl {
    @Override
    public String[] getTopicsNames(List<MQTTTopic> topics) {
        String[] names = new String[topics.size()];
        int i = 0;
        for (MQTTTopic topic : topics) {
            names[i] = topic.getTopicName();
            ++i;
        }
        return names;
    }

    @Override
    public int[] getTopicsQualityOfService(List<MQTTTopic> topics) {
        int[] qos = new int[topics.size()];
        int i = 0;
        for (MQTTTopic topic : topics) {
            qos[i] = topic.getQualityOfService().getValue();
            ++i;
        }
        return qos;
    }

    @Override
    public MQTTClient createMQTTClient(String name, String brokerHostName, int port, List<MQTTTopic> topics) {
        MQTTClient client = ApogyAddonsMQTTFactory.eINSTANCE.createMQTTClient();
        client.setName(name);
        client.setBrokerHostName(brokerHostName);
        client.setPort(port);
        if (topics != null) {
            for (MQTTTopic topic : topics) {
                client.subscribe(topic);
            }
        }
        return client;
    }

    @Override
    public MQTTClient createMQTTClient(String name, String brokerHostName, int port, List<MQTTTopic> topics, String username, String password) {
        MQTTClient client = this.createMQTTClient(name, brokerHostName, port, topics);
        MQTTClientConnectionOptions options = ApogyAddonsMQTTFactory.eINSTANCE.createMQTTClientConnectionOptions();
        options.setUserName(username);
        options.setPassword(password);
        client.setConnectionOptions(options);
        return client;
    }

    @Override
    public MQTTClient createMQTTClient(String name, String brokerHostName, int port, List<MQTTTopic> topics, MQTTClientConnectionOptions connectionOptions) {
        MQTTClient client = this.createMQTTClient(name, brokerHostName, port, topics);
        client.setConnectionOptions(connectionOptions);
        return client;
    }

    @Override
    public MQTTTopic createMQTTTopic(String topicName, QualityOfService qualityOfService, MqttCallback callBack) {
        MQTTTopic topic = ApogyAddonsMQTTFactory.eINSTANCE.createMQTTTopic();
        topic.setTopicName(topicName);
        topic.setQualityOfService(qualityOfService);
        topic.setCallBack(callBack);
        return topic;
    }

    @Override
    public MQTTTopic createMQTTTopic(String topicName, QualityOfService qualityOfService, MqttCallback callBack, long expectedUpdatePeriod) {
        MQTTTopic topic = this.createMQTTTopic(topicName, qualityOfService, callBack);
        topic.setExpectedUpdatePeriod(expectedUpdatePeriod);
        return topic;
    }

    @Override
    public MQTTClientConnectionOptions createMQTTClientConnectionOptions(String username, String password) {
        MQTTClientConnectionOptions options = ApogyAddonsMQTTFactory.eINSTANCE.createMQTTClientConnectionOptions();
        options.setUserName(username);
        options.setPassword(password);
        return options;
    }

    @Override
    public SimpleSSLMQTTClientConnectionOptions createSimpleSSLMQTTClientConnectionOptions(String username, String password, String keyStoreFilePathURL, String keyStorePassword) {
        SimpleSSLMQTTClientConnectionOptions options = ApogyAddonsMQTTFactory.eINSTANCE.createSimpleSSLMQTTClientConnectionOptions();
        options.setUserName(username);
        options.setPassword(password);
        options.setKeyStoreFilePathURL(keyStoreFilePathURL);
        options.setKeyStorePassword(keyStorePassword);
        return options;
    }

    @Override
    public MQTTClientConnectionOptions createMQTTClientConnectionOptions(String username, String password, boolean cleanSession, boolean automaticReconnect) {
        MQTTClientConnectionOptions options = this.createMQTTClientConnectionOptions(username, password);
        options.setCleanSession(cleanSession);
        options.setAutomaticReconnect(automaticReconnect);
        return options;
    }

    @Override
    public SimpleSSLMQTTClientConnectionOptions createSimpleSSLMQTTClientConnectionOptions(String username, String password, boolean cleanSession, boolean automaticReconnect, String keyStoreFilePathURL, String keyStorePassword) {
        SimpleSSLMQTTClientConnectionOptions options = this.createSimpleSSLMQTTClientConnectionOptions(username, password, keyStoreFilePathURL, keyStorePassword);
        options.setUserName(username);
        options.setPassword(password);
        options.setCleanSession(cleanSession);
        options.setAutomaticReconnect(automaticReconnect);
        return options;
    }
}

