/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.sensors.fov.AngularSpan;
import org.eclipse.apogy.addons.sensors.fov.CircularSectorFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.AbstractFieldOfViewJME3Object;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.CircularSectorFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.JME3FovUtilities;
import org.eclipse.apogy.addons.sensors.fov.ui.scene_objects.CircularSectorFieldOfViewSceneObject;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularSectorFieldOfViewJME3Object
extends AbstractFieldOfViewJME3Object<CircularSectorFieldOfView>
implements CircularSectorFieldOfViewSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(CircularSectorFieldOfViewJME3Object.class);
    public static ColorRGBA DEFAULT_CIRCULAR_SECTOR_FOV_COLOR = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static float DEFAULT_ANGLE_INCREMENT = (float)Math.toRadians(10.0);
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    private float angleIncrement = DEFAULT_ANGLE_INCREMENT;
    private Adapter angularSpanAdapter;
    private Adapter rangeAdapter;
    private AssetManager assetManager;
    private Geometry fovGeometry = null;
    private Geometry axisGeometry = null;
    private CircularSectorFieldOfViewImageProjectorControl circularSectorFieldOfViewImageProjectorControl;

    public CircularSectorFieldOfViewJME3Object(final CircularSectorFieldOfView node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(node, jme3RenderEngineDelegate);
        if (node == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.axisGeometry = JME3Utilities.createAxis3D((float)1.0f, (AssetManager)this.assetManager);
        Job job = new Job("CircularSectorFieldOfViewJME3Object : Updating Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                CircularSectorFieldOfViewJME3Object.this.requestUpdate();
                node.getAngularSpan().eAdapters().add((Object)CircularSectorFieldOfViewJME3Object.this.getAngularSpanAdapter());
                node.getRange().eAdapters().add((Object)CircularSectorFieldOfViewJME3Object.this.getRangeAdapter());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        if (this.fovGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.fovGeometry);
        }
        double minAngle = ((CircularSectorFieldOfView)this.getTopologyNode()).getAngularSpan().getMinimumAngle();
        double maxAngle = ((CircularSectorFieldOfView)this.getTopologyNode()).getAngularSpan().getMaximumAngle();
        double minRadius = ((CircularSectorFieldOfView)this.getTopologyNode()).getRange().getMinimumDistance();
        double maxRadius = ((CircularSectorFieldOfView)this.getTopologyNode()).getRange().getMaximumDistance();
        int numberOfDivision = (int)Math.round(((CircularSectorFieldOfView)this.getTopologyNode()).getAngularSpan().getSpanningAngle() / (double)this.getAngleIncrement());
        Mesh mesh = JME3FovUtilities.createCircularSector(minAngle, maxAngle, minRadius, maxRadius, numberOfDivision, true);
        this.fovGeometry = ((CircularSectorFieldOfView)this.getTopologyNode()).getNodeId() != null ? new Geometry("", mesh) : new Geometry("?", mesh);
        this.fovGeometry.setMaterial(this.createMaterial());
        this.getFovNode().attachChild((Spatial)this.fovGeometry);
        this.internalSetPresentationMode(this.meshPresentationMode);
        this.getAttachmentNode().addControl((Control)this.getCircularSectorFieldOfViewImageProjectorControl());
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            if (((CircularSectorFieldOfView)this.getTopologyNode()).getAngularSpan() != null) {
                ((CircularSectorFieldOfView)this.getTopologyNode()).getAngularSpan().eAdapters().remove((Object)this.getAngularSpanAdapter());
            }
            if (((CircularSectorFieldOfView)this.getTopologyNode()).getRange() != null) {
                ((CircularSectorFieldOfView)this.getTopologyNode()).getRange().eAdapters().remove((Object)this.getRangeAdapter());
            }
        }
        super.dispose();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.fovGeometry);
        if (this.axisGeometry != null) {
            geometries.add(this.axisGeometry);
        }
        return geometries;
    }

    @Override
    public void setColor(RGBA rgb) {
        super.setColor(rgb);
        try {
            if (this.fovGeometry != null) {
                this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Material mat = CircularSectorFieldOfViewJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", CircularSectorFieldOfViewJME3Object.this.fovColor);
                        mat.setColor("Ambient", CircularSectorFieldOfViewJME3Object.this.fovColor);
                        mat.setColor("Specular", CircularSectorFieldOfViewJME3Object.this.fovColor);
                        CircularSectorFieldOfViewJME3Object.this.fovGeometry.setMaterial(mat);
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to set color to <" + rgb + ">.", t);
        }
    }

    public float getAngleIncrement() {
        return this.angleIncrement;
    }

    public void setAngleIncrement(float angleIncrement) {
        if (angleIncrement <= 0.0f) {
            throw new IllegalArgumentException("Angle increment must be greater than zero !");
        }
        this.angleIncrement = angleIncrement;
        this.requestUpdate();
    }

    @Override
    public MeshPresentationMode getPresentationMode() {
        return this.meshPresentationMode;
    }

    public void setPresentationMode(final MeshPresentationMode mode) {
        Logger.info("Setting Presentation Mode to <" + mode + ">.");
        if (this.fovGeometry != null && this.fovGeometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CircularSectorFieldOfViewJME3Object.this.internalSetPresentationMode(mode);
                    return null;
                }
            });
        }
    }

    public void setShowProjection(final boolean showProjection) {
        Logger.info("setShowProjection(" + showProjection + ")");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                CircularSectorFieldOfViewJME3Object.this.getCircularSectorFieldOfViewImageProjectorControl().setEnabled(showProjection);
                return null;
            }
        });
        this.showProjection = showProjection;
    }

    @Override
    public float getTransparency() {
        return this.transparency;
    }

    public void setShowOutlineOnly(boolean showOutlineOnly) {
    }

    @Override
    public AbstractFieldOfViewImageProjectorControl<CircularSectorFieldOfView> getAbstractFieldOfViewImageProjectorControl() {
        return this.getCircularSectorFieldOfViewImageProjectorControl();
    }

    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">.");
        this.axisVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (CircularSectorFieldOfViewJME3Object.this.axisVisible) {
                    CircularSectorFieldOfViewJME3Object.this.getAttachmentNode().attachChild((Spatial)CircularSectorFieldOfViewJME3Object.this.axisGeometry);
                } else {
                    CircularSectorFieldOfViewJME3Object.this.getAttachmentNode().detachChild((Spatial)CircularSectorFieldOfViewJME3Object.this.axisGeometry);
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double length) {
        Logger.info("Setting axis length to <" + length + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    float scale = (float)Math.abs(length) / CircularSectorFieldOfViewJME3Object.this.previousAxisLength;
                    if (CircularSectorFieldOfViewJME3Object.this.axisGeometry != null) {
                        CircularSectorFieldOfViewJME3Object.this.axisGeometry.scale(scale);
                    }
                    CircularSectorFieldOfViewJME3Object.this.previousAxisLength = (float)length;
                }
                catch (Throwable t) {
                    Logger.error("Failed to setAxisLength(" + length + ").", t);
                }
                return null;
            }
        });
    }

    private void internalSetPresentationMode(MeshPresentationMode mode) {
        if (this.fovGeometry != null) {
            Mesh mesh = this.fovGeometry.getMesh();
            switch (mode.getValue()) {
                case 1: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Triangles);
                    break;
                }
                case 2: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Triangles);
                    break;
                }
                case 0: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Points);
                    break;
                }
            }
        }
        this.meshPresentationMode = mode;
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.getColor() != null) {
            mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
        } else {
            mat.setColor("Diffuse", DEFAULT_CIRCULAR_SECTOR_FOV_COLOR.clone());
            mat.setColor("Ambient", DEFAULT_CIRCULAR_SECTOR_FOV_COLOR.clone());
            mat.setColor("Specular", DEFAULT_CIRCULAR_SECTOR_FOV_COLOR.clone());
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private Adapter getAngularSpanAdapter() {
        if (this.angularSpanAdapter == null) {
            this.angularSpanAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getNotifier() instanceof AngularSpan) {
                        int featureId = notification.getFeatureID(AngularSpan.class);
                        switch (featureId) {
                            case 0: 
                            case 1: {
                                CircularSectorFieldOfViewJME3Object.this.requestUpdate();
                                CircularSectorFieldOfViewJME3Object.this.getCircularSectorFieldOfViewImageProjectorControl().updateProjectorFOVSettings();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.angularSpanAdapter;
    }

    private Adapter getRangeAdapter() {
        if (this.rangeAdapter == null) {
            this.rangeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(CircularSectorFieldOfView.class) == 1) {
                        CircularSectorFieldOfViewJME3Object.this.requestUpdate();
                        CircularSectorFieldOfViewJME3Object.this.getCircularSectorFieldOfViewImageProjectorControl().updateProjectorFOVSettings();
                    } else if (notification.getFeatureID(CircularSectorFieldOfView.class) == 0) {
                        CircularSectorFieldOfViewJME3Object.this.requestUpdate();
                        CircularSectorFieldOfViewJME3Object.this.getCircularSectorFieldOfViewImageProjectorControl().updateProjectorFOVSettings();
                    }
                }
            };
        }
        return this.rangeAdapter;
    }

    private CircularSectorFieldOfViewImageProjectorControl getCircularSectorFieldOfViewImageProjectorControl() {
        if (this.circularSectorFieldOfViewImageProjectorControl == null) {
            this.circularSectorFieldOfViewImageProjectorControl = new CircularSectorFieldOfViewImageProjectorControl(this.jme3Application, (CircularSectorFieldOfView)this.getTopologyNode());
        }
        return this.circularSectorFieldOfViewImageProjectorControl;
    }
}

