/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import java.awt.image.BufferedImage;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.addons.sensors.fov.CircularSectorFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.ProjectorData;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.swt.graphics.RGB;

public class CircularSectorFieldOfViewImageProjectorControl
extends AbstractFieldOfViewImageProjectorControl<CircularSectorFieldOfView> {
    protected static final float VERTICAL_FOV_ANGLE_RAD = (float)Math.toRadians(0.25);
    private CircularSectorFieldOfView circularSectorFieldOfView = null;

    public CircularSectorFieldOfViewImageProjectorControl(JME3Application jme3Application, CircularSectorFieldOfView fieldOfView) {
        super(jme3Application, fieldOfView);
        this.circularSectorFieldOfView = fieldOfView;
    }

    @Override
    public float getHorizontalFOVAngleDegrees() {
        return (float)Math.toDegrees(this.circularSectorFieldOfView.getAngularSpan().getSpanningAngle());
    }

    @Override
    public float getTextureHtoVRatio() {
        return (float)Math.toRadians(this.getHorizontalFOVAngleDegrees()) / VERTICAL_FOV_ANGLE_RAD;
    }

    @Override
    public BufferedImage getProjectedImage() {
        int width = 3;
        int height = Math.round((float)width * this.getTextureHtoVRatio());
        if (height <= 0) {
            height = 1;
        }
        RGB projColor = this.getProjectionColor();
        AbstractEImage opaqueImage = EImagesUtilities.INSTANCE.createUniformColorImage(width, height, projColor.red, projColor.green, projColor.blue, 255);
        return opaqueImage.asBufferedImage();
    }

    @Override
    protected Quaternion getProjectorRotation() {
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.fieldOfView);
        Matrix3d rot = new Matrix3d();
        m.get(rot);
        Quaternion q = JME3Utilities.createQuaternion((Matrix3d)rot);
        Quaternion centerAngleOffset = new Quaternion();
        centerAngleOffset.fromAngleAxis(-1.0f * (float)this.circularSectorFieldOfView.getAngularSpan().getCenterAngle(), new Vector3f(1.0f, 0.0f, 0.0f));
        q = q.mult(centerAngleOffset);
        return q;
    }

    @Override
    public void updateProjectorFOVSettings() {
        ProjectorData projectorData = this.getProjectorData();
        projectorData.projector.setProjectiveTextureMap(this.createTexture());
        projectorData.projector.setFallOffPower(1.0f);
        projectorData.projector.setFallOffDistance((float)this.circularSectorFieldOfView.getRange().getMaximumDistance());
        Camera projectorCamera = projectorData.projector.getProjectorCamera();
        projectorCamera.setLocation(this.getProjectorLocation());
        projectorCamera.setRotation(this.getProjectorRotation());
        projectorCamera.setFrustumPerspective(this.getHorizontalFOVAngleDegrees(), 1.0f / this.getTextureHtoVRatio(), 1.0f, 5.0f);
    }
}

