/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils;

import com.jme3.renderer.Camera;
import java.awt.image.BufferedImage;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.ProjectorData;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.swt.graphics.RGB;

public class RectangularFrustrumFieldOfViewImageProjectorControl
extends AbstractFieldOfViewImageProjectorControl<RectangularFrustrumFieldOfView> {
    public RectangularFrustrumFieldOfViewImageProjectorControl(JME3Application jme3Application, RectangularFrustrumFieldOfView fieldOfView) {
        super(jme3Application, fieldOfView);
    }

    @Override
    public float getHorizontalFOVAngleDegrees() {
        return (float)Math.toDegrees(((RectangularFrustrumFieldOfView)this.fieldOfView).getHorizontalFieldOfViewAngle());
    }

    @Override
    public float getTextureHtoVRatio() {
        float ratio = 1.0f;
        if (this.fieldOfView != null && ((RectangularFrustrumFieldOfView)this.fieldOfView).getHorizontalFieldOfViewAngle() > 0.0 && ((RectangularFrustrumFieldOfView)this.fieldOfView).getVerticalFieldOfViewAngle() > 0.0) {
            ratio = (float)(((RectangularFrustrumFieldOfView)this.fieldOfView).getHorizontalFieldOfViewAngle() / ((RectangularFrustrumFieldOfView)this.fieldOfView).getVerticalFieldOfViewAngle());
        }
        return ratio;
    }

    @Override
    public BufferedImage getProjectedImage() {
        int width = 256;
        int height = Math.round((float)width * this.getTextureHtoVRatio());
        AbstractEImage transparentImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height);
        RGB projColor = this.getProjectionColor();
        AbstractEImage borderedImage = EImagesUtilities.INSTANCE.addBorder(transparentImage, 4, projColor.red, projColor.green, projColor.blue);
        return borderedImage.asBufferedImage();
    }

    @Override
    public void updateProjectorFOVSettings() {
        ProjectorData projectorData = this.getProjectorData();
        projectorData.projector.setProjectiveTextureMap(this.createTexture());
        Camera projectorCamera = projectorData.projector.getProjectorCamera();
        projectorCamera.setLocation(this.getProjectorLocation());
        projectorCamera.setRotation(this.getProjectorRotation());
        if (this.getHorizontalFOVAngleDegrees() > 0.0f) {
            projectorCamera.setFrustumPerspective(this.getHorizontalFOVAngleDegrees(), 1.0f / this.getTextureHtoVRatio(), 1.0f, 5.0f);
        } else {
            projectorCamera.setFrustumPerspective(0.1f, 1.0f / this.getTextureHtoVRatio(), 1.0f, 5.0f);
        }
    }
}

