/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.handlers;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.core.environment.AbstractApogyEnvironmentItem;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.ViewPointList;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.topology.ui.dialogs.EditViewPointListDialog;
import org.eclipse.apogy.core.topology.ui.parts.AbstractApogy3dPart;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EditViewPointsHandler {
    @CanExecute
    public boolean canExecute(MPart part) {
        return ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null;
    }

    @Execute
    public void execute(MPart part) {
        Shell shell = Display.getCurrent().getActiveShell();
        if (part.getObject() instanceof AbstractApogy3dPart) {
            final AbstractApogy3dPart apogy3dPart = (AbstractApogy3dPart)((Object)part.getObject());
            EditViewPointListDialog dialog = new EditViewPointListDialog(shell, this.resolveViewPointList()){

                @Override
                protected void newViewPointSelected(AbstractViewPoint viewPoint) {
                    if (viewPoint != null) {
                        apogy3dPart.setActiveViewPoint(viewPoint);
                    }
                }
            };
            dialog.open();
        }
    }

    protected ViewPointList resolveViewPointList() {
        Environment env;
        ViewPointList viewPointList = null;
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null && (env = invocatorSession.getEnvironment()) instanceof ApogyEnvironment) {
            ApogyEnvironment apogyEnvironment = (ApogyEnvironment)env;
            EList items = apogyEnvironment.getEnvironmentItems();
            for (AbstractApogyEnvironmentItem item : items) {
                if (!(item instanceof ViewPointList)) continue;
                viewPointList = (ViewPointList)item;
            }
            if (viewPointList == null) {
                viewPointList = ApogyCoreEnvironmentFactory.eINSTANCE.createViewPointList();
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)env, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ENVIRONMENT_ITEMS, (Object)viewPointList);
            }
        }
        return viewPointList;
    }
}

