/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.parts;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.AbstractViewPointReference;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFacade;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.IRenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewer;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewerProvider;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewerRegistry;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.ApogyTopology;
import org.eclipse.apogy.core.environment.AbstractApogyEnvironmentItem;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.ViewPointList;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.apogy.core.topology.ui.parts.AbstractApogyTopologyBasedPart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApogy3dPart
extends AbstractApogyTopologyBasedPart
implements TopologyViewerProvider {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractApogy3dPart.class);
    protected static MPart activeAbstractApogy3dPartMPart = null;
    public static final String VIEW_POINT_ID = "VIEW_POINT_ID";
    private AbstractViewPoint abstractViewPoint;
    private Node topologyRoot;
    private String currentDirectory = System.getProperty("user.dir");
    protected TopologyViewer topologyViewer;
    private Adapter topologyTopologyViewerRegistryAdapter = null;
    private FeaturePathAdapter variableInstanciationAdapter = null;
    @Inject
    Shell shell;
    @Inject
    EModelService modelService;
    @Inject
    ESelectionService selectionService;
    @Inject
    MPart mPart;

    @PostConstruct
    public void userPostConstruct(MPart mPart) {
        AbstractViewPointReference ref = (AbstractViewPointReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(mPart, VIEW_POINT_ID);
        if (ref != null) {
            this.abstractViewPoint = ref.getAbstractViewPoint();
        } else {
            mPart.setLabel(this.getPartDisplayedName());
        }
        if (ApogyCoreInvocatorFacade.INSTANCE.getInitVariableInstancesDate() != null) {
            this.variablesInstanciated();
        }
        this.getVariableInstanciationAdapter().init((EObject)ApogyCoreInvocatorFacade.INSTANCE);
    }

    @PreDestroy
    public void userPreDestroy(MPart mPart) {
        this.getVariableInstanciationAdapter().dispose();
    }

    protected void createComposite(Composite parent, int style) {
        if (activeAbstractApogy3dPartMPart == null) {
            JME3RenderEngineDelegate jme3RenderEngineDelegate = this.createJME3RenderEngineDelegate();
            this.topologyViewer = new TopologyViewer(parent, (IRenderEngineDelegate)jme3RenderEngineDelegate);
            jme3RenderEngineDelegate.setMaximumFrameRate(this.topologyViewer.getMaximumFrameRate());
            jme3RenderEngineDelegate.setAntiAliasing(this.topologyViewer.isAntiAliasingEnabled());
            jme3RenderEngineDelegate.setShowStatisticsEnabled(this.topologyViewer.isShowStatisticsEnabled());
            Activator.getTopologyViewerRegistry().eAdapters().add((Object)this.getTopologyTopologyViewerRegistryAdapter());
            this.setActiveViewPoint(this.abstractViewPoint);
            activeAbstractApogy3dPartMPart = this.mPart;
        } else {
            new NoContentComposite(parent, 0){

                protected String getMessage() {
                    MPerspective mPerspective = AbstractApogy3dPart.this.modelService.getPerspectiveFor((MUIElement)activeAbstractApogy3dPartMPart);
                    String partLabel = activeAbstractApogy3dPartMPart.getLabel();
                    String elementId = mPerspective.getLabel();
                    return "3D Viewer is already instanciated in part <" + partLabel + "> in the perspective named <" + elementId + "> !";
                }
            };
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Activator.getTopologyViewerRegistry().eAdapters().remove((Object)AbstractApogy3dPart.this.getTopologyTopologyViewerRegistryAdapter());
                if (activeAbstractApogy3dPartMPart == AbstractApogy3dPart.this.mPart) {
                    activeAbstractApogy3dPartMPart = null;
                }
            }
        });
    }

    @PersistState
    public void userPersistState(MPart mPart) {
        try {
            if (this.abstractViewPoint != null) {
                AbstractViewPointReference ref = ApogyCommonTopologyFactory.eINSTANCE.createAbstractViewPointReference();
                ref.setAbstractViewPoint(this.abstractViewPoint);
                ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(mPart, VIEW_POINT_ID, (EObject)ref);
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public TopologyViewer getTopologyViewer() {
        return this.topologyViewer;
    }

    public String getPartDisplayedName() {
        return "3D Viewer";
    }

    protected void variablesInstanciated() {
        this.initialiseViewPoints(this.topologyRoot);
    }

    @Override
    protected void newTopology(ApogyTopology apogyTopology) {
        if (activeAbstractApogy3dPartMPart == this.mPart) {
            GraphicsContext graphicsContext = ApogyCommonTopologyUIFacade.INSTANCE.createGraphicsContext((Node)apogyTopology.getRootNode());
            this.topologyViewer.setInput((Object)graphicsContext);
            if (apogyTopology != null) {
                this.topologyRoot = apogyTopology.getRootNode();
            }
            this.initialiseViewPoints(this.topologyRoot);
            AbstractViewPointReference ref = (AbstractViewPointReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, VIEW_POINT_ID);
            if (ref != null) {
                this.abstractViewPoint = ref.getAbstractViewPoint();
                this.setActiveViewPoint(this.abstractViewPoint);
            }
        }
    }

    protected abstract JME3RenderEngineDelegate createJME3RenderEngineDelegate();

    public void zoomToFit() {
        this.getTopologyViewer().zoomToFit();
    }

    public void setAntiAliasing(boolean enable) {
        this.getTopologyViewer().setAntiAliasing(enable);
    }

    public void setHighSpeedMode(boolean enable) {
        this.getTopologyViewer().setHighSpeedMotionEnabled(enable);
    }

    public void setPickingMode(boolean enable) {
        this.getTopologyViewer().setPickingModeEnabled(enable);
    }

    public void showStatisticsDisplay(boolean enable) {
        this.getTopologyViewer().setShowStatisticsEnabled(enable);
    }

    public void resetLevelViewpoint() {
        this.getTopologyViewer().levelViewPoint();
    }

    public void takeScreenshot() {
        this.getTopologyViewer().takeScreenshot();
        BufferedImage image = this.getTopologyViewer().takeScreenshot();
        if (image != null) {
            EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            eImage.setImageContent(image);
            if (eImage != null) {
                FileDialog fileChooser = new FileDialog(this.shell, 8192);
                fileChooser.setText("Saves image to file");
                fileChooser.setFilterPath(this.currentDirectory);
                fileChooser.setFilterExtensions(new String[]{"*.png;"});
                String filename = fileChooser.open();
                if (filename != null) {
                    try {
                        if (filename.endsWith(".png")) {
                            this.saveImageInJob((AbstractEImage)eImage, filename, 5);
                        } else {
                            String fileExtension = "";
                            if (filename.lastIndexOf(".") > 0) {
                                fileExtension = filename.substring(filename.lastIndexOf("."));
                            }
                            String message = "Failed to save the image. The specified file extension <" + fileExtension + "> is not supported.";
                            Logger.error(message);
                            MessageBox messageBox = new MessageBox(this.shell, 33);
                            messageBox.setMessage(message);
                            messageBox.open();
                        }
                    }
                    catch (Exception exception) {
                        Logger.error("Unable to save image to file <" + filename + ">.");
                    }
                    this.currentDirectory = fileChooser.getFilterPath();
                }
            }
        }
    }

    public void setActiveViewPoint(AbstractViewPoint abstractViewPoint) {
        this.abstractViewPoint = abstractViewPoint;
        if (abstractViewPoint != null) {
            this.mPart.setLabel(String.valueOf(this.getPartDisplayedName()) + " - " + abstractViewPoint.getName());
            if (ApogyCoreTopologyFacade.INSTANCE.getApogyTopology() != null) {
                GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
                abstractViewPoint.initialize((Node)root);
            }
        } else {
            this.mPart.setLabel(this.getPartDisplayedName());
        }
        if (this.getTopologyViewer() != null && abstractViewPoint != null) {
            this.getTopologyViewer().setActiveViewPoint(abstractViewPoint);
        }
    }

    public AbstractViewPoint getActiveViewPoint() {
        return this.getTopologyViewer().getActiveViewPoint();
    }

    protected void initialiseViewPoints(Node root) {
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null) {
            if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment() instanceof ApogyEnvironment) {
                ApogyEnvironment apogyEnvironment = (ApogyEnvironment)ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment();
                EList items = apogyEnvironment.getEnvironmentItems();
                ViewPointList viewPointList = null;
                for (AbstractApogyEnvironmentItem item : items) {
                    if (!(item instanceof ViewPointList)) continue;
                    viewPointList = (ViewPointList)item;
                }
                if (viewPointList != null) {
                    for (AbstractViewPoint vp : viewPointList.getViewPoints()) {
                        vp.initialize(root);
                    }
                }
            }
            this.setActiveViewPoint(this.abstractViewPoint);
        }
    }

    private void saveImageInJob(final AbstractEImage image, final String fileName, final int fileType) {
        UIJob job = new UIJob("Save Image to file <" + fileName + ">"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (fileType == 4) {
                        EImagesUtilities.INSTANCE.saveImageAsJPEG(fileName, image);
                    } else if (fileType == 5) {
                        EImagesUtilities.INSTANCE.saveImageAsPNG(fileName, image);
                    }
                    Logger.info("Sucessfully saved image to file <" + fileName + ">.");
                    Status status = new Status(0, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), "Sucessfully saved image to file <" + fileName + ">.");
                    return status;
                }
                catch (Exception e) {
                    String message = "Failed to save the image to file <" + fileName + ">. The following exception was thrown : \n\n ";
                    Logger.error(message, (Throwable)e);
                    Status status = new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), message, (Throwable)e);
                    return status;
                }
            }
        };
        job.schedule();
    }

    private Adapter getTopologyTopologyViewerRegistryAdapter() {
        if (this.topologyTopologyViewerRegistryAdapter == null) {
            this.topologyTopologyViewerRegistryAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TopologyViewerRegistry) {
                        int featureId = msg.getFeatureID(TopologyViewerRegistry.class);
                        switch (featureId) {
                            case 1: {
                                if (!(msg.getNewValue() instanceof NodeSelection)) break;
                                NodeSelection nodeSelection = (NodeSelection)msg.getNewValue();
                                AbstractApogy3dPart.this.selectionService.setSelection((Object)nodeSelection);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.topologyTopologyViewerRegistryAdapter;
    }

    private FeaturePathAdapter getVariableInstanciationAdapter() {
        if (this.variableInstanciationAdapter == null) {
            this.variableInstanciationAdapter = new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EAttribute> features = new ArrayList<EAttribute>();
                    features.add(ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__INIT_VARIABLE_INSTANCES_DATE);
                    return features;
                }

                public void notifyChanged(Notification msg) {
                    AbstractApogy3dPart.this.variablesInstanciated();
                }
            };
        }
        return this.variableInstanciationAdapter;
    }
}

