/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.parts;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TreeRootNode;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsFactory;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.common.topology.bindings.BindingsList;
import org.eclipse.apogy.common.topology.bindings.BindingsSet;
import org.eclipse.apogy.common.topology.bindings.FeatureRootsList;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLinksList;
import org.eclipse.apogy.core.ConnectionPointsList;
import org.eclipse.apogy.core.TopologyRoot;
import org.eclipse.apogy.core.topology.ui.ApogyCoreTopologyUIFacade;
import org.eclipse.apogy.core.topology.ui.composites.ApogySystemEditingComposite;
import org.eclipse.apogy.core.topology.ui.internal.ApogySystem3dUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySystemFileEditorPart {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySystemFileEditorPart.class);
    private ApogySystemEditingComposite apogySystemEditingComposite;
    private boolean dirty = false;
    private String fileName = null;
    private ApogySystem apogySystem;
    private String apogySystemFilePath;
    @Inject
    public ESelectionService selectionService;
    @Inject
    public MPart mPart;

    public ApogySystem getApogySystem() {
        return this.apogySystem;
    }

    public String getApogySystemFilePath() {
        return this.apogySystemFilePath;
    }

    public void saveToFile() {
        try {
            this.apogySystemEditingComposite.save();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Inject
    @PreDestroy
    public void preDestroy(MPart mPart) {
        ApogyCoreTopologyUIFacade.INSTANCE.setEditedApogySystemAssemblyRoot(null);
    }

    @PostConstruct
    protected void createComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite(top, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridData scrolledCompositeGridData = new GridData(4, 4, true, true, 1, 1);
        scrolledComposite.setLayoutData((Object)scrolledCompositeGridData);
        this.apogySystemEditingComposite = new ApogySystemEditingComposite((Composite)scrolledComposite, 0){

            @Override
            protected void apogySystemOpened(ApogySystem newApogySystem) {
                ApogyCoreTopologyUIFacade.INSTANCE.setEditedApogySystem(newApogySystem);
            }

            @Override
            protected void setFileIsDirty(boolean newDirty) {
                if (newDirty && ApogySystemFileEditorPart.this.getApogySystem() != null) {
                    UIJob updateJob = new UIJob("Update Assembly Topology"){

                        public IStatus runInUIThread(IProgressMonitor arg0) {
                            try {
                                ApogySystem as = ApogySystemFileEditorPart.this.getApogySystem();
                                if (as != null) {
                                    ApogyCoreTopologyUIFacade.INSTANCE.setEditedApogySystemAssemblyRoot(ApogySystem3dUtils.assembleSubSystem(as));
                                }
                            }
                            catch (Exception e) {
                                Logger.error(e.getMessage(), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    updateJob.schedule();
                }
                ApogySystemFileEditorPart.this.dirty = newDirty;
                ApogySystemFileEditorPart.this.mPart.setLabel(ApogySystemFileEditorPart.this.getPartDisplayedName());
            }

            @Override
            protected void rootEObjectChanged(ApogySystem newApogySystem) {
                ApogySystemFileEditorPart.this.apogySystem = newApogySystem;
                ApogySystemFileEditorPart.this.fixApogySystem(newApogySystem);
                super.rootEObjectChanged(newApogySystem);
                if (newApogySystem != null) {
                    ApogyCoreTopologyUIFacade.INSTANCE.setEditedApogySystemAssemblyRoot(ApogySystem3dUtils.assembleSubSystem(newApogySystem));
                }
            }

            @Override
            protected void apogySystemPathSet(String newApogySystemPath) {
                ApogySystemFileEditorPart.this.apogySystemFilePath = newApogySystemPath;
                if (newApogySystemPath != null) {
                    ApogySystemFileEditorPart.this.fileName = newApogySystemPath;
                } else {
                    ApogySystemFileEditorPart.this.fileName = null;
                }
                ApogySystemFileEditorPart.this.mPart.setLabel(ApogySystemFileEditorPart.this.getPartDisplayedName());
            }
        };
        this.apogySystemEditingComposite.setRootEObject((EObject)ApogyCoreFactory.eINSTANCE.createApogySystem());
        scrolledComposite.setContent((Control)this.apogySystemEditingComposite);
    }

    private String getPartDisplayedName() {
        String label = "";
        if (this.fileName != null) {
            label = String.valueOf(label) + this.fileName.substring(this.fileName.lastIndexOf(File.separator) + 1);
            if (this.dirty) {
                label = "*" + label;
            }
        } else {
            label = String.valueOf(label) + "System Details";
        }
        return label;
    }

    private void fixApogySystem(ApogySystem apogySystem) {
        if (apogySystem != null) {
            if (apogySystem.getAssemblyLinksList() == null) {
                AssemblyLinksList assemblyLinksList = ApogyCoreFactory.eINSTANCE.createAssemblyLinksList();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogySystem, (EStructuralFeature)ApogyCorePackage.Literals.APOGY_SYSTEM__ASSEMBLY_LINKS_LIST, (Object)assemblyLinksList);
            }
            if (apogySystem.getBindingSet() == null) {
                BindingsSet bindingsSet = ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsSet();
                bindingsSet.setFeatureRootsList(ApogyCommonTopologyBindingsFactory.eINSTANCE.createFeatureRootsList());
                bindingsSet.setBindingsList(ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsList());
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogySystem, (EStructuralFeature)ApogyCorePackage.Literals.APOGY_SYSTEM__BINDING_SET, (Object)bindingsSet);
            } else {
                if (apogySystem.getBindingSet().getFeatureRootsList() == null) {
                    FeatureRootsList featureRootsList = ApogyCommonTopologyBindingsFactory.eINSTANCE.createFeatureRootsList();
                    TreeRootNode treeRoot = ApogyCommonEMFFactory.eINSTANCE.createTreeRootNode();
                    treeRoot.setSourceClass(apogySystem.getInterfaceClass());
                    featureRootsList.getFeatureRoots().add((Object)treeRoot);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogySystem.getBindingSet(), (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.BINDINGS_SET__FEATURE_ROOTS_LIST, (Object)featureRootsList);
                }
                if (apogySystem.getBindingSet().getFeatureRootsList().getFeatureRoots().isEmpty() && apogySystem.getInterfaceClass() != null) {
                    TreeRootNode treeRoot = ApogyCommonEMFFactory.eINSTANCE.createTreeRootNode();
                    treeRoot.setSourceClass(apogySystem.getInterfaceClass());
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)apogySystem.getBindingSet().getFeatureRootsList(), (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.FEATURE_ROOTS_LIST__FEATURE_ROOTS, (Object)treeRoot);
                }
                if (apogySystem.getBindingSet().getBindingsList() == null) {
                    BindingsList bindingsList = ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsList();
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogySystem.getBindingSet(), (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.BINDINGS_SET__BINDINGS_LIST, (Object)bindingsList);
                }
            }
            if (apogySystem.getConnectionPointsList() == null) {
                ConnectionPointsList connectionPointsList = ApogyCoreFactory.eINSTANCE.createConnectionPointsList();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogySystem, (EStructuralFeature)ApogyCorePackage.Literals.APOGY_SYSTEM__CONNECTION_POINTS_LIST, (Object)connectionPointsList);
            }
            if (apogySystem.getTopologyRoot() == null) {
                TopologyRoot topologyRoot = ApogyCoreFactory.eINSTANCE.createTopologyRoot();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogySystem, (EStructuralFeature)ApogyCorePackage.Literals.APOGY_SYSTEM__TOPOLOGY_ROOT, (Object)topologyRoot);
            }
        }
    }
}

