/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.ArbitraryViewPoint;
import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.apogy.core.environment.AbstractApogyEnvironmentItem;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.ViewPointList;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.EList;

public class ViewPointsDynamicMenuContributions {
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        ViewPointList viewPointList = this.resolveViewPointList();
        if (viewPointList != null) {
            this.populate(items);
        }
    }

    @AboutToHide
    public void aboutToHide(List<MMenuElement> items) {
    }

    protected void populate(List<MMenuElement> items) {
        for (MMenuElement child : items) {
            child.setToBeRendered(false);
            child.setVisible(false);
        }
        items.clear();
        ViewPointList viewPointList = this.resolveViewPointList();
        for (AbstractViewPoint viewPoint : viewPointList.getViewPoints()) {
            MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
            dynamicItem.setLabel("View Point - " + viewPoint.getName());
            dynamicItem.setContributionURI("bundleclass://org.eclipse.apogy.core.topology.ui/org.eclipse.apogy.core.topology.ui.handlers.SetActiveViewPointHandler");
            dynamicItem.setContributorURI("platform:/plugin/org.eclipse.apogy.core.topology.ui");
            dynamicItem.setIconURI("platform:/plugin/org.eclipse.apogy.core.topology.ui/icons/view_point_16.gif");
            dynamicItem.setToBeRendered(true);
            dynamicItem.getTransientData().put("viewpoint", viewPoint);
            items.add((MMenuElement)dynamicItem);
        }
    }

    protected ViewPointList resolveViewPointList() {
        Environment env;
        ViewPointList viewPointList = null;
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null && (env = invocatorSession.getEnvironment()) instanceof ApogyEnvironment) {
            ApogyEnvironment apogyEnvironment = (ApogyEnvironment)env;
            EList items = apogyEnvironment.getEnvironmentItems();
            for (AbstractApogyEnvironmentItem item : items) {
                if (!(item instanceof ViewPointList)) continue;
                viewPointList = (ViewPointList)item;
            }
        }
        return viewPointList;
    }

    protected String getIconURIForAbstractViewPoint(AbstractViewPoint abstractViewPoint) {
        String uri = null;
        if (abstractViewPoint instanceof ArbitraryViewPoint) {
            uri = "platform:/plugin/org.eclipse.apogy.common.topology.edit/icons/full/obj16/ArbitraryViewPoint.gif";
        } else if (abstractViewPoint instanceof AttachedViewPoint) {
            uri = "platform:/plugin/org.eclipse.apogy.common.topology.edit/icons/full/obj16/AttachedViewPoint.gif";
        }
        return uri;
    }
}

