/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.compat.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.contributions.IContributionFactorySpi;
import org.eclipse.e4.core.services.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ReflectionContributionFactory
implements IContributionFactory {
    private final IExtensionRegistry registry;
    private Map<String, Object> languages;
    @Inject
    private PackageAdmin packageAdmin;
    @Inject
    private Logger logger;

    @Inject
    public ReflectionContributionFactory(IExtensionRegistry registry) {
        this.registry = registry;
        this.processLanguages();
    }

    public Object create(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        return this.doCreate(uriString, context, staticContext);
    }

    public Object create(String uriString, IEclipseContext context) {
        return this.doCreate(uriString, context, null);
    }

    private Object doCreate(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        Object contribution;
        URI uri;
        Bundle bundle;
        if (uriString == null) {
            return null;
        }
        if (uriString.startsWith("platform:/plugin/")) {
            this.logger.error("platform-style URIs deprecated for referencing types: " + uriString);
            uriString = uriString.replace("platform:/plugin/", "bundleclass://");
            this.logger.error("URI rewritten as: " + uriString);
        }
        if ((bundle = this.getBundle(uri = URI.createURI(uriString))) != null) {
            contribution = this.createFromBundle(bundle, context, staticContext, uri);
        } else {
            contribution = null;
            this.logger.error("Unable to retrive the bundle from the URI: " + uriString);
        }
        return contribution;
    }

    protected Object createFromBundle(Bundle bundle, IEclipseContext context, IEclipseContext staticContext, URI uri) {
        Object contribution;
        if (uri.segmentCount() > 1) {
            String prefix = uri.segment(0);
            IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
            if (factory == null) {
                String message = "Unsupported contribution factory type '" + prefix + "'";
                this.logger.error(message);
                return null;
            }
            StringBuffer resource = new StringBuffer(uri.segment(1));
            int i = 2;
            while (i < uri.segmentCount()) {
                resource.append('/');
                resource.append(uri.segment(i));
                ++i;
            }
            contribution = factory.create(bundle, resource.toString(), context);
        } else {
            String clazz = uri.segment(0);
            try {
                Class targetClass = bundle.loadClass(clazz);
                contribution = staticContext == null ? ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context) : ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context, (IEclipseContext)staticContext);
                if (contribution == null) {
                    String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                    this.logger.error(message);
                }
            }
            catch (ClassNotFoundException e) {
                contribution = null;
                String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                this.logger.error((Throwable)e, message);
            }
            catch (InjectionException e) {
                contribution = null;
                String message = "Unable to create class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                this.logger.error((Throwable)e, message);
            }
        }
        return contribution;
    }

    protected void processLanguages() {
        this.languages = new HashMap<String, Object>();
        IConfigurationElement[] languageElements = this.registry.getConfigurationElementsFor("org.eclipse.e4.languages");
        int i = 0;
        while (i < languageElements.length) {
            IConfigurationElement languageElement = languageElements[i];
            try {
                this.languages.put(languageElement.getAttribute("name"), languageElement.createExecutableExtension("contributionFactory"));
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected Bundle getBundle(URI platformURI) {
        return this.getBundleForName(platformURI.authority());
    }

    public Bundle getBundle(String uriString) {
        return this.getBundle(new URI(uriString));
    }

    public Bundle getBundleForName(String bundlename) {
        Bundle[] bundles;
        if (this.packageAdmin == null) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            BundleContext context = bundle.getBundleContext();
            ServiceReference reference = context.getServiceReference(PackageAdmin.class.getName());
            this.packageAdmin = (PackageAdmin)context.getService(reference);
        }
        if ((bundles = this.packageAdmin.getBundles(bundlename, null)) == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    static class URI {
        String scheme;
        String authority;
        String[] segments = new String[0];

        URI(String uriString) {
            int colon = uriString.indexOf(58);
            if (colon < 0) {
                throw new IllegalArgumentException("invalid URI");
            }
            this.scheme = uriString.substring(0, colon);
            if ((uriString = uriString.substring(colon + 1)).startsWith("//")) {
                int authEnd = uriString.indexOf(47, 2);
                if (authEnd < 0) {
                    this.authority = uriString.substring(2);
                } else {
                    this.authority = uriString.substring(2, authEnd);
                    this.segments = uriString.substring(authEnd + 1).split("/");
                }
            } else {
                this.segments = uriString.substring(uriString.indexOf(47) + 1).split("/");
            }
        }

        public String authority() {
            return this.authority;
        }

        public String segment(int i) {
            return this.segments[i];
        }

        public int segmentCount() {
            return this.segments.length;
        }

        static URI createURI(String uriString) {
            return new URI(uriString);
        }
    }
}

