/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.mainmenu.handlers;

import javax.inject.Named;
import org.eclipse.apogy.rcp.dialogs.AddPerspectiveDialog;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPerspectiveHandler {
    private static final Logger Logger = LoggerFactory.getLogger(OpenPerspectiveHandler.class);

    @Execute
    public void execute(IEclipseContext context, EModelService modelService, MApplication application, EPartService partService, EHandlerService handlerService, ECommandService commandService, @Optional @Named(value="org.eclipse.apogy.rcp.commandparameter.addPerspective.perspectiveID") String perspectiveID) {
        MWindow window = (MWindow)modelService.find("org.eclipse.apogy.rcp.windows.main", (MUIElement)application);
        if (perspectiveID == null || perspectiveID.equals("")) {
            try {
                AddPerspectiveDialog dialog = (AddPerspectiveDialog)ContextInjectionFactory.make(AddPerspectiveDialog.class, (IEclipseContext)context);
                dialog.open();
            }
            catch (Exception e) {
                Logger.error("Unable to open the perspective dialog", (Throwable)e);
            }
        } else {
            try {
                MPerspectiveStack stack = (MPerspectiveStack)modelService.find("org.eclipse.apogy.rcp.perspectivesStack", (MUIElement)window);
                MUIElement object = modelService.cloneSnippet((MSnippetContainer)application, perspectiveID, window);
                if (object instanceof MPerspective) {
                    MPerspective perspective = (MPerspective)object;
                    perspective.getPersistedState().remove("Standalone");
                    this.makeIDsUnique(perspective, stack);
                    for (MPart part : modelService.findElements((MUIElement)perspective, null, MPart.class, null)) {
                        if (part.getContributionURI() == null || part.getContributionURI().equals("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView")) continue;
                        part.setElementId(part.getElementId().concat("_" + perspective.getElementId()));
                    }
                    for (MPartStack partStack : modelService.findElements((MUIElement)perspective, null, MPartStack.class, null)) {
                        partStack.setElementId(partStack.getElementId().concat("_" + perspective.getElementId()));
                    }
                    for (MPartSashContainer partSashContainer : modelService.findElements((MUIElement)perspective, null, MPartSashContainer.class, null)) {
                        partSashContainer.setElementId(partSashContainer.getElementId().concat("_" + perspective.getElementId()));
                    }
                    if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspective.getElementId()) == null) {
                        ((PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry()).addPerspective(perspective);
                        application.getSnippets().add(modelService.cloneElement((MUIElement)perspective, (MSnippetContainer)application));
                    }
                    stack.getChildren().add(perspective);
                    stack.setSelectedElement((MUIElement)perspective);
                }
            }
            catch (Exception e) {
                Logger.error(" Unable to open < " + perspectiveID + ">", (Throwable)e);
            }
        }
    }

    private void makeIDsUnique(MPerspective perspective, MPerspectiveStack stack) {
        int j = 1;
        int i = 0;
        while (i < stack.getChildren().size()) {
            MPerspective stackedPerspective;
            if (stack.getChildren().get(i) instanceof MPerspective && (stackedPerspective = (MPerspective)stack.getChildren().get(i)).getElementId() != null && stackedPerspective.getElementId().startsWith(String.valueOf(perspective.getElementId()) + "_" + Integer.toString(j))) {
                ++j;
                i = 0;
            }
            ++i;
        }
        perspective.setElementId(String.valueOf(perspective.getElementId()) + "_" + Integer.toString(j));
    }
}

