/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer.impl;

import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.viewer.ITopologyViewer;
import org.eclipse.apogy.common.topology.ui.viewer.ITopologyViewerListener;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.apogy.common.topology.ui.viewer.impl.TopologyViewerRegistryImpl;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyViewerRegistryCustomImpl
extends TopologyViewerRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TopologyViewerRegistryImpl.class);
    private ISelectionChangedListener selectionChangedListener = null;
    private ITopologyViewerListener topologyViewerListener = null;

    @Override
    public void registerITopologyViewer(ITopologyViewer iTopologyViewer) {
        if (iTopologyViewer != null && !this.getITopologyViewers().contains((Object)iTopologyViewer)) {
            Logger.debug("Registering <" + iTopologyViewer + ">.");
            this.getITopologyViewers().add((Object)iTopologyViewer);
            iTopologyViewer.addSelectionChangedListener(this.getSelectionChangedListener());
            iTopologyViewer.addITopologyViewerListener(this.getTopologyViewerListener());
        }
    }

    @Override
    public void unRegisterITopologyViewer(ITopologyViewer iTopologyViewer) {
        if (iTopologyViewer != null) {
            Logger.debug("Un-Registering <" + iTopologyViewer + ">.");
            this.getITopologyViewers().remove((Object)iTopologyViewer);
            iTopologyViewer.removeSelectionChangedListener(this.getSelectionChangedListener());
            iTopologyViewer.removeITopologyViewerListener(this.getTopologyViewerListener());
        }
    }

    private ITopologyViewerListener getTopologyViewerListener() {
        if (this.topologyViewerListener == null) {
            this.topologyViewerListener = new ITopologyViewerListener(){

                @Override
                public void mouseClicked(MouseButton button) {
                    TopologyViewerRegistryCustomImpl.this.setLatestMouseButtonCliked(button);
                }

                @Override
                public void keyPressed(char key) {
                    TopologyViewerRegistryCustomImpl.this.setLastKeyPressed(key);
                }

                @Override
                public void keyReleased(char key) {
                    TopologyViewerRegistryCustomImpl.this.setLastKeyReleased(key);
                }

                @Override
                public void busyChanged(boolean oldBusy, boolean newBusy) {
                }

                @Override
                public void antiAliasingChanged(boolean oldAntiAliasing, boolean newAntiAliasing) {
                }
            };
        }
        return this.topologyViewerListener;
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel;
                    if (event != null && event.getSelection() instanceof IStructuredSelection && (sel = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof NodeSelection) {
                        NodeSelection nodeSelection = (NodeSelection)sel.getFirstElement();
                        String message = new String();
                        message = String.valueOf(message) + "Selected Node     : " + nodeSelection.getSelectedNode() + "\n";
                        message = String.valueOf(message) + "Relative Position : " + nodeSelection.getRelativeIntersectionPoint() + "\n";
                        message = String.valueOf(message) + "Absolute Position : " + nodeSelection.getAbsoluteIntersectionPoint() + "\n";
                        message = String.valueOf(message) + "Relative Normal   : " + nodeSelection.getRelativeIntersectionNormal() + "\n";
                        message = String.valueOf(message) + "Absolute Normal   : " + nodeSelection.getAbsoluteIntersectionNormal() + "\n";
                        Logger.debug("New Selection <\n" + message + ">.");
                        TopologyViewerRegistryCustomImpl.this.setLatestNodeSelection(nodeSelection);
                    }
                }
            };
        }
        return this.selectionChangedListener;
    }
}

