/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsFacade;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsFactory;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.ConnectionPoint;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.TopologyRoot;
import org.eclipse.apogy.core.invocator.AbstractType;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.invocator.TypeMemberImplementation;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.eclipse.apogy.core.invocator.delegates.DefaultInvocatorDelegate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyInvocatorDelegate
extends DefaultInvocatorDelegate {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyInvocatorDelegate.class);
    private Map<AbstractTypeImplementation, ApogySystem> apogySystemInstancesMap;
    private Map<ApogySystem, AbstractTypeImplementation> apogySystemToTypeImplementationsMap;
    private static int counter;

    public void newInstance(Environment environment, Variable variable) {
        super.newInstance(environment, variable);
        VariableImplementation variableImplementation = environment.getActiveContext().getVariableImplementationsList().getVariableImplementation(variable);
        this.initializeApogySystems(variableImplementation, this.getApogySystemInstancesMap());
        this.getApogySystemInstancesMap().clear();
        this.getApogySystemToTypeImplementationsMap().clear();
    }

    public void newInstance(Environment environment, AbstractTypeImplementation typeImplementation) {
        super.newInstance(environment, typeImplementation);
        ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)typeImplementation.getAdapterInstance();
        ApogySystem apogySystem = (ApogySystem)typeImplementation.getHandlingType();
        ApogySystem apogySystemInstance = ApogyCoreFactory.eINSTANCE.createApogySystem();
        apogySystemApiAdapter.setApogySystem(apogySystemInstance);
        String name = "null";
        if (apogySystem.getName() != null) {
            name = apogySystem.getName();
        }
        apogySystemInstance.setName("Copy_" + name + " " + counter++);
        this.getApogySystemToTypeImplementationsMap().put(apogySystem, typeImplementation);
        this.getApogySystemInstancesMap().put(typeImplementation, apogySystemInstance);
    }

    private Map<AbstractTypeImplementation, ApogySystem> getApogySystemInstancesMap() {
        if (this.apogySystemInstancesMap == null) {
            this.apogySystemInstancesMap = new HashMap<AbstractTypeImplementation, ApogySystem>();
        }
        return this.apogySystemInstancesMap;
    }

    private Map<ApogySystem, AbstractTypeImplementation> getApogySystemToTypeImplementationsMap() {
        if (this.apogySystemToTypeImplementationsMap == null) {
            this.apogySystemToTypeImplementationsMap = new HashMap<ApogySystem, AbstractTypeImplementation>();
        }
        return this.apogySystemToTypeImplementationsMap;
    }

    public void dispose(Environment environment, Variable variable) {
        super.dispose(environment, variable);
        this.getApogySystemInstancesMap().clear();
        this.apogySystemInstancesMap = null;
    }

    public Class<? extends Type> getHandledTypeClass() {
        return ApogySystem.class;
    }

    private void initializeApogySystems(VariableImplementation variableImplementation, Map<AbstractTypeImplementation, ApogySystem> implementationToApogySystemMap) {
        ApogySystemInitializer initializer;
        HashMap<AbstractTypeImplementation, ApogySystemInitializer> implementationToInitializerMap = new HashMap<AbstractTypeImplementation, ApogySystemInitializer>();
        HashMap<Object, ApogySystemInitializer> typeMemberToInitializerMap = new HashMap<Object, ApogySystemInitializer>();
        for (AbstractTypeImplementation abstractTypeImplementation : implementationToApogySystemMap.keySet()) {
            initializer = new ApogySystemInitializer(abstractTypeImplementation);
            implementationToInitializerMap.put(abstractTypeImplementation, initializer);
            if (abstractTypeImplementation instanceof TypeMemberImplementation) {
                TypeMemberImplementation tmi = (TypeMemberImplementation)abstractTypeImplementation;
                typeMemberToInitializerMap.put(tmi.getTypeMember(), initializer);
                continue;
            }
            if (!(abstractTypeImplementation instanceof VariableImplementation)) continue;
            VariableImplementation vi = (VariableImplementation)abstractTypeImplementation;
            typeMemberToInitializerMap.put(vi, initializer);
        }
        for (AbstractTypeImplementation abstractTypeImplementation : implementationToApogySystemMap.keySet()) {
            initializer = (ApogySystemInitializer)implementationToInitializerMap.get(abstractTypeImplementation);
            String linkSuffix = "_COPY";
            if (initializer.getOriginal().getAssemblyLinksList() == null) continue;
            for (AssemblyLink link : initializer.getOriginal().getAssemblyLinksList().getAssemblyLinks()) {
                TypeMember originalSource = link.getParentTypeMember();
                if (originalSource == null) {
                    if (abstractTypeImplementation instanceof TypeMemberImplementation) {
                        TypeMemberImplementation tmi = (TypeMemberImplementation)abstractTypeImplementation;
                        originalSource = tmi.getTypeMember();
                    } else if (abstractTypeImplementation instanceof VariableImplementation) {
                        VariableImplementation vi = (VariableImplementation)abstractTypeImplementation;
                        originalSource = vi;
                    }
                }
                TypeMember originalDestination = link.getSubSystemTypeMember();
                ApogySystemInitializer sourceInitializer = (ApogySystemInitializer)typeMemberToInitializerMap.get(originalSource);
                ApogySystemInitializer destinationInitializer = (ApogySystemInitializer)typeMemberToInitializerMap.get(originalDestination);
                TypeMember copySource = null;
                if (sourceInitializer.getAbstractTypeImplementation() instanceof TypeMemberImplementation) {
                    TypeMemberImplementation tmi = (TypeMemberImplementation)sourceInitializer.getAbstractTypeImplementation();
                    copySource = tmi.getTypeMember();
                }
                TypeMember copyDestination = null;
                if (destinationInitializer.getAbstractTypeImplementation() instanceof TypeMemberImplementation) {
                    TypeMemberImplementation tmi = (TypeMemberImplementation)destinationInitializer.getAbstractTypeImplementation();
                    copyDestination = tmi.getTypeMember();
                }
                ApogySystem source = sourceInitializer.getCopy();
                ApogySystem destination = destinationInitializer.getCopy();
                AssemblyLink linkCopy = ApogyCoreFactory.eINSTANCE.createAssemblyLink();
                if (linkSuffix != null) {
                    linkCopy.setName(String.valueOf(link.getName()) + linkSuffix);
                }
                linkCopy.setParentTypeMember(copySource);
                linkCopy.setParentConnectionPoint(sourceInitializer.getConnectionPointsMap().get(link.getParentConnectionPoint()));
                linkCopy.setSubSystemTypeMember(copyDestination);
                if (link.getGeometryNode() != null) {
                    linkCopy.setGeometryNode((Node)EcoreUtil.copy((EObject)link.getGeometryNode()));
                }
                if (link.getTransformationMatrix() != null) {
                    linkCopy.setTransformationMatrix((Matrix4x4)EcoreUtil.copy((EObject)link.getTransformationMatrix()));
                }
                linkCopy.setParentInstance(source);
                linkCopy.setSubSystemInstance(destination);
                if (initializer.getCopy().getAssemblyLinksList() == null) {
                    initializer.getCopy().setAssemblyLinksList(ApogyCoreFactory.eINSTANCE.createAssemblyLinksList());
                }
                initializer.getCopy().getAssemblyLinksList().getAssemblyLinks().add((Object)linkCopy);
            }
        }
    }

    public TypeApiAdapter newDefaultTypeApiAdapter() {
        return ApogyCoreFactory.eINSTANCE.createApogySystemApiAdapter();
    }

    private class ApogySystemInitializer {
        private AbstractTypeImplementation abstractTypeImplementation = null;
        private Map<ConnectionPoint, ConnectionPoint> connectionPointsMap = null;
        private Map<Node, Node> originalToCopyNodesMap = null;
        private ApogySystem original = null;
        private ApogySystem copy = null;

        public ApogySystemInitializer(AbstractTypeImplementation abstractTypeImplementation) {
            PoseProvider poseProvider;
            this.abstractTypeImplementation = abstractTypeImplementation;
            ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)abstractTypeImplementation.getAdapterInstance();
            String suffix = null;
            if (abstractTypeImplementation instanceof TypeMemberImplementation) {
                TypeMemberImplementation tmi = (TypeMemberImplementation)abstractTypeImplementation;
                this.original = (ApogySystem)tmi.getTypeMember().getMemberType();
                suffix = "_" + tmi.getTypeMember().getName();
            } else if (abstractTypeImplementation instanceof VariableImplementation) {
                VariableImplementation vi = (VariableImplementation)abstractTypeImplementation;
                this.original = (ApogySystem)vi.getVariable().getVariableType();
                suffix = "_" + vi.getVariable().getName();
            }
            this.copy = apogySystemApiAdapter.getApogySystem();
            if (suffix != null) {
                this.copy.setName(String.valueOf(this.original.getName()) + suffix);
            }
            if (this.copy.getTopologyRoot() == null) {
                this.copy.setTopologyRoot(ApogyCoreFactory.eINSTANCE.createTopologyRoot());
            }
            Map<Node, Node> nodesMap = this.copyTopology(this.original.getTopologyRoot(), this.copy.getTopologyRoot());
            this.getOriginalToCopyNodesMap().putAll(nodesMap);
            if (this.copy.getConnectionPointsList() == null) {
                this.copy.setConnectionPointsList(ApogyCoreFactory.eINSTANCE.createConnectionPointsList());
            }
            Map<ConnectionPoint, ConnectionPoint> pointsMap = this.copyConnectionPoints(this.original, this.copy, this.originalToCopyNodesMap, null);
            this.getConnectionPointsMap().putAll(pointsMap);
            if (this.copy.getBindingSet() == null) {
                this.copy.setBindingSet(ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsSet());
            }
            if (this.original.getPoseProvider() != null) {
                if (abstractTypeImplementation instanceof VariableImplementation) {
                    AbstractType typeMember = this.original.getPoseProvider();
                    VariableImplementation vi = (VariableImplementation)abstractTypeImplementation;
                    AbstractTypeImplementation tmi = ApogyCoreInvocatorFacade.INSTANCE.getTypeImplementation(vi.getVariable(), typeMember);
                    if (tmi.getInstance() instanceof PoseProvider) {
                        PoseProvider poseProvider2 = (PoseProvider)tmi.getInstance();
                        this.copy.setPoseProviderInstance(poseProvider2);
                    } else if (tmi.getAdapterInstance() instanceof PoseProvider) {
                        PoseProvider poseProvider3 = (PoseProvider)tmi.getAdapterInstance();
                        this.copy.setPoseProviderInstance(poseProvider3);
                    }
                }
            } else if (abstractTypeImplementation.getInstance() instanceof PoseProvider) {
                poseProvider = (PoseProvider)abstractTypeImplementation.getInstance();
                this.copy.setPoseProviderInstance(poseProvider);
            } else if (abstractTypeImplementation.getAdapterInstance() instanceof PoseProvider) {
                poseProvider = (PoseProvider)abstractTypeImplementation.getAdapterInstance();
                this.copy.setPoseProviderInstance(poseProvider);
            }
            this.copyBindingsSet(this.original, this.copy, this.originalToCopyNodesMap, apogySystemApiAdapter.getInstance());
            try {
                this.copy.getBindingSet().bind();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public ApogySystem getOriginal() {
            return this.original;
        }

        public ApogySystem getCopy() {
            return this.copy;
        }

        public AbstractTypeImplementation getAbstractTypeImplementation() {
            return this.abstractTypeImplementation;
        }

        public Map<ConnectionPoint, ConnectionPoint> getConnectionPointsMap() {
            if (this.connectionPointsMap == null) {
                this.connectionPointsMap = new HashMap<ConnectionPoint, ConnectionPoint>();
            }
            return this.connectionPointsMap;
        }

        public Map<Node, Node> getOriginalToCopyNodesMap() {
            if (this.originalToCopyNodesMap == null) {
                this.originalToCopyNodesMap = new HashMap<Node, Node>();
            }
            return this.originalToCopyNodesMap;
        }

        private Map<Node, Node> copyTopology(TopologyRoot source, TopologyRoot target) {
            HashMap<Node, Node> originalToCopyMap = new HashMap<Node, Node>();
            if (source != null && target != null) {
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                target.setOriginNode((Node)copier.copy((EObject)source.getOriginNode()));
                for (EObject key : copier.keySet()) {
                    EObject value = (EObject)copier.get((Object)key);
                    if (!(key instanceof Node) || !(value instanceof Node)) continue;
                    this.postProcessCopiedNode((Node)key, (Node)value);
                    originalToCopyMap.put((Node)key, (Node)value);
                }
            }
            return originalToCopyMap;
        }

        private void postProcessCopiedNode(Node original, Node copy) {
            ContentNode originalContentNode;
            if (original instanceof ContentNode && (originalContentNode = (ContentNode)original).getContent() instanceof CartesianTriangularMesh) {
                CartesianTriangularMesh originalMesh = (CartesianTriangularMesh)originalContentNode.getContent();
                CartesianTriangularMesh meshCopy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangularMesh(originalMesh);
                ContentNode copiedContentNode = (ContentNode)copy;
                copiedContentNode.setContent((Object)meshCopy);
            }
        }

        private Map<ConnectionPoint, ConnectionPoint> copyConnectionPoints(ApogySystem source, ApogySystem target, Map<Node, Node> originalToCopyNodesMap, String nameSuffix) {
            HashMap<ConnectionPoint, ConnectionPoint> originalToCopyConnectionPointMap = new HashMap<ConnectionPoint, ConnectionPoint>();
            if (source.getConnectionPointsList() != null) {
                if (target.getConnectionPointsList() == null) {
                    target.setConnectionPointsList(ApogyCoreFactory.eINSTANCE.createConnectionPointsList());
                }
                for (ConnectionPoint connectionPoint : source.getConnectionPointsList().getConnectionPoints()) {
                    ConnectionPoint copy = (ConnectionPoint)EcoreUtil.copy((EObject)connectionPoint);
                    if (nameSuffix != null) {
                        copy.setName(String.valueOf(copy.getName()) + nameSuffix);
                    }
                    GroupNode originalGroupNode = connectionPoint.getNode();
                    GroupNode copyGroupNode = (GroupNode)originalToCopyNodesMap.get(originalGroupNode);
                    copy.setNode(copyGroupNode);
                    originalToCopyConnectionPointMap.put(connectionPoint, copy);
                    target.getConnectionPointsList().getConnectionPoints().add((Object)copy);
                }
            }
            return originalToCopyConnectionPointMap;
        }

        private void copyBindingsSet(ApogySystem source, ApogySystem target, Map<Node, Node> originalToCopyMap, EObject bindingSource) {
            if (source.getBindingSet() != null) {
                if (target.getBindingSet() == null) {
                    target.setBindingSet(ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsSet());
                }
                for (AbstractTopologyBinding binding : source.getBindingSet().getBindingsList().getBindings()) {
                    AbstractTopologyBinding bindingCopy = ApogyCommonTopologyBindingsFacade.INSTANCE.copy(binding, originalToCopyMap);
                    bindingCopy.setSource(bindingSource);
                    target.getBindingSet().getBindingsList().getBindings().add((Object)bindingCopy);
                }
            }
        }
    }
}

