/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.vehicle.LanderSphericalFoot;
import org.eclipse.apogy.addons.vehicle.Wheel;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;

public class LanderSphericalFootJME3Object
extends DefaultJME3SceneObject<LanderSphericalFoot> {
    private Adapter adapter;
    private final AssetManager assetManager;
    private Geometry landerFootGeometry = null;
    private ColorRGBA landerFootColor = ColorRGBA.White;

    public LanderSphericalFootJME3Object(LanderSphericalFoot node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.landerFootGeometry = this.createLanderFootGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.landerFootGeometry);
        ((LanderSphericalFoot)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.landerFootGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.landerFootGeometry);
        }
        this.landerFootGeometry = this.createLanderFootGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.landerFootGeometry);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.landerFootGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((LanderSphericalFoot)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public void setColor(RGBA rgb) {
        this.landerFootColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (LanderSphericalFootJME3Object.this.landerFootGeometry != null) {
                    LanderSphericalFootJME3Object.this.landerFootGeometry.getMaterial().setColor("Color", LanderSphericalFootJME3Object.this.landerFootColor.clone());
                }
                return null;
            }
        });
    }

    private Geometry createLanderFootGeometry() {
        Geometry geometry = new Geometry("Lander Spherical Foot Body", this.createLanderFootMesh());
        geometry.setMaterial(this.createLanderFootMaterial());
        Quaternion q = new Quaternion();
        q.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 1.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Mesh createLanderFootMesh() {
        Sphere sphere = new Sphere(18, 10, (float)((LanderSphericalFoot)this.getTopologyNode()).getRadius());
        sphere.setMode(Mesh.Mode.Lines);
        return sphere;
    }

    private Material createLanderFootMaterial() {
        ColorRGBA color = this.landerFootColor.clone();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Wheel) {
                        int featureId = msg.getFeatureID(LanderSphericalFoot.class);
                        switch (featureId) {
                            case 12: {
                                LanderSphericalFootJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

