/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.gps;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GPSQuality implements Enumerator
{
    INVALID(0, "INVALID", "INVALID"),
    GPS_FIX(1, "GPS_FIX", "GPS_FIX"),
    DGPS_FIX(2, "DGPS_FIX", "DGPS_FIX"),
    PPS_FIX(3, "PPS_FIX", "PPS_FIX"),
    RTK(4, "RTK", "RTK"),
    FLOAT_RTK(5, "FLOAT_RTK", "FLOAT_RTK"),
    ESTIMATED(6, "ESTIMATED", "ESTIMATED"),
    MANUAL_INPUT(7, "MANUAL_INPUT", "MANUAL_INPUT"),
    SIMULATION(8, "SIMULATION", "SIMULATION");

    public static final int INVALID_VALUE = 0;
    public static final int GPS_FIX_VALUE = 1;
    public static final int DGPS_FIX_VALUE = 2;
    public static final int PPS_FIX_VALUE = 3;
    public static final int RTK_VALUE = 4;
    public static final int FLOAT_RTK_VALUE = 5;
    public static final int ESTIMATED_VALUE = 6;
    public static final int MANUAL_INPUT_VALUE = 7;
    public static final int SIMULATION_VALUE = 8;
    private static final GPSQuality[] VALUES_ARRAY;
    public static final List<GPSQuality> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GPSQuality[]{INVALID, GPS_FIX, DGPS_FIX, PPS_FIX, RTK, FLOAT_RTK, ESTIMATED, MANUAL_INPUT, SIMULATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GPSQuality get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GPSQuality result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GPSQuality getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GPSQuality result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GPSQuality get(int value) {
        switch (value) {
            case 0: {
                return INVALID;
            }
            case 1: {
                return GPS_FIX;
            }
            case 2: {
                return DGPS_FIX;
            }
            case 3: {
                return PPS_FIX;
            }
            case 4: {
                return RTK;
            }
            case 5: {
                return FLOAT_RTK;
            }
            case 6: {
                return ESTIMATED;
            }
            case 7: {
                return MANUAL_INPUT;
            }
            case 8: {
                return SIMULATION;
            }
        }
        return null;
    }

    private GPSQuality(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

