/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.gps.impl;

import java.util.ArrayList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.SensorStatus;
import org.eclipse.apogy.addons.sensors.gps.GPS;
import org.eclipse.apogy.addons.sensors.gps.GPSPoseSensor;
import org.eclipse.apogy.addons.sensors.gps.GPSReading;
import org.eclipse.apogy.addons.sensors.gps.GPSStatus;
import org.eclipse.apogy.addons.sensors.gps.MarkedGPS;
import org.eclipse.apogy.addons.sensors.gps.impl.GPSPoseSensorImpl;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.emf.DefaultListEventDelegate;
import org.eclipse.apogy.common.emf.EListAdapter;
import org.eclipse.apogy.common.emf.ListEventDelegate;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianOrientationCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.apogy.common.geometry.data3d.PositionMarker;
import org.eclipse.apogy.common.geometry.data3d.RigidBodyPoseTracker;
import org.eclipse.apogy.common.lang.java.Timer;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSPoseSensorCustomImpl
extends GPSPoseSensorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(GPSPoseSensorImpl.class);
    private RigidBodyPoseTracker rigidBodyPoseTracker = null;
    private Matrix4d referenceMatrix;
    private Adapter gpsListener;
    private ListEventDelegate<GPS> gpsListDelegate;

    @Override
    public void setStarted(boolean newStarted) {
        boolean oldStarted = this.started;
        this.started = newStarted;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldStarted, this.started));
        }
        if (this.started && newStarted != oldStarted) {
            this.getServerJob().schedule();
        } else if (!this.started && newStarted != oldStarted) {
            this.getServerJob().cancel();
        }
    }

    public Pose getPose() {
        if (!this.isStarted()) {
            this.setStarted(true);
        }
        return super.getPose();
    }

    @Override
    public Job getServerJob() {
        if (this.serverJob == null) {
            this.serverJob = new Job("GPS Pose Sensor"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        monitor.beginTask("GPS", -1);
                        monitor.subTask("Initializing");
                        GPSPoseSensorCustomImpl.this.initialize();
                        monitor.subTask("Updating");
                        Timer timer = new Timer();
                        long periodTime = 1000L;
                        while (GPSPoseSensorCustomImpl.this.isStarted() || !monitor.isCanceled()) {
                            timer.start();
                            GPSPoseSensorCustomImpl.this.updatePose();
                            long time = timer.stop();
                            long delta = periodTime - time;
                            if (delta <= 0L) continue;
                            try {
                                Thread.sleep(delta);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        monitor.done();
                    }
                    catch (RuntimeException e) {
                        status = new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(GPSPoseSensorCustomImpl.this.getClass()), "Error while initializing", (Throwable)e);
                    }
                    return status;
                }
            };
        }
        return this.serverJob;
    }

    private void updatePose() {
        if (this.getStatus() == SensorStatus.READY) {
            try {
                if (this.getGps().isEmpty()) {
                    throw new IllegalArgumentException("At least one gps is needed");
                }
                Pose currentPose = null;
                if (this.getGps().size() == 1) {
                    currentPose = this.computePoseOneGPS((GPS)this.getGps().get(0));
                } else if (this.getGps().size() == 2) {
                    currentPose = this.computePoseTwoGPS();
                } else if (this.getGps().size() >= 3) {
                    currentPose = this.computePoseNGPS();
                }
                if (currentPose != null) {
                    currentPose = this.convertToLocalFrame(currentPose);
                    org.eclipse.apogy.common.math.Tuple3d position = ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)new Vector3d(currentPose.getX(), currentPose.getY(), currentPose.getZ()));
                    this.setPosition(position);
                    Matrix3d rotMat = GeometricUtils.packXYZ((double)currentPose.getXRotation(), (double)currentPose.getYRotation(), (double)currentPose.getZRotation());
                    if (this.getGps().size() == 1) {
                        currentPose = this.computePoseOneGPS((GPS)this.getGps().get(0));
                    } else if (this.getGps().size() == 2) {
                        currentPose = this.computePoseTwoGPS();
                    } else if (this.getGps().size() >= 3) {
                        currentPose = this.computePoseNGPS();
                    }
                    Matrix3x3 mat = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rotMat);
                    this.setRotationMatrix(mat);
                }
            }
            catch (Throwable throwable) {
                this.setStatus(SensorStatus.FAILED);
                org.eclipse.apogy.common.math.Tuple3d newPosition = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
                this.setPosition(newPosition);
                Matrix3d newRotationMatrix = new Matrix3d();
                newRotationMatrix.setIdentity();
                Matrix3x3 newMat = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(newRotationMatrix);
                this.setRotationMatrix(newMat);
            }
        } else {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void initialize() {
        this.setStatus(SensorStatus.BUSY);
        for (MarkedGPS gps : this.getGps()) {
            gps.start();
        }
        for (MarkedGPS gps : this.getGps()) {
            boolean done = false;
            Timer timer = new Timer();
            timer.start();
            while (!done) {
                GPSReading reading = gps.getReading();
                if (reading == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    done = true;
                }
                if (timer.elapsed() <= this.getMaxInitTime()) continue;
                this.setStatus(SensorStatus.FAILED);
                throw new RuntimeException("Cannot initialize device, unable to read from gps " + gps.getMarker().getIdentifier());
            }
        }
        this.setStatus(SensorStatus.READY);
    }

    @Override
    public EList<MarkedGPS> getGps() {
        if (this.gps == null) {
            this.gps = new EObjectContainmentEList(MarkedGPS.class, (InternalEObject)this, 15);
            EListAdapter adapter = new EListAdapter(15, this.getGpsListDelegate(), GPSPoseSensor.class);
            this.eAdapters().add((Object)adapter);
        }
        return this.gps;
    }

    private ListEventDelegate<GPS> getGpsListDelegate() {
        if (this.gpsListDelegate == null) {
            this.gpsListDelegate = new DefaultListEventDelegate<GPS>(){

                public void added(GPS element) {
                    element.eAdapters().add((Object)GPSPoseSensorCustomImpl.this.getGpsListener());
                }

                public void removed(GPS element) {
                    element.eAdapters().remove((Object)GPSPoseSensorCustomImpl.this.getGpsListener());
                }
            };
        }
        return this.gpsListDelegate;
    }

    private Pose computePoseNGPS() {
        ArrayList<PositionMarker> listPositionMarker = new ArrayList<PositionMarker>();
        int i = 0;
        while (i < this.getGps().size()) {
            GPSReading reading = ((MarkedGPS)this.getGps().get(i)).getReading();
            Vector3d gpsPosition = this.convertGpsToXYZ(reading);
            PositionMarker marker = ApogyCommonGeometryData3DFactory.eINSTANCE.createPositionMarker();
            marker.setX(gpsPosition.getX());
            marker.setY(gpsPosition.getY());
            marker.setZ(gpsPosition.getZ());
            marker.setIdentifier(((MarkedGPS)this.getGps().get(i)).getMarker().getIdentifier());
            listPositionMarker.add(marker);
            ++i;
        }
        Matrix4d roverPose = new Matrix4d();
        try {
            roverPose = this.getPoseTracker().computeTransformation(listPositionMarker);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        Matrix3d roverRotationMatrix = new Matrix3d();
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                roverRotationMatrix.setElement(i2, j, roverPose.getElement(i2, j));
                ++j;
            }
            ++i2;
        }
        Vector3d rollPitchYaw = GeometricUtils.extractRotationFromZYXRotMatrix((Matrix3d)roverRotationMatrix);
        Pose pose1 = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
        pose1.setXRotation(rollPitchYaw.getX());
        pose1.setYRotation(rollPitchYaw.getY());
        pose1.setZRotation(rollPitchYaw.getZ());
        pose1.setX(roverPose.m03);
        pose1.setY(roverPose.m13);
        pose1.setZ(roverPose.m23);
        return pose1;
    }

    private RigidBodyPoseTracker getPoseTracker() {
        if (this.rigidBodyPoseTracker == null) {
            this.rigidBodyPoseTracker = ApogyCommonGeometryData3DFactory.eINSTANCE.createRigidBodyPoseTracker();
            ArrayList<PositionMarker> listPositionMarkerAtOrigin = new ArrayList<PositionMarker>();
            int i = 0;
            while (i < this.getGps().size()) {
                PositionMarker marker = ((MarkedGPS)this.getGps().get(i)).getMarker();
                listPositionMarkerAtOrigin.add(marker);
                ++i;
            }
            try {
                this.rigidBodyPoseTracker.addPositionMarkers(listPositionMarkerAtOrigin);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.rigidBodyPoseTracker;
    }

    public void resetOrientation(CartesianOrientationCoordinates newOrientation) throws Exception {
        Matrix3d rotationMatrix = null;
        if (newOrientation != null) {
            double rx = newOrientation.getXRotation();
            double ry = newOrientation.getYRotation();
            double rz = newOrientation.getZRotation();
            rotationMatrix = GeometricUtils.packXYZ((double)rx, (double)ry, (double)rz);
        } else {
            rotationMatrix = new Matrix3d();
            rotationMatrix.setIdentity();
        }
        this.getReferenceMatrix().setRotation(rotationMatrix);
    }

    public void resetPose(Pose newPose) throws Exception {
        if (newPose == null) {
            this.getReferenceMatrix().setIdentity();
        } else {
            double x = newPose.getX();
            double y = newPose.getY();
            double z = newPose.getZ();
            CartesianPositionCoordinates newPosition = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
            double rx = newPose.getXRotation();
            double ry = newPose.getYRotation();
            double rz = newPose.getZRotation();
            CartesianOrientationCoordinates newOrientation = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianOrientationCoordinates(rx, ry, rz);
            this.resetPosition(newPosition);
            this.resetOrientation(newOrientation);
        }
    }

    public void resetPosition(CartesianPositionCoordinates newPosition) throws Exception {
        Vector3d translation = null;
        if (newPosition != null) {
            double x = newPosition.getX();
            double y = newPosition.getY();
            double z = newPosition.getZ();
            translation = new Vector3d(x, y, z);
        } else {
            translation = new Vector3d(0.0, 0.0, 0.0);
        }
        this.getReferenceMatrix().setTranslation(translation);
    }

    private Pose computePoseOneGPS(GPS gps) {
        Pose pose = null;
        GPSReading reading = gps.getReading();
        if (reading != null && reading.getQuality().getValue() > 0) {
            Vector3d xyz = this.convertGpsToXYZ(reading);
            pose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
            pose.setX(xyz.getX());
            pose.setY(xyz.getY());
            pose.setZ(xyz.getZ());
        }
        return pose;
    }

    private Pose computePoseTwoGPS() {
        Pose pose = null;
        GPSReading reading1 = ((MarkedGPS)this.getGps().get(0)).getReading();
        GPSReading reading2 = ((MarkedGPS)this.getGps().get(1)).getReading();
        if (reading1 != null && reading2 != null && reading1.getQuality().getValue() > 0 && reading2.getQuality().getValue() > 0) {
            Vector3d xyz1 = this.convertGpsToXYZ(reading1);
            Vector3d xyz2 = this.convertGpsToXYZ(reading2);
            pose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
            pose.setX((xyz1.getX() + xyz2.getX()) / 2.0);
            pose.setY((xyz1.getY() + xyz2.getY()) / 2.0);
            pose.setZ((xyz1.getZ() + xyz2.getZ()) / 2.0);
        }
        return pose;
    }

    private Vector3d convertGpsToXYZ(GPSReading reading) {
        if (reading == null) {
            throw new IllegalArgumentException("reading is null");
        }
        GlobalCoordinates origin = new GlobalCoordinates(this.getOriginLatitude(), this.getOriginLongitude());
        Vector3d result = new Vector3d();
        GeodeticCalculator geoCalc = new GeodeticCalculator();
        Ellipsoid reference = Ellipsoid.WGS84;
        GlobalCoordinates Rover = new GlobalCoordinates(reading.getLatitude(), reading.getLongitude());
        GeodeticCurve geoCurve = geoCalc.calculateGeodeticCurve(reference, origin, Rover);
        double DN = -geoCurve.getEllipsoidalDistance() * Math.cos(Math.toRadians(geoCurve.getAzimuth()));
        double DE = -geoCurve.getEllipsoidalDistance() * Math.sin(Math.toRadians(geoCurve.getAzimuth()));
        double xGPS = DN * Math.cos(Math.toRadians(this.getNeAngle())) + DE * Math.sin(Math.toRadians(this.getNeAngle()));
        double yGPS = -1.0 * (-DN * Math.sin(Math.toRadians(this.getNeAngle())) + DE * Math.cos(Math.toRadians(this.getNeAngle())));
        double zGPS = reading.getElevation() - this.getOriginElevation();
        result.setX(xGPS);
        result.setY(yGPS);
        result.setZ(zGPS);
        return result;
    }

    private Pose convertToLocalFrame(Pose pose) {
        Pose localFramePose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
        Matrix4d refInvert = new Matrix4d();
        refInvert.invert(this.getReferenceMatrix());
        Matrix4d poseMat = new Matrix4d();
        poseMat.setIdentity();
        double rx = pose.getXRotation();
        double ry = pose.getYRotation();
        double rz = pose.getZRotation();
        Matrix3d rotMat = GeometricUtils.packXYZ((double)rx, (double)ry, (double)rz);
        poseMat.setRotation(rotMat);
        poseMat.setTranslation(new Vector3d((Tuple3d)pose.asPoint3d()));
        poseMat.mul(refInvert);
        rotMat = new Matrix3d();
        poseMat.get(rotMat);
        Vector3d tr = new Vector3d();
        poseMat.get(tr);
        Vector3d rotations = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rotMat);
        localFramePose.setXRotation(rotations.getX());
        localFramePose.setYRotation(rotations.getY());
        localFramePose.setZRotation(rotations.getZ());
        localFramePose.setX(tr.getX());
        localFramePose.setY(tr.getY());
        localFramePose.setZ(tr.getZ());
        return localFramePose;
    }

    private Matrix4d getReferenceMatrix() {
        if (this.referenceMatrix == null) {
            this.referenceMatrix = new Matrix4d();
            this.referenceMatrix.setIdentity();
        }
        return this.referenceMatrix;
    }

    private Adapter getGpsListener() {
        if (this.gpsListener == null) {
            this.gpsListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(GPSPoseSensor.class);
                    if (featureId == 3) {
                        if (msg.getNewValue() == GPSStatus.RECONNECTING) {
                            GPSPoseSensorCustomImpl.this.setStatus(SensorStatus.BUSY);
                        }
                        if (msg.getNewValue() == GPSStatus.RUNNING && GPSPoseSensorCustomImpl.this.verifyAllGpsStatus(GPSStatus.RUNNING)) {
                            GPSPoseSensorCustomImpl.this.setStatus(SensorStatus.READY);
                        }
                    }
                }
            };
        }
        return this.gpsListener;
    }

    private boolean verifyAllGpsStatus(GPSStatus expectedStatus) {
        boolean valid = true;
        for (GPS gps : this.getGps()) {
            boolean bl = valid = gps.getStatus() == expectedStatus;
            if (!valid) break;
        }
        return valid;
    }
}

