/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.provider.GeographicCoordinatesItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class GeographicCoordinatesCustomItemProvider
extends GeographicCoordinatesItemProvider {
    public static final String DEGREE_STRING = "\u00b0";
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0###########");
    private final DecimalFormat altitudeDecimalFormat = new DecimalFormat("0.0");

    public GeographicCoordinatesCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        GeographicCoordinates geographicCoordinates = (GeographicCoordinates)object;
        String string = this.getString("_UI_GeographicCoordinates_type");
        string = String.valueOf(string) + this.getSuffix(geographicCoordinates);
        return string;
    }

    protected String getSuffix(GeographicCoordinates geographicCoordinates) {
        String string = " (" + this.decimalFormat.format(Math.toDegrees(geographicCoordinates.getLatitude())) + DEGREE_STRING;
        string = String.valueOf(string) + ", ";
        string = String.valueOf(string) + this.decimalFormat.format(Math.toDegrees(geographicCoordinates.getLongitude())) + DEGREE_STRING;
        string = String.valueOf(string) + ", ";
        string = String.valueOf(string) + this.altitudeDecimalFormat.format(geographicCoordinates.getElevation()) + "m)";
        return string;
    }
}

