/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data.impl;

import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.CoordinatesSamplingShape;
import org.eclipse.apogy.common.geometry.data.CoordinatesSet;
import org.eclipse.apogy.common.geometry.data.ShapeSamplingMode;
import org.eclipse.apogy.common.geometry.data.impl.CoordinatesSetShapesSamplerImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoordinatesSetShapesSamplerCustomImpl<T extends Coordinates>
extends CoordinatesSetShapesSamplerImpl<T> {
    public CoordinatesSet<T> doProcess(CoordinatesSet<T> input, IProgressMonitor monitor) throws Exception {
        CoordinatesSet<T> sampled = this.createCoordinatesSet(input);
        monitor.beginTask("Sampling using " + this.getCoordinatesSamplingShapes().size() + " sampling shapes. ", input.getPoints().size());
        int i = 0;
        while (i < input.getPoints().size()) {
            Coordinates point = (Coordinates)input.getPoints().get(i);
            if (this.isPointInside(point)) {
                sampled.getPoints().add((Object)this.copyCoordinates(point));
                monitor.worked(1);
            }
            ++i;
        }
        monitor.done();
        return sampled;
    }

    protected CoordinatesSet<T> createCoordinatesSet(CoordinatesSet<T> input) {
        return null;
    }

    protected T copyCoordinates(T point) {
        throw new UnsupportedOperationException();
    }

    private boolean isPointInside(T point) {
        boolean inside;
        block3: {
            block2: {
                inside = false;
                if (this.getShapeSamplingMode() != ShapeSamplingMode.UNION) break block2;
                inside = false;
                int j = 0;
                while (j < this.getCoordinatesSamplingShapes().size() && !inside) {
                    CoordinatesSamplingShape samplingShape = (CoordinatesSamplingShape)this.getCoordinatesSamplingShapes().get(j);
                    inside |= samplingShape.isInside(point);
                    ++j;
                }
                break block3;
            }
            if (this.getShapeSamplingMode() != ShapeSamplingMode.INTERSECTION) break block3;
            inside = true;
            int j = 0;
            while (j < this.getCoordinatesSamplingShapes().size() && inside) {
                CoordinatesSamplingShape samplingShape = (CoordinatesSamplingShape)this.getCoordinatesSamplingShapes().get(j);
                inside &= samplingShape.isInside(point);
                ++j;
            }
        }
        return inside;
    }
}

