/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.commands;

import org.eclipse.apogy.addons.vehicle.PathPlannerTool;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class PathPlannerToolReplanCommand
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object selection : (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)) {
            if (!(selection instanceof PathPlannerTool)) continue;
            final PathPlannerTool pathPlannerTool = (PathPlannerTool)selection;
            if (!pathPlannerTool.isBusy()) {
                Job job = new Job("Re-Plan Path"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            boolean success = pathPlannerTool.planPath();
                            if (success) {
                                return Status.OK_STATUS;
                            }
                            return new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), "No path found !");
                        }
                        catch (Throwable t) {
                            return new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), "Failed to Re-Plan path !", t);
                        }
                    }
                };
                job.schedule();
                continue;
            }
            return new Status(2, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), "Re-Plan path rejected : path planner is busy.");
        }
        return null;
    }
}

