/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.atmosphere.ui.jme3.utils;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.atmosphere.EarthAtmosphereWorksiteNode;
import org.eclipse.apogy.core.environment.earth.atmosphere.ui.Activator;
import org.eclipse.apogy.core.environment.earth.atmosphere.ui.jme3.utils.Circle;
import org.eclipse.apogy.core.environment.earth.atmosphere.ui.jme3.utils.SurfaceImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereJME3Utilities {
    private static final Logger Logger = LoggerFactory.getLogger(AtmosphereJME3Utilities.class);
    private static int wmsImageCount = 0;
    public static double EARTH_RADIUS_METERS = 6371000.0;
    private static Map<EarthAtmosphereWorksiteNode, SurfaceImage> surfaceImageMap = new HashMap<EarthAtmosphereWorksiteNode, SurfaceImage>();

    public static double getHorizonAngle(double altitude) {
        return -Math.acos(EARTH_RADIUS_METERS / (EARTH_RADIUS_METERS + altitude));
    }

    public static double computeHorizonDistance(double altitude) {
        double gamma = AtmosphereJME3Utilities.getHorizonAngle(altitude);
        return Math.abs(gamma) * EARTH_RADIUS_METERS;
    }

    public static double computeHorizonRadius(double altitude, double horizonDistance, double altitudecutoff) {
        double gamma = AtmosphereJME3Utilities.getHorizonAngle(altitude);
        double dx = horizonDistance * Math.cos(gamma);
        double dy = horizonDistance * Math.sin(gamma);
        Point2d p1 = new Point2d(-dx, -dy);
        Point2d p2 = new Point2d(0.0, -altitudecutoff);
        Point2d p3 = new Point2d(dx, -dy);
        double mr = (p2.y - p1.y) / (p2.x - p1.x);
        double mt = (p3.y - p2.y) / (p3.x - p2.x);
        double x = (mr * mt * (p3.y - p1.y) + mr * (p2.x + p3.x) - mt * (p1.x + p2.x)) / (2.0 * (mr - mt));
        double y = (p1.y + p2.y) / 2.0 - (x - (p1.x + p2.x) / 2.0) / mr;
        double radius = Math.sqrt(Math.pow(p2.x - x, 2.0) + Math.pow(p2.y - y, 2.0));
        return radius;
    }

    public static Circle computeHorizonCircle(double altitude, double horizonDistance, double altitudecutoff) {
        double gamma = AtmosphereJME3Utilities.getHorizonAngle(altitude);
        double dx = horizonDistance * Math.cos(gamma);
        double dy = horizonDistance * Math.sin(gamma);
        Point2d p1 = new Point2d(-dx, dy);
        Point2d p2 = null;
        p2 = altitude <= altitudecutoff ? new Point2d(0.0, -altitude) : new Point2d(0.0, -altitudecutoff);
        Point2d p3 = new Point2d(dx, dy);
        return AtmosphereJME3Utilities.finCircleThroughPoints(p1, p2, p3);
    }

    public static Circle finCircleThroughPoints(Point2d p1, Point2d p2, Point2d p3) {
        double mr = (p2.y - p1.y) / (p2.x - p1.x);
        double mt = (p3.y - p2.y) / (p3.x - p2.x);
        double xCenter = (mr * mt * (p3.y - p1.y) + mr * (p2.x + p3.x) - mt * (p1.x + p2.x)) / (2.0 * (mr - mt));
        double yCenter = (p1.y + p2.y) / 2.0 - (xCenter - (p1.x + p2.x) / 2.0) / mr;
        double radius = Math.sqrt(Math.pow(p2.x - xCenter, 2.0) + Math.pow(p2.y - yCenter, 2.0));
        return new Circle(radius, xCenter, yCenter);
    }

    public static List<Point3d> getCircle(Circle circle) {
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        double angle = 0.0;
        while (angle < Math.PI * 2) {
            double x = circle.xCenter + circle.radius * Math.cos(angle += Math.toRadians(0.1));
            double z = circle.yCenter + circle.radius * Math.sin(angle);
            Point3d p = new Point3d(x, 0.0, z);
            points.add(p);
        }
        return points;
    }

    public static List<Vector3f> getHyperbola(double a, double b, double d) {
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        double x = a;
        double y = 0.0;
        while (y < d) {
            y = b / a * Math.sqrt(x * x - a * a);
            Vector3f p = new Vector3f((float)y, 0.0f, (float)(-x));
            points.add(p);
            x += 100.0;
        }
        return points;
    }

    public static Mesh getParabolaGeometry(List<Vector3f> profile) {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        ArrayList<Vector2f> textureCoordinatesList = new ArrayList<Vector2f>();
        double angle = 0.0;
        double angleIncrement = Math.toRadians(10.0);
        List<Vector3f> previousProfile = profile;
        verticesList.addAll(previousProfile);
        for (Vector3f v : profile) {
            double distance = Math.sqrt(v.x * v.x + v.y * v.y);
            double x = distance * Math.cos(angle) + 15000.0;
            double y = distance * Math.sin(angle) + 15000.0;
            float textureX = (float)(x / 30000.0);
            float textureY = (float)(y / 30000.0);
            Vector2f textCoord = new Vector2f(textureX, textureY);
            textureCoordinatesList.add(textCoord);
        }
        while (angle <= Math.PI * 2) {
            List<Vector3f> rotatedProfile = AtmosphereJME3Utilities.rotateAroundZ(profile, angle);
            verticesList.addAll(rotatedProfile);
            for (Vector3f v : profile) {
                double distance = Math.sqrt(v.x * v.x + v.y * v.y);
                double x = distance * Math.cos(angle) + 15000.0;
                double y = distance * Math.sin(angle) + 15000.0;
                float textureX = (float)(x / 30000.0);
                float textureY = (float)(y / 30000.0);
                Vector2f textCoord = new Vector2f(textureX, textureY);
                textureCoordinatesList.add(textCoord);
            }
            int i = 0;
            while (i < rotatedProfile.size() - 1) {
                int a0 = verticesList.indexOf(previousProfile.get(i));
                int a1 = verticesList.indexOf(previousProfile.get(i + 1));
                int b0 = verticesList.indexOf(rotatedProfile.get(i));
                int b1 = verticesList.indexOf(rotatedProfile.get(i + 1));
                indexesList.add(new Integer(a0));
                indexesList.add(new Integer(b0));
                indexesList.add(new Integer(b1));
                indexesList.add(new Integer(a0));
                indexesList.add(new Integer(a1));
                indexesList.add(new Integer(b1));
                ++i;
            }
            previousProfile = rotatedProfile;
            angle += angleIncrement;
        }
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertListOfVector2fToFloatArray(textureCoordinatesList)));
        mesh.updateBound();
        return mesh;
    }

    public static AbstractEImage getImageFromWMS(EarthAtmosphereWorksiteNode worksiteNode, GeographicCoordinates geographicCoordinates, double bufferDistance) throws Exception {
        SurfaceImage surfaceImage = surfaceImageMap.get(worksiteNode);
        if (surfaceImage == null) {
            surfaceImage = AtmosphereJME3Utilities.getSurfaceImage(geographicCoordinates, bufferDistance);
            if (surfaceImage != null) {
                surfaceImageMap.put(worksiteNode, surfaceImage);
            }
        } else if (!AtmosphereJME3Utilities.projectsOntoSurfaceImage(surfaceImage, geographicCoordinates) && (surfaceImage = AtmosphereJME3Utilities.getSurfaceImage(geographicCoordinates, bufferDistance)) != null) {
            surfaceImageMap.put(worksiteNode, surfaceImage);
        }
        if (surfaceImage != null) {
            return AtmosphereJME3Utilities.getSubImage(surfaceImage, geographicCoordinates);
        }
        return null;
    }

    private static SurfaceImage getSurfaceImage(GeographicCoordinates geographicCoordinates, double bufferDistance) {
        double gamma = Math.abs(AtmosphereJME3Utilities.getHorizonAngle(geographicCoordinates.getElevation()));
        double bufferAngle = Math.abs(bufferDistance / EARTH_RADIUS_METERS);
        double deltaLatitudeAngle = gamma + bufferAngle;
        double deltaLongitudeAngle = gamma + bufferAngle;
        double minLatitude = geographicCoordinates.getLatitude() - deltaLatitudeAngle;
        double maxLatitude = geographicCoordinates.getLatitude() + deltaLatitudeAngle;
        if (minLatitude > Math.toRadians(90.0)) {
            minLatitude = Math.toRadians(90.0);
        }
        if (minLatitude < Math.toRadians(-90.0)) {
            minLatitude = Math.toRadians(-90.0);
        }
        if (maxLatitude > Math.toRadians(90.0)) {
            maxLatitude = Math.toRadians(90.0);
        }
        if (maxLatitude < Math.toRadians(-90.0)) {
            maxLatitude = Math.toRadians(-90.0);
        }
        double minLongitude = geographicCoordinates.getLongitude() - deltaLongitudeAngle;
        double maxLongitude = geographicCoordinates.getLongitude() + deltaLongitudeAngle;
        String serverRequestURL = String.valueOf(Activator.getWMSUrl()) + "?&VERSION=1.1.1&REQUEST=";
        String[] layers = Activator.getWMSLayers();
        String layerName = "";
        if (layers.length > 1) {
            int i = 0;
            while (i < layers.length) {
                layerName = String.valueOf(layerName) + layers[i] + ",";
                ++i;
            }
        } else {
            layerName = layers[0];
        }
        String bboxString = "&BBOX=" + Math.toDegrees(minLongitude) + "," + Math.toDegrees(minLatitude) + "," + Math.toDegrees(maxLongitude) + "," + Math.toDegrees(maxLatitude);
        String requestString = "GetMap&LAYERS=" + layerName + "&STYLES=&SRS=EPSG:4326" + bboxString + "&WIDTH=1024&HEIGHT=1024&FORMAT=image/png";
        String urlString = String.valueOf(serverRequestURL) + requestString;
        try {
            Logger.info("Getting new image from WMS : " + urlString);
            URI uri = new URI(urlString);
            URL url = uri.toURL();
            URLConnection c = url.openConnection();
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            BufferedImage img = null;
            img = ImageIO.read(c.getInputStream());
            BufferedImage bufferedImage = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 2);
            Graphics2D bGr = bufferedImage.createGraphics();
            bGr.drawImage((Image)img, 0, 0, null);
            bGr.dispose();
            SurfaceImage surfaceImage = new SurfaceImage();
            surfaceImage.minLatitude = minLatitude;
            surfaceImage.maxLatitude = maxLatitude;
            surfaceImage.minLongitude = minLongitude;
            surfaceImage.maxLongitude = maxLongitude;
            surfaceImage.image = bufferedImage;
            Logger.info("Sucessfully got image number <" + ++wmsImageCount + "> from WMS." + urlString);
            return surfaceImage;
        }
        catch (Exception e) {
            Logger.error("Failed to get image from WMS : " + urlString, (Throwable)e);
            return null;
        }
    }

    private static boolean projectsOntoSurfaceImage(SurfaceImage surfaceImage, GeographicCoordinates geographicCoordinates) {
        double gamma = Math.abs(AtmosphereJME3Utilities.getHorizonAngle(geographicCoordinates.getElevation()));
        double projectionMinLatitude = geographicCoordinates.getLatitude() - gamma;
        double projectionMaxLatitude = geographicCoordinates.getLatitude() + gamma;
        double projectionMinLongitude = geographicCoordinates.getLongitude() - gamma;
        double projectionMaxLongitude = geographicCoordinates.getLongitude() + gamma;
        return projectionMinLatitude >= surfaceImage.minLatitude && projectionMaxLatitude <= surfaceImage.maxLatitude && projectionMinLongitude >= surfaceImage.minLongitude && projectionMaxLongitude <= surfaceImage.maxLongitude;
    }

    private static AbstractEImage getSubImage(SurfaceImage surfaceImage, GeographicCoordinates geographicCoordinates) {
        if (surfaceImage.image != null) {
            int zoneImageWidth = surfaceImage.image.getWidth();
            int zoneImageHeight = surfaceImage.image.getHeight();
            double gamma = Math.abs(AtmosphereJME3Utilities.getHorizonAngle(geographicCoordinates.getElevation()));
            double projectionVerticalOffset = (geographicCoordinates.getLatitude() - gamma - surfaceImage.minLatitude) / (surfaceImage.maxLatitude - surfaceImage.minLatitude);
            double projectionHorizontalOffset = (geographicCoordinates.getLongitude() - gamma - surfaceImage.minLongitude) / (surfaceImage.maxLongitude - surfaceImage.minLongitude);
            int subImageHeight = (int)Math.round(2.0 * gamma / (surfaceImage.maxLatitude - surfaceImage.minLatitude) * (double)zoneImageWidth);
            int subImageWidth = (int)Math.round(2.0 * gamma / (surfaceImage.maxLongitude - surfaceImage.minLongitude) * (double)zoneImageHeight);
            int widthOffset = (int)Math.floor(projectionHorizontalOffset * (double)zoneImageWidth);
            int heightOffset = zoneImageHeight - (int)Math.floor(projectionVerticalOffset * (double)zoneImageHeight) - subImageHeight;
            if (heightOffset < 0) {
                heightOffset = 0;
            }
            EImage zoneImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            zoneImage.setImageContent(surfaceImage.image);
            try {
                return EImagesUtilities.INSTANCE.getSubImage((AbstractEImage)zoneImage, widthOffset, heightOffset, subImageWidth, subImageHeight);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static double getPixelResolution(double zoom, double latitude) {
        double earthCircumference = Math.PI * 2 * EARTH_RADIUS_METERS;
        double t = Math.pow(2.0, zoom + 8.0);
        return Math.cos(latitude) * (earthCircumference / t);
    }

    private static List<Vector3f> rotateAroundZ(List<Vector3f> profile, double angle) {
        ArrayList<Vector3f> rotatedProfile = new ArrayList<Vector3f>();
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        Matrix3d rot = new Matrix3d();
        rot.setIdentity();
        rot.rotZ(angle);
        m.setRotation(rot);
        for (Vector3f v : profile) {
            Point3d p = new Point3d((double)v.x, (double)v.y, (double)v.z);
            m.transform(p);
            Vector3f rotatedV = new Vector3f((float)p.x, (float)p.y, (float)p.z);
            rotatedProfile.add(rotatedV);
        }
        return rotatedProfile;
    }
}

