/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.mobile_platform.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.vecmath.GVector;
import org.eclipse.apogy.examples.mobile_platform.Position;
import org.eclipse.apogy.examples.mobile_platform.impl.MobilePlatformSimulatedImpl;
import org.eclipse.apogy.examples.mobile_platform.impl.MobilePlatformSimulatedMoveJob;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobilePlatformSimulatedCustomImpl
extends MobilePlatformSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(MobilePlatformSimulatedImpl.class);
    private static final String DEGREE_SYM = "\u00b0";
    protected static final double WHEEL_RADIUS = 0.25;
    protected static final double WHEEL_TRACK = 0.64;
    protected static final int MOVE_WAIT_PERIOD = 100;
    protected static final double MOVE_TO_MIN_LIN_SPEED = 1.5;
    protected static final double ERROR_PER_METER = 0.05;
    private Job moveJob = null;
    final Lock lock = new ReentrantLock();
    boolean doingMoveTo = false;

    protected MobilePlatformSimulatedCustomImpl() {
    }

    @Override
    public boolean init() {
        Logger.info("Mobile platform initialization started.");
        if (this.isDisposed()) {
            Logger.warn("Rejected: The mobile plateform is not properly initialized.");
            return false;
        }
        this.moveJob = new MobilePlatformSimulatedMoveJob(this, "Mobile Platform Move Job");
        this.moveJob.schedule();
        this.setInitialized(true);
        Logger.info("Mobile platform initialization complete.");
        return true;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            Logger.warn("Ignored: The mobile platform has already been disposed.");
        } else {
            if (this.moveJob != null) {
                this.moveJob.cancel();
            }
            this.setDisposed(true);
            Logger.info("Mobile platform has been successfully disposed.");
        }
    }

    @Override
    public void clearPositionError() {
        if (this.isDisposed()) {
            throw new RuntimeException("Rejected: the mobile platform has already been disposed.");
        }
        if (!this.isInitialized()) {
            throw new RuntimeException("Rejected: The mobile platform is not initialized.");
        }
        Logger.info("The mobile platform's position error has been cleared.");
        this.lock.lock();
        this.setPositionError(0.0);
        this.lock.unlock();
    }

    @Override
    public void stop() {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".stop(): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform is not " + "initialized (with init()).";
            throw new RuntimeException(message);
        }
        Logger.info("The mobile platform is stopping.");
        this.lock.lock();
        this.setAngularVelocity(0.0);
        this.setLinearVelocity(0.0);
        this.lock.unlock();
    }

    @Override
    public void moveTo(double x, double y) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The mobile platform is not properly initialized.");
        }
        this.lock.lock();
        if (this.doingMoveTo) {
            this.lock.unlock();
            throw new RuntimeException("Ignored: The mobile platform is currently in the midst of another moveTo() operation.");
        }
        this.doingMoveTo = true;
        GVector initialLocation = new GVector(new double[]{this.getPosition().getX(), this.getPosition().getY()});
        double currentSpeed = this.getLinearVelocity();
        this.lock.unlock();
        Logger.info("Mobile platform move started.");
        GVector finalLocation = new GVector(new double[]{x, y});
        this.move(initialLocation, finalLocation, currentSpeed);
        this.lock.lock();
        this.doingMoveTo = false;
        this.lock.unlock();
        Logger.info("Mobile platform move completed.");
    }

    @Override
    public void cmdLinearVelocity(double linearVelocity) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".cmdLinearVelocity(" + linearVelocity + "): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform is not " + "initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.setLinearVelocity(linearVelocity);
    }

    @Override
    public void cmdAngularVelocity(double angularVelocity) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".cmdAngularVelocity(" + Math.toDegrees(angularVelocity) + "(" + DEGREE_SYM + "/s)): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform is not " + "initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.setAngularVelocity(angularVelocity);
    }

    @Override
    public void cmdVelocities(double linearVelocity, double angularVelocity) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".cmdVelocities(" + linearVelocity + ", " + Math.toDegrees(angularVelocity) + "(" + DEGREE_SYM + "/s)): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform is not " + "initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.setLinearVelocity(linearVelocity);
        this.setAngularVelocity(angularVelocity);
    }

    @Override
    public void resetPosition(Position position) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".resetPosition(Position(X=" + position.getX() + ", Y=" + position.getY() + ", Theta=" + Math.toDegrees(position.getTheta()) + DEGREE_SYM + ")): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform is not " + "initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.lock.lock();
        if (this.doingMoveTo) {
            this.lock.unlock();
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the mobile platform is currently " + "in the midst of a moveTo() operation.";
            throw new RuntimeException(message);
        }
        this.setPosition(position);
        this.setPositionError(0.0);
        this.lock.unlock();
        Logger.info("The mobile platform's position has been changed accordingly and its position error has been reset.");
    }

    private void move(GVector initialLocation, GVector finalLocation, double speed) {
        GVector interpolatedLocation = new GVector(initialLocation);
        double currSpeed = MobilePlatformSimulatedCustomImpl.calculateMoveToSpeed(speed);
        double t = 0.0;
        double deltaT = MobilePlatformSimulatedCustomImpl.computeMoveDeltaTime(initialLocation, finalLocation, t, currSpeed);
        while (t <= 1.0) {
            this.lock.lock();
            if (currSpeed != MobilePlatformSimulatedCustomImpl.calculateMoveToSpeed(this.getLinearVelocity())) {
                currSpeed = MobilePlatformSimulatedCustomImpl.calculateMoveToSpeed(this.getLinearVelocity());
                deltaT = MobilePlatformSimulatedCustomImpl.computeMoveDeltaTime(initialLocation, finalLocation, t, currSpeed);
            }
            interpolatedLocation.interpolate(initialLocation, finalLocation, t);
            this.getPosition().setX(interpolatedLocation.getElement(0));
            this.getPosition().setY(interpolatedLocation.getElement(1));
            this.lock.unlock();
            t += deltaT;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static double computeMoveDeltaTime(GVector initialLocation, GVector finalLocation, double currT, double speed) {
        double euclideanDist = 0.0;
        int i = 0;
        while (i < initialLocation.getSize()) {
            euclideanDist += Math.pow(finalLocation.getElement(i) - initialLocation.getElement(i), 2.0);
            ++i;
        }
        euclideanDist = Math.sqrt(euclideanDist);
        double remainingDist = Math.abs(1.0 - currT) * euclideanDist;
        double travelTime = remainingDist / speed;
        double deltaTime = 0.1 / travelTime;
        return deltaTime;
    }

    private static double calculateMoveToSpeed(double currentSpeed) {
        return Math.max(Math.abs(currentSpeed), 1.5);
    }
}

