/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ui.Activator;
import org.eclipse.apogy.common.geometry.data3d.ui.jme3.Data3dJME3Utilities;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.CartesianTriangularMeshSceneObject;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshJM3SceneObject
extends DefaultJME3SceneObject<ContentNode<CartesianTriangularMesh>>
implements CartesianTriangularMeshSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshJM3SceneObject.class);
    private boolean useShading = true;
    private ColorRGBA meshColor = this.getDefaultMeshColor();
    private RGBA rgb;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.SURFACE;
    private Adapter contentAdapter = null;
    private Adapter pointsAdapter = null;
    private Adapter polygonsAdapter = null;
    private Point3d centroid = null;
    private CartesianTriangularMesh mesh = null;
    private AssetManager assetManager;
    private Geometry meshGeometry = null;
    private Mesh jme3mMesh = null;

    public CartesianTriangularMeshJM3SceneObject(ContentNode<CartesianTriangularMesh> meshContentNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(meshContentNode, jme3RenderEngineDelegate);
        if (meshContentNode == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.mesh = (CartesianTriangularMesh)meshContentNode.getContent();
        Job job = new Job("CartesianTriangularMeshJM3SceneObject : Updating Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                CartesianTriangularMesh meshCopy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangularMesh(CartesianTriangularMeshJM3SceneObject.this.mesh);
                final Mesh newMesh = Data3dJME3Utilities.createMesh(meshCopy, true, CartesianTriangularMeshJM3SceneObject.this.meshColor);
                CartesianTriangularMeshJM3SceneObject.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        CartesianTriangularMeshJM3SceneObject.this.updateGeometryInternal(newMesh);
                        CartesianTriangularMeshJM3SceneObject.this.setPresentationMode(CartesianTriangularMeshJM3SceneObject.this.meshPresentationMode);
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        meshContentNode.eAdapters().add((Object)this.getContentAdapter());
        this.mesh = (CartesianTriangularMesh)meshContentNode.getContent();
        this.mesh.eAdapters().add((Object)this.getPointsAdapter());
        this.mesh.eAdapters().add((Object)this.getPolygonsAdapter());
    }

    public void updateGeometry(float tpf) {
        Mesh newMesh = Data3dJME3Utilities.createMesh(this.mesh, true, this.meshColor);
        this.updateGeometryInternal(newMesh);
    }

    public Point3d getCentroid() {
        if (this.centroid == null) {
            this.centroid = new Point3d(0.0, 0.0, 0.0);
            if (this.mesh != null && this.mesh.getPoints().size() > 0) {
                for (CartesianPositionCoordinates point : this.mesh.getPoints()) {
                    this.centroid.x += point.getX();
                    this.centroid.y += point.getY();
                    this.centroid.z += point.getZ();
                }
                this.centroid.scale(1.0 / (double)this.mesh.getPoints().size());
            }
        }
        return this.centroid;
    }

    public void setColor(RGBA rgb) {
        Logger.info("Setting color to <" + rgb + ">.");
        this.rgb = rgb;
        this.meshColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (CartesianTriangularMeshJM3SceneObject.this.meshGeometry != null) {
                    Mesh newMesh = Data3dJME3Utilities.createMesh(CartesianTriangularMeshJM3SceneObject.this.mesh, true, CartesianTriangularMeshJM3SceneObject.this.meshColor);
                    CartesianTriangularMeshJM3SceneObject.this.updateGeometryInternal(newMesh);
                    Material mat = CartesianTriangularMeshJM3SceneObject.this.createMaterial();
                    if (CartesianTriangularMeshJM3SceneObject.this.useShading) {
                        mat.setColor("Diffuse", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Ambient", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Specular", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                    } else {
                        mat.setColor("Color", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                    }
                    CartesianTriangularMeshJM3SceneObject.this.meshGeometry.setMaterial(mat);
                }
                return null;
            }
        });
    }

    public RGBA getColor() {
        return this.rgb;
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.meshGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((ContentNode)this.getTopologyNode()).eAdapters().remove((Object)this.getContentAdapter());
        }
        if (this.mesh != null) {
            this.mesh.eAdapters().remove((Object)this.getPointsAdapter());
            this.mesh.eAdapters().remove((Object)this.getPolygonsAdapter());
        }
        this.assetManager = null;
        this.centroid = null;
        this.mesh = null;
        this.pointsAdapter = null;
        this.contentAdapter = null;
        super.dispose();
    }

    public void setPresentationMode(MeshPresentationMode mode) {
        Logger.info("Setting presentation mode to " + mode);
        this.meshPresentationMode = mode;
        if (this.meshGeometry != null && this.meshGeometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    switch (CartesianTriangularMeshJM3SceneObject.this.meshPresentationMode.getValue()) {
                        case 1: {
                            CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 2: {
                            CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                            if (CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 0: {
                            CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            CartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Points);
                            break;
                        }
                    }
                    return null;
                }
            });
        } else {
            Logger.warn("Failed to set presentation mode to " + mode);
        }
    }

    public void setPointSize(final int pointSize) {
        Logger.info("Setting point size to " + pointSize);
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CartesianTriangularMeshJM3SceneObject.this.jme3mMesh.setPointSize((float)pointSize);
                    return null;
                }
            });
        }
    }

    public void setUseShading(final boolean useShading) {
        Logger.info("Setting use shading to " + useShading);
        this.useShading = useShading;
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Material mat = CartesianTriangularMeshJM3SceneObject.this.createMaterial();
                    if (useShading) {
                        mat.setColor("Diffuse", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Ambient", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Specular", CartesianTriangularMeshJM3SceneObject.this.meshColor);
                    }
                    CartesianTriangularMeshJM3SceneObject.this.meshGeometry.setMaterial(mat);
                    return null;
                }
            });
        }
    }

    private void updateGeometryInternal(Mesh newMesh) {
        try {
            if (!this.busy && this.getTopologyNode() != null) {
                this.busy = true;
                this.centroid = null;
                if (this.meshGeometry != null) {
                    this.getAttachmentNode().detachChild((Spatial)this.meshGeometry);
                }
                this.jme3mMesh = newMesh;
                if (this.jme3mMesh != null) {
                    this.meshGeometry = ((ContentNode)this.getTopologyNode()).getNodeId() != null ? new Geometry(((ContentNode)this.getTopologyNode()).getNodeId(), this.jme3mMesh) : new Geometry("CartesianTriangularMesh", this.jme3mMesh);
                    this.meshGeometry.setUserData("ProjectImage", (Object)true);
                    this.meshGeometry.setMaterial(this.createMaterial());
                    this.meshGeometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    this.getAttachmentNode().attachChild((Spatial)this.meshGeometry);
                }
                this.busy = false;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Material createMaterial() {
        Material mat = null;
        if (this.useShading) {
            mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
            if (this.meshColor != null) {
                mat.setColor("Diffuse", this.meshColor);
                mat.setColor("Ambient", this.meshColor);
                mat.setColor("Specular", this.meshColor);
            }
            mat.setFloat("Shininess", 64.0f);
            mat.setBoolean("UseMaterialColors", true);
        } else {
            mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            if (this.meshColor != null) {
                mat.setColor("Color", this.meshColor);
            }
            mat.setBoolean("VertexColor", true);
        }
        return mat;
    }

    private ColorRGBA getDefaultMeshColor() {
        ColorRGBA rgba = null;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_TRIANGULAR_MESH_COLOR_ID");
        rgba = rgb != null ? JME3Utilities.convertToColorRGBA((RGB)rgb) : new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
        return rgba;
    }

    private Adapter getPointsAdapter() {
        if (this.pointsAdapter == null) {
            this.pointsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(CartesianTriangularMesh.class);
                    if (featureId == 0) {
                        if (msg.getEventType() == 5 || msg.getEventType() == 6) {
                            CartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        } else if (msg.getEventType() == 3 || msg.getEventType() == 4) {
                            CartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        }
                    }
                }
            };
        }
        return this.pointsAdapter;
    }

    private Adapter getPolygonsAdapter() {
        if (this.polygonsAdapter == null) {
            this.polygonsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(CartesianTriangularMesh.class);
                    if (featureId == 2) {
                        if (msg.getEventType() == 5 || msg.getEventType() == 6) {
                            CartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        } else if (msg.getEventType() == 3 || msg.getEventType() == 4) {
                            CartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        }
                    }
                }
            };
        }
        return this.polygonsAdapter;
    }

    private Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(ContentNode.class);
                    if (featureId == 4) {
                        try {
                            CartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().remove((Object)CartesianTriangularMeshJM3SceneObject.this.getPointsAdapter());
                            CartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().remove((Object)CartesianTriangularMeshJM3SceneObject.this.getPolygonsAdapter());
                            CartesianTriangularMeshJM3SceneObject.this.mesh = (CartesianTriangularMesh)msg.getNewValue();
                            if (CartesianTriangularMeshJM3SceneObject.this.mesh != null) {
                                CartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().add((Object)CartesianTriangularMeshJM3SceneObject.this.getPointsAdapter());
                                CartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().add((Object)CartesianTriangularMeshJM3SceneObject.this.getPolygonsAdapter());
                                if (!CartesianTriangularMeshJM3SceneObject.this.busy) {
                                    CartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                                } else {
                                    Logger.warn("CartesianTriangularMeshJM3SceneObject busy.");
                                }
                            } else {
                                Logger.error("The mesh is null.");
                            }
                        }
                        catch (Exception e) {
                            Logger.error("Failed to update content of CartesianTriangularMesh.", (Throwable)e);
                        }
                    }
                }
            };
        }
        return this.contentAdapter;
    }
}

