/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityPassSpacecraftPositionHistoryFileExporter
implements IFileExporter {
    private static final Logger Logger = LoggerFactory.getLogger(VisibilityPassSpacecraftPositionHistoryFileExporter.class);
    public static final String CSV_FILE_EXTENSION = "csv";

    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return VisibilityPassSpacecraftPositionHistory.class;
    }

    public boolean canConvert(Object input) {
        return input instanceof VisibilityPassSpacecraftPositionHistory;
    }

    public Object convert(Object input) throws Exception {
        VisibilityPassSpacecraftPositionHistory visibilityPassSpacecraftPositionHistory = (VisibilityPassSpacecraftPositionHistory)input;
        String tmpFolder = String.valueOf(System.getProperty("user.home")) + File.separator + System.getProperty("java.io.tmpdir");
        Date now = new Date();
        String fileName = null;
        try {
            fileName = String.valueOf(tmpFolder) + File.separator + now.getTime();
            String data = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.exportAsCSV(visibilityPassSpacecraftPositionHistory, true);
            File file = File.createTempFile(fileName, ".csv");
            FileWriter writer = new FileWriter(file.getAbsoluteFile());
            writer.write(data);
            writer.close();
            return file;
        }
        catch (Exception e) {
            File toDelete = new File(fileName);
            toDelete.delete();
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        VisibilityPassSpacecraftPositionHistory visibilityPassSpacecraftPositionHistory = (VisibilityPassSpacecraftPositionHistory)input;
        for (String extension : extensions) {
            if (!extension.equalsIgnoreCase(CSV_FILE_EXTENSION)) continue;
            this.saveToFile(filePath, visibilityPassSpacecraftPositionHistory);
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(CSV_FILE_EXTENSION);
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains(CSV_FILE_EXTENSION)) {
            return "The Visibility Pass Spacecraft Position History to a Comma Separated Values (CSV) format.";
        }
        return null;
    }

    private void saveToFile(String filePath, VisibilityPassSpacecraftPositionHistory visibilityPassSpacecraftPositionHistory) throws Exception {
        String data = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.exportAsCSV(visibilityPassSpacecraftPositionHistory, true);
        FileOutputStream rwChannel = new FileOutputStream(String.valueOf(filePath) + "." + CSV_FILE_EXTENSION, true);
        ByteBuffer bb = ByteBuffer.wrap(data.getBytes("UTF-8"));
        rwChannel.write(bb.array());
        rwChannel.flush();
        rwChannel.close();
    }
}

