/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.eclipse.apogy.addons.monitoring.ValueSource;
import org.eclipse.apogy.addons.monitoring.ui.TimeValueSeries;
import org.eclipse.apogy.addons.monitoring.ui.composites.ValueVsTimeWithRangesBIRTChartComposite;
import org.eclipse.apogy.addons.monitoring.ui.impl.NumberTimePlotImpl;
import org.eclipse.apogy.common.ui.birt.composites.ValueVsTimeBIRTChartComposite;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.widgets.Composite;

public class NumberTimePlotCustomImpl
extends NumberTimePlotImpl {
    protected TimeValueSeries rawYValues = new TimeValueSeries();
    protected Unit<?> nativeUnits = null;
    protected Unit<?> displayUnits = null;

    @Override
    public void initialise(Composite parent, int style) {
        super.initialise(parent, style);
        if (this.rawYValues.size() == 0) {
            Date date = this.timeValueSeries.getTimes().get(0);
            this.rawYValues.addTimeValue(date, 0.0);
        }
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(this.getDisplayedyAxisString(this.getYAxisName(), this.isDisplayYAxisUnits()));
        }
        this.updateRangesLimits();
    }

    @Override
    public void setValueSource(ValueSource<Number> newValueSource) {
        this.nativeUnits = null;
        this.displayUnits = null;
        super.setValueSource(newValueSource);
        if (newValueSource != null) {
            this.nativeUnits = newValueSource.getNativeUnit();
            this.displayUnits = newValueSource.getDisplayUnit();
        }
        this.nativeUnitsChanged(this.nativeUnits);
        this.displayUnitsChanged(this.displayUnits);
        this.updateRangesLimits();
    }

    @Override
    public void setYAxisName(String newYAxisName) {
        super.setYAxisName(newYAxisName);
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(this.getDisplayedyAxisString(newYAxisName, this.isDisplayYAxisUnits()));
        }
    }

    @Override
    public void setDisplayYAxisUnits(boolean newDisplayYAxisUnits) {
        super.setDisplayYAxisUnits(newDisplayYAxisUnits);
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(this.getDisplayedyAxisString(this.getYAxisName(), newDisplayYAxisUnits));
        }
    }

    @Override
    public void setShowRanges(boolean newShowRanges) {
        super.setShowRanges(newShowRanges);
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.getValueVsTimeWithRangesBIRTChartComposite().showRanges(newShowRanges);
        }
    }

    @Override
    protected ValueVsTimeBIRTChartComposite createChartComposite(Composite parent, int style) {
        return new ValueVsTimeWithRangesBIRTChartComposite(parent, style){

            protected SortedMap<CDateTime, Double> manageHistorySize(SortedMap<CDateTime, Double> currentDataSeries) {
                SortedMap<CDateTime, Double> result = null;
                switch (NumberTimePlotCustomImpl.this.getHistorySizeManagementPolicy().getValue()) {
                    case 0: {
                        result = super.manageHistorySize(currentDataSeries);
                        break;
                    }
                    case 1: {
                        if (NumberTimePlotCustomImpl.this.getMaximumHistorySize() > 0 && currentDataSeries.size() > NumberTimePlotCustomImpl.this.getMaximumHistorySize()) {
                            result = new TreeMap<CDateTime, Double>();
                            Iterator<CDateTime> it = currentDataSeries.keySet().iterator();
                            boolean sample = true;
                            while (it.hasNext()) {
                                CDateTime time = it.next();
                                if (sample) {
                                    result.put(time, (Double)currentDataSeries.get(time));
                                }
                                boolean bl = sample = !sample;
                            }
                            break;
                        }
                        result = currentDataSeries;
                        break;
                    }
                    default: {
                        result = super.manageHistorySize(currentDataSeries);
                    }
                }
                return result;
            }
        };
    }

    @Override
    protected void addData(Date date, double value) {
        int entriesToRemove;
        this.rawYValues.addTimeValue(date, value);
        double convertedValue = 0.0;
        convertedValue = this.displayUnits != null && this.nativeUnits != null ? this.nativeUnits.getConverterTo(this.displayUnits).convert(value) : value;
        this.timeValueSeries.addTimeValue(date, convertedValue);
        if (this.getMaximumHistoryTimeLength() > 0.0f) {
            while (this.getHistoryTimeSpan() > this.getMaximumHistoryTimeLength()) {
                this.timeValueSeries.removeOldestEntry(1);
                this.rawYValues.removeOldestEntry(1);
            }
        }
        if (this.getMaximumHistorySize() > 0 && (entriesToRemove = this.timeValueSeries.size() - this.getMaximumHistorySize()) > 0) {
            this.timeValueSeries.removeOldestEntry(entriesToRemove);
            this.rawYValues.removeOldestEntry(entriesToRemove);
        }
    }

    protected void nativeUnitsChanged(Unit<?> newNativeUnits) {
        this.nativeUnits = newNativeUnits;
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(this.getDisplayedyAxisString(this.getYAxisName(), this.isDisplayYAxisUnits()));
        }
        this.convertToDisplayUnits();
        this.updateChart();
    }

    protected void displayUnitsChanged(Unit<?> newDisplayUnits) {
        this.displayUnits = newDisplayUnits;
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(this.getDisplayedyAxisString(this.getYAxisName(), this.isDisplayYAxisUnits()));
        }
        this.convertToDisplayUnits();
        this.updateChart();
    }

    protected String getDisplayedyAxisString(String yAxisName, boolean displayYAxisUnits) {
        String displayedName = yAxisName;
        if (displayedName == null) {
            displayedName = "";
        }
        if (displayYAxisUnits) {
            if (this.displayUnits != null) {
                displayedName = String.valueOf(displayedName) + " (" + this.displayUnits.toString() + ")";
            } else if (this.nativeUnits != null) {
                displayedName = String.valueOf(displayedName) + " (" + this.nativeUnits.toString() + ")";
            }
        }
        return displayedName;
    }

    protected void convertToDisplayUnits() {
        if (this.displayUnits != null && this.nativeUnits != null) {
            try {
                UnitConverter converter = this.nativeUnits.getConverterTo(this.displayUnits);
                List<Date> dates = this.timeValueSeries.getTimes();
                for (Date date : dates) {
                    this.timeValueSeries.replace(date, converter.convert(this.rawYValues.getValue(date)));
                }
                return;
            }
            catch (Exception exception) {}
        }
        List<Date> dates = this.timeValueSeries.getTimes();
        for (Date date : dates) {
            this.timeValueSeries.replace(date, this.rawYValues.getValue(date));
        }
    }

    @Override
    protected Adapter getValueSourceAdapter() {
        if (this.valueSourceAdapter == null) {
            this.valueSourceAdapter = new AdapterImpl(){
                private Date previousDataDate;
                private Object previousValue;

                public void notifyChanged(Notification msg) {
                    long now = System.currentTimeMillis();
                    int featureID = msg.getFeatureID(ValueSource.class);
                    switch (featureID) {
                        case 2: {
                            if (NumberTimePlotCustomImpl.this.getMinimumTimeBetweenSample() > 0.0f && (double)(now - NumberTimePlotCustomImpl.this.lastSampleTime) * 0.001 < (double)NumberTimePlotCustomImpl.this.getMinimumTimeBetweenSample()) {
                                return;
                            }
                            NumberTimePlotCustomImpl.this.lastSampleTime = now;
                            Date newValueDate = new Date(now);
                            Object newValue = msg.getNewValue();
                            NumberTimePlotCustomImpl.this.processNewData(this.previousDataDate, this.previousValue, newValueDate, newValue);
                            this.previousDataDate = newValueDate;
                            this.previousValue = newValue;
                            break;
                        }
                        case 5: {
                            if (NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite == null || NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite.isDisposed()) break;
                            NumberTimePlotCustomImpl.this.getValueVsTimeWithRangesBIRTChartComposite().setOutOfRangeMinValue(msg.getNewDoubleValue());
                            break;
                        }
                        case 6: {
                            if (NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite != null && !NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite.isDisposed()) {
                                NumberTimePlotCustomImpl.this.getValueVsTimeWithRangesBIRTChartComposite().setOutOfRangeMaxValue(msg.getNewDoubleValue());
                            }
                        }
                        case 7: {
                            if (NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite == null || NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite.isDisposed()) break;
                            NumberTimePlotCustomImpl.this.getValueVsTimeWithRangesBIRTChartComposite().setAlarmRangeMinValue(msg.getNewDoubleValue());
                            break;
                        }
                        case 8: {
                            if (NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite == null || NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite.isDisposed()) break;
                            NumberTimePlotCustomImpl.this.getValueVsTimeWithRangesBIRTChartComposite().setAlarmRangeMaxValue(msg.getNewDoubleValue());
                            break;
                        }
                        case 9: {
                            if (NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite == null || NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite.isDisposed()) break;
                            NumberTimePlotCustomImpl.this.getValueVsTimeWithRangesBIRTChartComposite().setWarningRangeMinValue(msg.getNewDoubleValue());
                            break;
                        }
                        case 10: {
                            if (NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite == null || NumberTimePlotCustomImpl.this.valueVsTimeBIRTChartComposite.isDisposed()) break;
                            NumberTimePlotCustomImpl.this.getValueVsTimeWithRangesBIRTChartComposite().setWarningRangeMaxValue(msg.getNewDoubleValue());
                            break;
                        }
                        case 3: {
                            NumberTimePlotCustomImpl.this.nativeUnitsChanged((Unit)msg.getNewValue());
                            break;
                        }
                        case 4: {
                            NumberTimePlotCustomImpl.this.displayUnitsChanged((Unit)msg.getNewValue());
                            break;
                        }
                    }
                }
            };
        }
        return this.valueSourceAdapter;
    }

    protected ValueVsTimeWithRangesBIRTChartComposite getValueVsTimeWithRangesBIRTChartComposite() {
        return (ValueVsTimeWithRangesBIRTChartComposite)this.valueVsTimeBIRTChartComposite;
    }

    protected void updateRangesLimits() {
        if (this.getValueSource() != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            if (this.getValueSource().isSetOutOfRangeMinLimit()) {
                this.getValueVsTimeWithRangesBIRTChartComposite().setOutOfRangeMinValue(this.getValueSource().getOutOfRangeMinLimit());
            } else {
                this.getValueVsTimeWithRangesBIRTChartComposite().setOutOfRangeMinValue(Double.NEGATIVE_INFINITY);
            }
            if (this.getValueSource().isSetOutOfRangeMaxLimit()) {
                this.getValueVsTimeWithRangesBIRTChartComposite().setOutOfRangeMaxValue(this.getValueSource().getOutOfRangeMaxLimit());
            } else {
                this.getValueVsTimeWithRangesBIRTChartComposite().setOutOfRangeMaxValue(Double.POSITIVE_INFINITY);
            }
            if (this.getValueSource().isSetAlarmRangeMinLimit()) {
                this.getValueVsTimeWithRangesBIRTChartComposite().setAlarmRangeMinValue(this.getValueSource().getAlarmRangeMinLimit());
            } else {
                this.getValueVsTimeWithRangesBIRTChartComposite().setAlarmRangeMinValue(Double.NEGATIVE_INFINITY);
            }
            if (this.getValueSource().isSetAlarmRangeMaxLimit()) {
                this.getValueVsTimeWithRangesBIRTChartComposite().setAlarmRangeMaxValue(this.getValueSource().getAlarmRangeMaxLimit());
            } else {
                this.getValueVsTimeWithRangesBIRTChartComposite().setAlarmRangeMaxValue(Double.POSITIVE_INFINITY);
            }
            if (this.getValueSource().isSetWarningRangeMinLimit()) {
                this.getValueVsTimeWithRangesBIRTChartComposite().setWarningRangeMinValue(this.getValueSource().getWarningRangeMinLimit());
            } else {
                this.getValueVsTimeWithRangesBIRTChartComposite().setWarningRangeMinValue(Double.NEGATIVE_INFINITY);
            }
            if (this.getValueSource().isSetWarningRangeMaxLimit()) {
                this.getValueVsTimeWithRangesBIRTChartComposite().setWarningRangeMaxValue(this.getValueSource().getWarningRangeMaxLimit());
            } else {
                this.getValueVsTimeWithRangesBIRTChartComposite().setWarningRangeMaxValue(Double.POSITIVE_INFINITY);
            }
        }
    }
}

