/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TimeValueSeries {
    private Map<Date, Double> timeToValueMap = new HashMap<Date, Double>();

    public void addTimeValue(Date time, double value) {
        this.timeToValueMap.put(time, value);
    }

    public void clear() {
        this.timeToValueMap.clear();
    }

    public void removeOldestEntry(int numberOfEntriesToRemove) {
        if (!this.timeToValueMap.isEmpty()) {
            Iterator<Date> it = this.timeToValueMap.keySet().iterator();
            int removedEntries = 0;
            while (it.hasNext() && removedEntries < numberOfEntriesToRemove) {
                this.timeToValueMap.remove(it.next());
                ++removedEntries;
            }
        }
    }

    public int size() {
        return this.timeToValueMap.size();
    }

    public double getValue(Date time) {
        if (this.timeToValueMap.containsKey(time)) {
            return this.timeToValueMap.get(time);
        }
        return Double.NaN;
    }

    public boolean replace(Date time, double value) {
        if (this.timeToValueMap.containsKey(time)) {
            this.timeToValueMap.replace(time, value);
            return true;
        }
        return false;
    }

    public List<Date> getTimes() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Iterator<Date> it = this.timeToValueMap.keySet().iterator();
        while (it.hasNext()) {
            dates.add(it.next());
        }
        return dates;
    }

    public List<Double> getValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        Iterator<Date> it = this.timeToValueMap.keySet().iterator();
        while (it.hasNext()) {
            values.add(this.timeToValueMap.get(it.next()));
        }
        return values;
    }
}

