/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import java.util.List;
import org.eclipse.apogy.addons.monitoring.ui.ApogyAddonsMonitoringUIFacade;
import org.eclipse.apogy.addons.monitoring.ui.ApogyAddonsMonitoringUIFactory;
import org.eclipse.apogy.addons.monitoring.ui.ApogyAddonsMonitoringUIPackage;
import org.eclipse.apogy.addons.monitoring.ui.ValueSourceDisplay;
import org.eclipse.apogy.addons.monitoring.ui.ValueSourceDisplayList;
import org.eclipse.apogy.addons.monitoring.ui.wizards.ValueSourceSelectionWizard;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSourceDisplaysComposite<RootEObject extends EObject, ResolvedEObject extends ValueSourceDisplayList, ItemObject extends ValueSourceDisplay<?>>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    private static final Logger Logger = LoggerFactory.getLogger(ValueSourceDisplaysComposite.class);
    private ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    private Adapter valueSourceDisplayAdapter;
    private Adapter valueSourceDisplayListAdapter;
    private ValueSourceDisplayList previousValueSourceDisplayList;

    public ValueSourceDisplaysComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY_LIST__DISPLAYS, settings);
    }

    public ValueSourceDisplaysComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createShowButton(parent, style);
        this.createHideButton(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createSeparator(parent, style);
        this.createChangeValueSourceButton(parent, style);
    }

    protected void doShow() {
        for (ValueSourceDisplay display : this.getSelectedItemObjects()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)display, (EStructuralFeature)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY__VISIBLE, (Object)true, true);
        }
    }

    protected void doHide() {
        for (ValueSourceDisplay display : this.getSelectedItemObjects()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)display, (EStructuralFeature)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY__VISIBLE, (Object)false, true);
        }
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ValueSourceDisplay) {
                    ValueSourceDisplay valueSource = (ValueSourceDisplay)element;
                    return valueSource.getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                if (element instanceof ValueSourceDisplay) {
                    ValueSourceDisplay valueSource = (ValueSourceDisplay)element;
                    return valueSource.getDescription();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof ValueSourceDisplay) {
                    ValueSourceDisplay valueSource = (ValueSourceDisplay)element;
                    return ValueSourceDisplaysComposite.this.labelProvider.getImage((Object)valueSource);
                }
                return null;
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        TreeViewerColumn visibleColumn = new TreeViewerColumn(viewer, 0);
        visibleColumn.getColumn().setText("Visibe");
        visibleColumn.getColumn().setAlignment(0x1000000);
        visibleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ValueSourceDisplay) {
                    ValueSourceDisplay valueSourceDisplay = (ValueSourceDisplay)element;
                    return Boolean.toString(valueSourceDisplay.isVisible());
                }
                return "?";
            }
        });
        visibleColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)60);
        TreeViewerColumn valueSourceColumn = new TreeViewerColumn(viewer, 0);
        valueSourceColumn.getColumn().setText("Value Source");
        valueSourceColumn.getColumn().setAlignment(0x1000000);
        valueSourceColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ValueSourceDisplay valueSourceDisplay;
                if (element instanceof ValueSourceDisplay && (valueSourceDisplay = (ValueSourceDisplay)element).getValueSource() != null) {
                    return valueSourceDisplay.getValueSource().getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                ValueSourceDisplay valueSourceDisplay;
                if (element instanceof ValueSourceDisplay && (valueSourceDisplay = (ValueSourceDisplay)element).getValueSource() != null) {
                    return valueSourceDisplay.getValueSource().getDescription();
                }
                return "";
            }

            public Image getImage(Object element) {
                ValueSourceDisplay valueSourceDisplay;
                if (element instanceof ValueSourceDisplay && (valueSourceDisplay = (ValueSourceDisplay)element).getValueSource() != null) {
                    return ValueSourceDisplaysComposite.this.labelProvider.getImage(valueSourceDisplay.getValueSource());
                }
                return null;
            }
        });
        valueSourceColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
    }

    protected Button createEditConditionButton(Composite parent, int style) {
        Button button = ValueSourceDisplaysComposite.createButton((Composite)parent, (int)0, (String)"Edit Value Source", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doEditCondition((ValueSourceDisplay)this.getViewer().getStructuredSelection().getFirstElement());
            this.refreshViewer();
        }));
        this.createEditConditionButtonBindings(button);
        return button;
    }

    protected void createEditConditionButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doEditCondition(ValueSourceDisplay<?> display) {
        EObjectWizard wizard = new EObjectWizard(display, null, ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY_LIST__DISPLAYS, ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        this.refreshViewer();
    }

    protected void doNew() {
        ValueSourceDisplayList valueSourceDisplayList = ApogyAddonsMonitoringUIFacade.INSTANCE.getValueSourceDisplayList();
        if (valueSourceDisplayList == null) {
            valueSourceDisplayList = ApogyAddonsMonitoringUIFactory.eINSTANCE.createValueSourceDisplayList();
            InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)invocatorSession.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)valueSourceDisplayList, true);
            this.refreshViewer();
        }
        AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
        settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)valueSourceDisplayList, null, (ETypedElement)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY_LIST__DISPLAYS));
        EObjectWizard wizard = new EObjectWizard((EObject)valueSourceDisplayList, null, ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY_LIST__DISPLAYS, ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        if (wizard.getCreatedEObject() instanceof ValueSourceDisplay) {
            ValueSourceDisplay display = (ValueSourceDisplay)wizard.getCreatedEObject();
            display.getValueSource().initialise();
            this.refreshViewer();
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)display), true);
        }
        this.refreshViewer();
    }

    protected void doDelete(ValueSourceDisplay display) {
        try {
            try {
                display.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ValueSourceDisplayList displayList = ApogyAddonsMonitoringUIFacade.INSTANCE.getValueSourceDisplayList();
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)displayList, (EStructuralFeature)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY_LIST__DISPLAYS, (Object)display, true);
            if (this.getViewer().getTree().getItemCount() > 0) {
                Object obj = this.getViewer().getTree().getItem(0).getData();
                this.getViewer().setSelection((ISelection)new StructuredSelection(obj), true);
                this.selectionChanged((IStructuredSelection)new StructuredSelection(obj));
            } else {
                this.selectionChanged((IStructuredSelection)new StructuredSelection());
            }
            this.refreshViewer();
            Logger.info("Deleted display <" + display.getName() + ">.");
        }
        catch (Exception e) {
            Logger.error("Failed to delete display !", (Throwable)e);
        }
    }

    public void setRootEObject(RootEObject rootEObject) {
        super.setRootEObject(rootEObject);
        ValueSourceDisplayList valueSourceDisplayList = null;
        if (this.getResolvedEObject() instanceof ValueSourceDisplayList) {
            valueSourceDisplayList = (ValueSourceDisplayList)this.getResolvedEObject();
        }
        if (rootEObject instanceof ValueSourceDisplayList) {
            valueSourceDisplayList = (ValueSourceDisplayList)rootEObject;
        }
        if (valueSourceDisplayList != this.previousValueSourceDisplayList) {
            if (this.previousValueSourceDisplayList != null) {
                this.previousValueSourceDisplayList.eAdapters().remove((Object)this.getValueSourceDisplayListAdapter());
                for (ValueSourceDisplay display : this.previousValueSourceDisplayList.getDisplays()) {
                    display.eAdapters().remove((Object)this.getValueSourceDisplayAdapter());
                }
            }
            if (valueSourceDisplayList != null) {
                valueSourceDisplayList.eAdapters().add((Object)this.getValueSourceDisplayListAdapter());
                for (ValueSourceDisplay display : valueSourceDisplayList.getDisplays()) {
                    display.eAdapters().add((Object)this.getValueSourceDisplayAdapter());
                }
            }
            this.previousValueSourceDisplayList = valueSourceDisplayList;
        }
    }

    protected Button createChangeValueSourceButton(Composite parent, int style) {
        Button btnChangeValueSource = ValueSourceDisplaysComposite.createButton((Composite)parent, (int)0, (String)"Change Value Source", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.changeValueSource(this.getViewer().getStructuredSelection().toList());
            this.refreshViewer();
        }));
        this.createChangeValueSourceButtonBindings(btnChangeValueSource);
        return btnChangeValueSource;
    }

    protected void createChangeValueSourceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void changeValueSource(List<ItemObject> list) {
        if (list.size() > 0) {
            final ValueSourceDisplay display = (ValueSourceDisplay)list.get(0);
            ValueSourceSelectionWizard wizard = new ValueSourceSelectionWizard((EObject)display, null, (EStructuralFeature)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY__VALUE_SOURCE, null){

                @Override
                public boolean performFinish() {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)display, (EStructuralFeature)ApogyAddonsMonitoringUIPackage.Literals.VALUE_SOURCE_DISPLAY__VALUE_SOURCE, this.getSelectedValueSource());
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
            this.refreshViewer();
        }
    }

    private Adapter getValueSourceDisplayAdapter() {
        if (this.valueSourceDisplayAdapter == null) {
            this.valueSourceDisplayAdapter = new EContentAdapter(){

                public void notifyChanged(final Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof ValueSourceDisplay) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ValueSourceDisplaysComposite.this.isDisposed()) {
                                    ValueSourceDisplaysComposite.this.getViewer().refresh(msg.getNotifier(), true);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.valueSourceDisplayAdapter;
    }

    private Adapter getValueSourceDisplayListAdapter() {
        if (this.valueSourceDisplayListAdapter == null) {
            this.valueSourceDisplayListAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof ValueSourceDisplayList && (featureID = msg.getFeatureID(ValueSourceDisplayList.class)) == 1) {
                        switch (msg.getEventType()) {
                            case 3: {
                                ValueSourceDisplay display = (ValueSourceDisplay)msg.getNewValue();
                                display.eAdapters().add((Object)ValueSourceDisplaysComposite.this.getValueSourceDisplayAdapter());
                                break;
                            }
                            case 5: {
                                List displays = (List)msg.getNewValue();
                                for (ValueSourceDisplay display : displays) {
                                    display.eAdapters().add((Object)ValueSourceDisplaysComposite.this.getValueSourceDisplayAdapter());
                                }
                                break;
                            }
                            case 4: {
                                ValueSourceDisplay display = (ValueSourceDisplay)msg.getOldValue();
                                display.eAdapters().remove((Object)ValueSourceDisplaysComposite.this.getValueSourceDisplayAdapter());
                                break;
                            }
                            case 6: {
                                List displays = (List)msg.getOldValue();
                                for (ValueSourceDisplay display : displays) {
                                    display.eAdapters().remove((Object)ValueSourceDisplaysComposite.this.getValueSourceDisplayAdapter());
                                }
                                break;
                            }
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ValueSourceDisplaysComposite.this.isDisposed()) {
                                    ValueSourceDisplaysComposite.this.getViewer().refresh();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.valueSourceDisplayListAdapter;
    }
}

