/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.wizards;

import java.net.URL;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFactory;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.SoundNotificationEffect;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.AbstractWizardPage;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class SoundNotificationEffectSoundURLWizardPage
extends AbstractWizardPage<SoundNotificationEffect, SoundNotificationEffect, SoundNotificationEffect> {
    public static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.monitoring.ui.wizards.SoundNotificationEffectSoundURLWizardPage";
    private URLSelectionComposite urlSelectionComposite;
    private Button testButton;
    private String urlString = null;

    public SoundNotificationEffectSoundURLWizardPage(String id, SoundNotificationEffect rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(id, (EObject)rootEObject, featurePath, eStructuralFeature);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.urlSelectionComposite = new URLSelectionComposite(top, 0, new String[]{"*.wav"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                SoundNotificationEffectSoundURLWizardPage.this.urlString = newURLString;
                SoundNotificationEffectSoundURLWizardPage.this.validate();
                ApogyCommonTransactionFacade.INSTANCE.basicSet(SoundNotificationEffectSoundURLWizardPage.this.getRootEObject(), (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.SOUND_NOTIFICATION_EFFECT__SOUND_URL, (Object)newURLString, true);
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.testButton = new Button(top, 8);
        this.testButton.setText("Play");
        this.testButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        this.testButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    new URL(SoundNotificationEffectSoundURLWizardPage.this.urlString);
                    SoundNotificationEffect tmpEffect = SoundNotificationEffectSoundURLWizardPage.this.testSound(SoundNotificationEffectSoundURLWizardPage.this.urlString);
                    String message = "Playing sound file <" + SoundNotificationEffectSoundURLWizardPage.this.urlString + "> .";
                    MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Play Sound", null, message, 2, new String[]{"STOP"}, 0);
                    dialog.open();
                    tmpEffect.deactivate();
                }
                catch (Exception exception) {
                    String message = "Failed to play sound file <" + SoundNotificationEffectSoundURLWizardPage.this.urlString + ">!";
                    MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Play Sound", null, message, 1, new String[]{"OK"}, 0);
                    dialog.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.setControl((Control)top);
        this.urlSelectionComposite.setFocus();
    }

    protected SoundNotificationEffect testSound(String soundURL) {
        final SoundNotificationEffect tmpEffect = ApogyAddonsMonitoringFactory.eINSTANCE.createSoundNotificationEffect();
        tmpEffect.setEnabled(true);
        tmpEffect.setSoundURL(soundURL);
        Job playJob = new Job("Test Sound Notification Effect."){

            protected IStatus run(IProgressMonitor arg0) {
                tmpEffect.activate(null, null);
                return Status.OK_STATUS;
            }
        };
        playJob.schedule();
        return tmpEffect;
    }

    protected void validate() {
        boolean urlValid;
        this.setErrorMessage(null);
        boolean bl = urlValid = this.urlString != null && this.urlString.length() > 0;
        if (!urlValid) {
            this.setErrorMessage("Invalid URL specified !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

