/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.composites;

import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.apogy.common.databinding.converters.DateToStringConverter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.ui.databindings.DateToJulianDayStringConverter;
import org.eclipse.apogy.core.environment.earth.surface.ui.databindings.DateToSideralTimeStringConverter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSkyTimeComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSkyTimeComposite.class);
    public static final String JULIAN_DAY_FORMAT_STRING = "0.0000000";
    private EarthSky earthSky = null;
    private Text localTimeValueLabel = null;
    private Text julianDayValueLabel = null;
    private Text sideralTimeValueLabel = null;
    private DataBindingContext m_bindingContext;

    public EarthSkyTimeComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label localLabel = new Label((Composite)this, 0);
        localLabel.setText("Local Time:");
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.widthHint = 225;
        gridData1.minimumWidth = 225;
        gridData1.horizontalAlignment = 16384;
        this.localTimeValueLabel = new Text((Composite)this, 131072);
        this.localTimeValueLabel.setLayoutData((Object)gridData1);
        this.localTimeValueLabel.setText("2250.01.01 HH:MM:ss zzz");
        this.localTimeValueLabel.setEditable(false);
        Label julianDateLabel = new Label((Composite)this, 0);
        julianDateLabel.setText("Julian Day:");
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.minimumWidth = 225;
        gridData2.widthHint = 225;
        gridData2.horizontalAlignment = 16384;
        this.julianDayValueLabel = new Text((Composite)this, 131072);
        this.julianDayValueLabel.setLayoutData((Object)gridData2);
        this.julianDayValueLabel.setText("0000000.00000");
        this.julianDayValueLabel.setEditable(false);
        Label sideralTimeLabel = new Label((Composite)this, 0);
        sideralTimeLabel.setText("Sideral Time:");
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.widthHint = 225;
        gridData3.minimumWidth = 225;
        gridData3.horizontalAlignment = 16384;
        this.sideralTimeValueLabel = new Text((Composite)this, 131072);
        this.sideralTimeValueLabel.setLayoutData((Object)gridData3);
        this.sideralTimeValueLabel.setText("00:00:00");
        this.sideralTimeValueLabel.setEditable(false);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EarthSkyTimeComposite.this.m_bindingContext != null) {
                    EarthSkyTimeComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public EarthSky getEarthSky() {
        return this.earthSky;
    }

    public void setEarthSky(EarthSky earthSky) {
        this.setEarthSky(earthSky, true);
    }

    public void setEarthSky(EarthSky newEarthSky, boolean update) {
        this.earthSky = newEarthSky;
        if (update) {
            if (this.m_bindingContext != null) {
                this.m_bindingContext.dispose();
                this.m_bindingContext = null;
            }
            if (newEarthSky != null) {
                this.m_bindingContext = this.initDataBindings();
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        EarthWorksite worksite = (EarthWorksite)this.getEarthSky().getWorksite();
        if (worksite != null) {
            GeographicCoordinates geographicCoordinates = worksite.getGeographicalCoordinates();
            IObservableValue lbllocalTimeValueLabel = PojoProperties.value((String)"text").observe((Object)this.localTimeValueLabel);
            IObservableValue localTimeObserveValue = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.TIMED__TIME})).observe((Object)this.getEarthSky());
            UpdateValueStrategy localTimeValueStrategy = new UpdateValueStrategy();
            localTimeValueStrategy.setConverter((IConverter)new DateToStringConverter(null){

                public String convert(Date fromObject) {
                    Date date = fromObject;
                    return ApogyCommonEMFFacade.INSTANCE.format(date);
                }
            });
            bindingContext.bindValue(lbllocalTimeValueLabel, localTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), localTimeValueStrategy);
            IObservableValue lbljulianDayValueLabel = PojoProperties.value((String)"text").observe((Object)this.julianDayValueLabel);
            IObservableValue julianDayObserveValue = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.TIMED__TIME})).observe((Object)this.getEarthSky());
            UpdateValueStrategy julianDayValueStrategy = new UpdateValueStrategy();
            julianDayValueStrategy.setConverter((IConverter)new DateToJulianDayStringConverter(new DecimalFormat(JULIAN_DAY_FORMAT_STRING)));
            bindingContext.bindValue(lbljulianDayValueLabel, julianDayObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), julianDayValueStrategy);
            try {
                IObservableValue lblsideralTimeValueLabel = PojoProperties.value((String)"text").observe((Object)this.sideralTimeValueLabel);
                IObservableValue sideralTimeObserveValue = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.TIMED__TIME})).observe((Object)this.getEarthSky());
                UpdateValueStrategy sideralTimeValueStrategy = new UpdateValueStrategy();
                sideralTimeValueStrategy.setConverter((IConverter)new DateToSideralTimeStringConverter(geographicCoordinates.getLongitude()));
                bindingContext.bindValue(lblsideralTimeValueLabel, sideralTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), sideralTimeValueStrategy);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return bindingContext;
    }
}

