/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.impl;

import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.core.environment.earth.surface.AtmosphereUtils;
import org.eclipse.apogy.core.environment.earth.surface.ui.impl.EarthSurfaceUIUtilitiesImpl;
import org.eclipse.swt.graphics.RGBA;

public class EarthSurfaceUIUtilitiesCustomImpl
extends EarthSurfaceUIUtilitiesImpl {
    public static final double LOWER_SUN_ALTITUDE_FOR_TRANSPARENCY = Math.toRadians(-5.0);
    public static final double LOWER_SUN_ALTITUDE_TRANSPARENCY = 1.0;
    public static final double UPPER_SUN_ALTITUDE_FOR_TRANSPARENCY = Math.toRadians(0.0);
    public static final double UPPER_SUN_ALTITUDE_TRANSPARENCY = 0.0;
    public static final Color3f DAY_SKY_COLOR = new Color3f(0.0f, 0.0f, 1.0f);
    public static final Color3f SUNSET_SKY_COLOR = new Color3f(0.7882353f, 0.0f, 1.0f);

    @Override
    public RGBA getSunLightColor(double sunAltitude) {
        RGBA color;
        if (sunAltitude >= 0.0) {
            double colorExtinctionFactor = 1.0 - Math.exp(-sunAltitude / 0.053);
            Vector3d colorVector = new Vector3d(1.0, colorExtinctionFactor, colorExtinctionFactor);
            double sunIntensity = AtmosphereUtils.INSTANCE.getDirectSunIntensity(sunAltitude, 0.0);
            double sunMaximumIntensity = AtmosphereUtils.INSTANCE.getDirectSunIntensity(Math.toRadians(90.0), 0.0);
            float extinction = (float)(sunIntensity / sunMaximumIntensity);
            colorVector.scale((double)extinction);
            int red = (int)Math.round(colorVector.x * 255.0);
            int green = (int)Math.round(colorVector.y * 255.0);
            int blue = (int)Math.round(colorVector.z * 255.0);
            color = new RGBA(red, green, blue, 255);
        } else {
            color = new RGBA(0, 0, 0, 255);
        }
        return color;
    }

    @Override
    public double getSkyTransparency(double sunAltitude) {
        double transparency = 0.0;
        if (sunAltitude < LOWER_SUN_ALTITUDE_FOR_TRANSPARENCY) {
            transparency = 1.0;
        } else if (sunAltitude >= LOWER_SUN_ALTITUDE_FOR_TRANSPARENCY && sunAltitude < UPPER_SUN_ALTITUDE_FOR_TRANSPARENCY) {
            transparency = (sunAltitude - LOWER_SUN_ALTITUDE_FOR_TRANSPARENCY) * 0.0 + (UPPER_SUN_ALTITUDE_FOR_TRANSPARENCY - sunAltitude) * 1.0;
            transparency /= UPPER_SUN_ALTITUDE_FOR_TRANSPARENCY - LOWER_SUN_ALTITUDE_FOR_TRANSPARENCY;
        } else {
            transparency = 0.0;
        }
        return transparency;
    }

    @Override
    public RGBA getSkyColor(double sunAltitude) {
        Color3f color = new Color3f();
        double max = Math.toRadians(10.0);
        double min = Math.toRadians(0.0);
        if (sunAltitude < max) {
            if (sunAltitude > min) {
                float t = (float)((sunAltitude - min) / (max - min));
                color.interpolate((Tuple3f)SUNSET_SKY_COLOR, (Tuple3f)DAY_SKY_COLOR, t);
            } else {
                color = SUNSET_SKY_COLOR;
            }
        } else {
            color = DAY_SKY_COLOR;
        }
        RGBA rgba = new RGBA((float)Math.round((double)color.x * 255.0), (float)Math.round((double)color.y * 255.0), (float)Math.round((double)color.z * 255.0), 255.0f);
        return rgba;
    }
}

