/*
 * Decompiled with CFR 0.152.
 */
package org.ros.address;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.ros.exception.RosRuntimeException;
import org.xbill.DNS.Address;

public class InetAddressFactory {
    private InetAddressFactory() {
    }

    private static boolean isIpv4(InetAddress address) {
        return address.getAddress().length == 4;
    }

    private static Collection<InetAddress> getAllInetAddresses() {
        ArrayList<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            throw new RosRuntimeException(e);
        }
        ArrayList inetAddresses = Lists.newArrayList();
        for (NetworkInterface networkInterface : networkInterfaces) {
            try {
                if (!networkInterface.isUp()) continue;
                inetAddresses.addAll(Collections.list(networkInterface.getInetAddresses()));
            }
            catch (SocketException e) {
                throw new RosRuntimeException(e);
            }
        }
        return inetAddresses;
    }

    private static InetAddress filterInetAddresses(Collection<InetAddress> inetAddresses) {
        for (InetAddress address : inetAddresses) {
            if (address.isLoopbackAddress() || !InetAddressFactory.isIpv4(address)) continue;
            return address;
        }
        throw new RosRuntimeException("No non-loopback interface found.");
    }

    public static InetAddress newNonLoopback() {
        return InetAddressFactory.filterInetAddresses(InetAddressFactory.getAllInetAddresses());
    }

    public static InetAddress newNonLoopbackForNetworkInterface(NetworkInterface networkInterface) {
        return InetAddressFactory.filterInetAddresses(Collections.list(networkInterface.getInetAddresses()));
    }

    private static Collection<InetAddress> getAllInetAddressesByName(String host) {
        InetAddress[] allAddressesByName;
        try {
            allAddressesByName = Address.getAllByName((String)host);
        }
        catch (UnknownHostException unused) {
            try {
                allAddressesByName = InetAddress.getAllByName(host);
            }
            catch (UnknownHostException e) {
                throw new RosRuntimeException(e);
            }
        }
        return Arrays.asList(allAddressesByName);
    }

    public static InetAddress newFromHostString(String host) {
        try {
            if (InetAddresses.isInetAddress((String)host)) {
                return InetAddress.getByAddress(host, InetAddresses.forString((String)host).getAddress());
            }
            if (host.equals("localhost")) {
                return InetAddress.getByAddress("localhost", InetAddresses.forString((String)"127.0.0.1").getAddress());
            }
        }
        catch (UnknownHostException e) {
            throw new RosRuntimeException(e);
        }
        Collection<InetAddress> allAddressesByName = InetAddressFactory.getAllInetAddressesByName(host);
        for (InetAddress address : allAddressesByName) {
            if (address.isLoopbackAddress() || !InetAddressFactory.isIpv4(address)) continue;
            return address;
        }
        for (InetAddress address : allAddressesByName) {
            if (!InetAddressFactory.isIpv4(address)) continue;
            return address;
        }
        throw new RosRuntimeException("Unable to construct InetAddress for host: " + host);
    }

    public static InetAddress newLoopback() {
        return InetAddressFactory.newFromHostString("127.0.0.1");
    }
}

