/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ros.internal.node.RegistrantListener;

public class CountDownRegistrantListener<T>
implements RegistrantListener<T> {
    private final CountDownLatch masterRegistrationSuccessLatch;
    private final CountDownLatch masterRegistrationFailureLatch;
    private final CountDownLatch masterUnregistrationSuccessLatch;
    private final CountDownLatch masterUnregistrationFailureLatch;

    public CountDownRegistrantListener() {
        this(1, 1, 1, 1);
    }

    public CountDownRegistrantListener(int masterRegistrationSuccessCount, int masterRegistrationFailureCount, int masterUnregistrationSuccessCount, int masterUnregistrationFailureCount) {
        this(new CountDownLatch(masterRegistrationSuccessCount), new CountDownLatch(masterRegistrationFailureCount), new CountDownLatch(masterUnregistrationSuccessCount), new CountDownLatch(masterUnregistrationFailureCount));
    }

    public CountDownRegistrantListener(CountDownLatch masterRegistrationSuccessLatch, CountDownLatch masterRegistrationFailureLatch, CountDownLatch masterUnregistrationSuccessLatch, CountDownLatch masterUnregistrationFailureLatch) {
        this.masterRegistrationSuccessLatch = masterRegistrationSuccessLatch;
        this.masterRegistrationFailureLatch = masterRegistrationFailureLatch;
        this.masterUnregistrationSuccessLatch = masterUnregistrationSuccessLatch;
        this.masterUnregistrationFailureLatch = masterUnregistrationFailureLatch;
    }

    @Override
    public void onMasterRegistrationSuccess(T registrant) {
        this.masterRegistrationSuccessLatch.countDown();
    }

    @Override
    public void onMasterRegistrationFailure(T registrant) {
        this.masterRegistrationFailureLatch.countDown();
    }

    @Override
    public void onMasterUnregistrationSuccess(T registrant) {
        this.masterUnregistrationSuccessLatch.countDown();
    }

    @Override
    public void onMasterUnregistrationFailure(T registrant) {
        this.masterUnregistrationFailureLatch.countDown();
    }

    public void awaitMasterRegistrationSuccess() throws InterruptedException {
        this.masterRegistrationSuccessLatch.await();
    }

    public boolean awaitMasterRegistrationSuccess(long timeout, TimeUnit unit) throws InterruptedException {
        return this.masterRegistrationSuccessLatch.await(timeout, unit);
    }

    public void awaitMasterUnregistrationSuccess() throws InterruptedException {
        this.masterUnregistrationSuccessLatch.await();
    }

    public boolean awaitMasterUnregistrationSuccess(long timeout, TimeUnit unit) throws InterruptedException {
        return this.masterUnregistrationSuccessLatch.await(timeout, unit);
    }

    public void awaitMasterRegistrationFailure() throws InterruptedException {
        this.masterRegistrationFailureLatch.await();
    }

    public boolean awaitMasterRegistrationFailure(long timeout, TimeUnit unit) throws InterruptedException {
        return this.masterRegistrationFailureLatch.await(timeout, unit);
    }

    public void awaitMasterUnregistrationFailure() throws InterruptedException {
        this.masterUnregistrationFailureLatch.await();
    }

    public boolean awaitMasterUnregistrationFailure(long timeout, TimeUnit unit) throws InterruptedException {
        return this.masterUnregistrationFailureLatch.await(timeout, unit);
    }
}

