/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport;

import java.util.concurrent.ExecutorService;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.ros.concurrent.ListenerGroup;
import org.ros.concurrent.SignalRunnable;
import org.ros.internal.transport.ClientHandshake;
import org.ros.internal.transport.ClientHandshakeListener;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.internal.transport.tcp.AbstractNamedChannelHandler;

public abstract class BaseClientHandshakeHandler
extends AbstractNamedChannelHandler {
    private final ClientHandshake clientHandshake;
    private final ListenerGroup<ClientHandshakeListener> clientHandshakeListeners;

    public BaseClientHandshakeHandler(ClientHandshake clientHandshake, ExecutorService executorService) {
        this.clientHandshake = clientHandshake;
        this.clientHandshakeListeners = new ListenerGroup(executorService);
    }

    public void addListener(ClientHandshakeListener clientHandshakeListener) {
        this.clientHandshakeListeners.add(clientHandshakeListener);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        e.getChannel().write((Object)this.clientHandshake.getOutgoingConnectionHeader().encode());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        ConnectionHeader connectionHeader = ConnectionHeader.decode(buffer);
        if (this.clientHandshake.handshake(connectionHeader)) {
            this.onSuccess(connectionHeader, ctx, e);
            this.signalOnSuccess(connectionHeader);
        } else {
            this.onFailure(this.clientHandshake.getErrorMessage(), ctx, e);
            this.signalOnFailure(this.clientHandshake.getErrorMessage());
        }
    }

    protected abstract void onSuccess(ConnectionHeader var1, ChannelHandlerContext var2, MessageEvent var3);

    private void signalOnSuccess(final ConnectionHeader incommingConnectionHeader) {
        this.clientHandshakeListeners.signal(new SignalRunnable<ClientHandshakeListener>(){

            @Override
            public void run(ClientHandshakeListener listener) {
                listener.onSuccess(BaseClientHandshakeHandler.this.clientHandshake.getOutgoingConnectionHeader(), incommingConnectionHeader);
            }
        });
    }

    protected abstract void onFailure(String var1, ChannelHandlerContext var2, MessageEvent var3);

    private void signalOnFailure(final String errorMessage) {
        this.clientHandshakeListeners.signal(new SignalRunnable<ClientHandshakeListener>(){

            @Override
            public void run(ClientHandshakeListener listener) {
                listener.onFailure(BaseClientHandshakeHandler.this.clientHandshake.getOutgoingConnectionHeader(), errorMessage);
            }
        });
    }
}

