/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.queue;

import com.google.common.annotations.VisibleForTesting;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.message.MessageDeserializer;

public class LazyMessage<T> {
    private final ChannelBuffer buffer;
    private final MessageDeserializer<T> deserializer;
    private final Object mutex;
    private T message;

    public LazyMessage(ChannelBuffer buffer, MessageDeserializer<T> deserializer) {
        this.buffer = buffer;
        this.deserializer = deserializer;
        this.mutex = new Object();
    }

    @VisibleForTesting
    LazyMessage(T message) {
        this(null, null);
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.message != null) {
                return this.message;
            }
            this.message = this.deserializer.deserialize(this.buffer);
        }
        return this.message;
    }
}

